/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;

public abstract class AbstractSVMFileGenerator {
    private static double[][] score_matrix = new double[20][20];
    protected LinkedList<AminoAcid> aminList;

    public void setAminList(LinkedList<AminoAcid> aminList) {
        this.aminList = aminList;
    }

    public static double[][] getScoreMatrix() {
        return score_matrix;
    }

    public AbstractSVMFileGenerator(String score_matrix_file_path) {
        File score_matrix_file = new File(score_matrix_file_path);
        AbstractSVMFileGenerator.loadScoreMatrix(score_matrix_file);
    }

    abstract String processSVMLine(int var1, String var2, String var3, String var4);

    abstract LinkedList<String> generateTripletsForSVMSamples(int var1, int var2, int var3, int var4);

    protected static void loadScoreMatrix(File aFile) {
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                int j = 0;
                while (j < 20) {
                    line = input.readLine();
                    int i = 0;
                    while (i < 20) {
                        String number = line.substring(1, line.indexOf(")"));
                        AbstractSVMFileGenerator.score_matrix[i][j] = Double.valueOf(number.replace(',', '.'));
                        line = line.substring(line.indexOf(")") + 1);
                        ++i;
                    }
                    ++j;
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected String processSingleSample(String sample, int featureIndex) {
        String result = "";
        int j = 0;
        while (j < sample.length()) {
            int aindex = AminoAcidTools.getAminoIndexDelphi(sample.charAt(j));
            int i = 1;
            while (i < 21) {
                result = aindex != i ? String.valueOf(result) + String.valueOf(featureIndex) + ':' + String.valueOf(0) + ' ' : String.valueOf(result) + String.valueOf(featureIndex) + ':' + String.valueOf(1) + ' ';
                ++featureIndex;
                ++i;
            }
            ++j;
        }
        return result;
    }
}

