/*
 * Decompiled with CFR 0.152.
 */
public class AminoAcidTools {
    private static char[] aminoacids = new char[]{'I', 'L', 'V', 'F', 'M', 'C', 'A', 'G', 'P', 'T', 'S', 'Y', 'W', 'E', 'N', 'H', 'Q', 'D', 'K', 'R'};
    private static final long ahelix_count = 2217461L;
    private static final long bsheet_count = 1067913L;
    private static final long coil_count = 2500046L;
    private static final long all_count = 5785420L;

    public static double getAhelixPrior() {
        return 0.38328435964891056;
    }

    public static double getBsheetPrior() {
        return 0.18458694442235826;
    }

    public static double getCoilPrior() {
        return 0.4321286959287312;
    }

    public static char getAminoAcid(int index) {
        return aminoacids[index];
    }

    public static byte getAminoIndexDelphi(char amino) {
        int result = -1;
        int i = 0;
        while (i < 20 && result == -1) {
            if (aminoacids[i] == amino) {
                result = i;
            }
            i = (byte)(i + 1);
        }
        return (byte)(result + 1);
    }

    public static byte getAminoIndexJava(char amino) {
        int result = -1;
        int i = 0;
        while (i < 20 && result == -1) {
            if (aminoacids[i] == amino) {
                result = i;
            }
            i = (byte)(i + 1);
        }
        return (byte)result;
    }
}

