/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;

public class BatchDynamic {
    private static String MAIN_PROPERTIES = "cplex_feeder.properties";
    private static String descriptor = "";
    private static Properties prop = new Properties();
    private static LinkedList<String> result_files = new LinkedList();
    private static Runtime r = Runtime.getRuntime();

    public static void Process(File aFile, String currentfolder, String include_substring, String exclude_substring, int iter) {
        String svmResultsFolder = "/projects/net/telomere/cplex/data/";
        if (aFile.isFile() && aFile.getName().endsWith(".ss2") && aFile.getName().contains(include_substring) && !aFile.getName().contains(exclude_substring)) {
            String result_folder = prop.getProperty("result_folder");
            String memory_allocated = prop.getProperty("memory_allocated");
            if (aFile.length() / 1024L > 25L) {
                memory_allocated = "13G";
            }
            String line = "qsub -b y -e junk_qsub_logs -o junk_qsub_logs -cwd -N dyn_" + iter + aFile.getName() + " -l memory=" + memory_allocated + " java -ea -jar " + prop.getProperty("jar_dynamic") + " ";
            line = String.valueOf(line) + MAIN_PROPERTIES + " " + aFile.getName() + " " + currentfolder + " " + iter + " " + Score.segmentFactor + " " + Score.logoFactor + " " + Score.bondFactor + " ";
            System.out.println(String.valueOf(aFile.length()) + " # " + line);
            Process p_Y = null;
            try {
                p_Y = r.exec(line);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result_files.add(String.valueOf(iter) + prop.getProperty("identifier_prefix") + "_" + aFile.getName() + "_results.txt");
        } else if (aFile.isDirectory()) {
            File[] listOfFiles = aFile.listFiles();
            if (listOfFiles != null) {
                int i = 0;
                while (i < listOfFiles.length) {
                    BatchDynamic.Process(listOfFiles[i], aFile.getAbsolutePath(), include_substring, exclude_substring, iter);
                    ++i;
                }
            } else {
                System.out.println(" [ACCESS DENIED]");
            }
        }
    }

    private static void writeRfiles(int iter) {
        boolean wait_flag = true;
        while (wait_flag) {
            boolean wait_more = false;
            for (String res : result_files) {
                File f = new File(res);
                if (f.length() > 0L) continue;
                wait_more = true;
                break;
            }
            if (!wait_more) {
                wait_flag = wait_more;
                continue;
            }
            try {
                Thread.currentThread();
                Thread.sleep(120000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter outFile = new FileWriter(String.valueOf(iter) + prop.getProperty("identifier_prefix") + "_results.txt");
            PrintWriter out = new PrintWriter(outFile);
            ArrayList<ResultRecord> resrec = new ArrayList<ResultRecord>();
            int result_counter = 0;
            int positive_counter = 0;
            for (String filename : result_files) {
                File ff = new File(filename);
                FileInputStream finstream = new FileInputStream(ff);
                DataInputStream in = new DataInputStream(finstream);
                BufferedReader bwInput = new BufferedReader(new InputStreamReader(in));
                String line = bwInput.readLine();
                out.write(String.valueOf(line) + "\n");
                out.flush();
                bwInput.close();
                if (line.indexOf("orezane") != -1) continue;
                double target = Double.parseDouble(line.substring(0, line.indexOf(" ")));
                line = line.substring(line.indexOf("=") + 2);
                double score = Double.parseDouble(line.substring(0, line.indexOf(" ")));
                resrec.add(new ResultRecord(target, score));
                if (target == 1.0) {
                    ++positive_counter;
                }
                ++result_counter;
            }
            out.close();
            Collections.sort(resrec);
            outFile = new FileWriter(String.valueOf(iter) + prop.getProperty("identifier_prefix") + "_roc_points.txt");
            out = new PrintWriter(outFile);
            double x = 0.0;
            double y = 0.0;
            double x_change = 1.0 / (double)positive_counter;
            double y_change = 1.0 / (double)(result_counter - positive_counter);
            for (ResultRecord rec : resrec) {
                if (rec.target == 1.0) {
                    x += x_change;
                }
                if (rec.target == 0.0) {
                    y += y_change;
                }
                out.write(String.valueOf(x) + "\t" + y + "\n");
                out.flush();
            }
            out.close();
            outFile = new FileWriter("R_" + iter + prop.getProperty("identifier_prefix") + ".commands");
            out = new PrintWriter(outFile);
            out.write("a <- read.table(\"" + iter + prop.getProperty("identifier_prefix") + "_results.txt\");\n");
            out.write("attach(a);\n");
            out.write("lrfit <- glm(V1 ~ V2 + V3 + V4, family = binomial );\n");
            out.write("write(lrfit$coefficients, \"" + (iter + 1) + prop.getProperty("identifier_prefix") + "_score_weight.txt\");\n");
            out.write("roc <- read.table(\"" + iter + prop.getProperty("identifier_prefix") + "_roc_points.txt\");\n");
            out.write("attach(roc);\n");
            out.write("jpeg(\"" + iter + prop.getProperty("identifier_prefix") + "_roc_plot.jpg\") ;\n");
            out.write("plot(V1, V2, type=\"l\");");
            out.write("dev.off(); \n");
            out.write("quit();\n");
            out.close();
            outFile = new FileWriter("run_R_" + iter + prop.getProperty("identifier_prefix") + ".sh");
            out = new PrintWriter(outFile);
            out.write(" #!/bin/sh \n");
            out.write("\t R < R_" + iter + prop.getProperty("identifier_prefix") + ".commands --no-save;");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String svmResultsFolder = "/projects/net/telomere/cplex/data/";
        try {
            MAIN_PROPERTIES = args[0];
            prop.load(new FileInputStream(MAIN_PROPERTIES));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            FileWriter outFile = new FileWriter("0" + prop.getProperty("identifier_prefix") + "_score_weight.txt");
            PrintWriter outw = new PrintWriter(outFile);
            outw.write("1 " + prop.getProperty("secstr_score_weight") + " " + prop.getProperty("logo_score_weight") + " " + prop.getProperty("hbond_score_weight"));
            outw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File folder = new File(args[1]);
        int iteration = 0;
        while (iteration < Integer.parseInt(prop.getProperty("iterations"))) {
            long start = System.currentTimeMillis();
            Score.bondFactor = 1.0;
            Score.segmentFactor = 1.0;
            Score.logoFactor = 1.0;
            File weight_file = new File(String.valueOf(String.valueOf(iteration)) + prop.getProperty("identifier_prefix") + "_score_weight.txt");
            if (weight_file.exists()) {
                try {
                    FileInputStream finstream = new FileInputStream(weight_file);
                    DataInputStream in = new DataInputStream(finstream);
                    BufferedReader bwInput = new BufferedReader(new InputStreamReader(in));
                    String weight_line = bwInput.readLine();
                    System.out.println("////////" + weight_line);
                    weight_line = weight_line.substring(weight_line.indexOf(" ") + 1);
                    Double weight = Double.parseDouble(weight_line.substring(0, weight_line.indexOf(" ")));
                    Score.segmentFactor = weight;
                    weight_line = weight_line.substring(weight_line.indexOf(" ") + 1);
                    weight = Double.parseDouble(weight_line.substring(0, weight_line.indexOf(" ")));
                    Score.logoFactor = weight;
                    weight_line = weight_line.substring(weight_line.indexOf(" ") + 1);
                    weight = Double.parseDouble(weight_line);
                    Score.bondFactor = weight;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("no file" + weight_file.getName());
            }
            System.out.println(String.valueOf(iteration) + " - " + " segment weight " + Score.segmentFactor + " logo weight " + Score.logoFactor + " bond weight " + Score.bondFactor);
            BatchDynamic.Process(folder, "", prop.getProperty("include_file_mask"), prop.getProperty("exclude_file_mask"), iteration);
            BatchDynamic.writeRfiles(iteration);
            if (Integer.parseInt(prop.getProperty("iterations")) > 1) {
                String line = "qsub -b y -e junk_qsub_logs -o junk_qsub_logs -sync y -cwd -N R_eval sh run_R_" + iteration + prop.getProperty("identifier_prefix") + ".sh";
                System.out.println(line);
                Runtime r = Runtime.getRuntime();
                try {
                    Process p_Y = r.exec(line);
                    p_Y.waitFor();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                HBondScoreHandler scoreHandler = new HBondScoreHandler(true);
                File svm_cached_folder_Y = new File(String.valueOf(prop.getProperty("svm_cached_folder_Y")) + "/temp");
                File svm_cached_folder_Z = new File(String.valueOf(prop.getProperty("svm_cached_folder_Z")) + "/temp");
                scoreHandler.createAllSvmFileHelper(1, svm_cached_folder_Y, prop.getProperty("svm_cached_folder_Y"));
                scoreHandler.createAllSvmFileHelper(-1, svm_cached_folder_Z, prop.getProperty("svm_cached_folder_Z"));
            }
            long end = System.currentTimeMillis();
            long hours = (end - start) / 1000L / 3600L;
            long minutes = (end - start) / 1000L % 3600L / 60L;
            long seconds = (end - start) / 1000L % 216000L / 60L;
            System.out.println(String.valueOf(iteration) + ". iteration took: " + hours + " h " + minutes + " m " + seconds + " s");
            for (String filename : result_files) {
                File ff = new File(filename);
                ff.delete();
            }
            result_files.clear();
            ++iteration;
        }
    }
}

