/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;

public class Dynamic {
    private static String dynamic_properties;
    private static String sequence_name;
    private String sample_key = "";
    private String first = "";
    private String second = "";
    private static BufferedWriter bw_Y;
    private static BufferedWriter bw_Z;
    private HBondScoreHandler scoreHandler;
    private static double cutoff;
    private SVMScoreStatus bond_score_status;
    public static boolean Debug;
    public static int debugSeg;
    static char[] aminoacids;
    static ArrayList<Integer> sequence;
    static ArrayList<double[]> structureScores;
    static int segments;
    static String[] segmentName;
    static int[] segmentType;
    static int[] segmentMinLength;
    static int[] segmentMaxLength;
    static int[][] segmentsMinDistances;
    static int[][] segmentsMaxDistances;
    static int[] segmentLogoSize;
    static double[][][] logoScores;
    static double[][][][][][] bondScores;
    static boolean[] bondStart;
    static boolean[] bondEnd;
    static boolean[] bondParalel;
    static int[] bondSize;
    static int[] bondStartSeg;
    static int[] bondEndSeg;
    static int[] prevBondStartSeg;
    static int skippedBondStartSeg;
    static int skippedBondEndSeg;
    static int skippedBondSize;
    static boolean skippedBondParalel;
    static Solution[][][][][] bigTable;

    static {
        cutoff = Double.MIN_VALUE;
        Debug = false;
        debugSeg = -1;
        aminoacids = new char[]{'I', 'L', 'V', 'F', 'M', 'C', 'A', 'G', 'P', 'T', 'S', 'Y', 'W', 'E', 'N', 'H', 'Q', 'D', 'K', 'R'};
        bondScores = new double[20][20][20][20][20][20];
        skippedBondStartSeg = -1;
        skippedBondEndSeg = -1;
        skippedBondSize = -1;
    }

    public static String getDynamic_properties() {
        return dynamic_properties;
    }

    public static void setDynamic_properties(String dynamicProperties) {
        dynamic_properties = dynamicProperties;
    }

    public void setKnown_bond_score(SVMScoreStatus bondScoreStatus) {
        this.bond_score_status = bondScoreStatus;
    }

    public static double getCutoff() {
        return cutoff;
    }

    public static void setCutoff(double ct) {
        cutoff = ct;
    }

    public static void setBw(BufferedWriter bw_Y, BufferedWriter bw_Z) {
        Dynamic.bw_Y = bw_Y;
        Dynamic.bw_Z = bw_Z;
    }

    public static void closeWriters() throws IOException {
        bw_Y.close();
        bw_Z.close();
    }

    public void setScoreHandler(HBondScoreHandler sHandler) {
        this.scoreHandler = sHandler;
    }

    public static void doutln(String message) {
        if (Debug) {
            Dynamic.dout(String.valueOf(message) + "  (line " + Thread.currentThread().getStackTrace()[2].getLineNumber() + ")\n");
        }
    }

    public static void dout(String message) {
        if (Debug) {
            System.out.print(debugSeg);
            int i = 0;
            while (i < Thread.currentThread().getStackTrace().length - 6) {
                System.out.print("]]");
                ++i;
            }
            System.out.print(message);
        }
    }

    public static int getAcidCode(char acid) {
        int[][] a = new int[6][];
        int i = 0;
        while (i < aminoacids.length) {
            if (aminoacids[i] == acid) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Aminoacid " + acid + " doesn't exist.");
    }

    private static int getSegmentByName(String name) {
        int i = 0;
        while (i < segments) {
            if (segmentName[i].equals(name)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("No segment of the name " + name + " in input descriptor");
    }

    private static void loadSVMScoresFast(String path) {
        try {
            int i = 0;
            while (i < 20) {
                System.out.print(AminoAcidTools.getAminoAcid(i));
                File f = new File(String.valueOf(path) + "svm_alltable" + AminoAcidTools.getAminoAcid(i) + ".txt_result_polyn7.txt.dat");
                ByteBuffer bb = ByteBuffer.allocateDirect(25600000);
                FileChannel fc2 = new FileInputStream(f).getChannel();
                bb.clear();
                fc2.read(bb);
                bb.rewind();
                int counter = 0;
                while (counter < 3200000) {
                    double d;
                    Dynamic.bondScores[i][counter / 160000 % 20][counter / 8000 % 20][counter / 400 % 20][counter / 20 % 20][counter % 20] = d = bb.getDouble();
                    ++counter;
                }
                fc2.close();
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println();
    }

    private static void loadSequenceAndStructureScores(String filename) {
        try {
            String strLine;
            sequence_name = filename;
            FileInputStream fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            br.readLine();
            br.readLine();
            sequence = new ArrayList();
            structureScores = new ArrayList();
            boolean i = false;
            while ((strLine = br.readLine()) != null) {
                sequence.add(Dynamic.getAcidCode(strLine.charAt(5)));
                double coil_prob = Double.parseDouble(strLine.substring(11, 16));
                double ahelix_prob = Double.parseDouble(strLine.substring(11, 16));
                double bsheet_prob = Double.parseDouble(strLine.substring(11, 16));
                coil_prob = Math.log(Double.parseDouble(strLine.substring(11, 16)) + 0.5);
                ahelix_prob = Math.log(Double.parseDouble(strLine.substring(18, 23)) + 0.5);
                bsheet_prob = Math.log(Double.parseDouble(strLine.substring(25, 30)) + 0.5);
                double[] temp = new double[]{coil_prob, ahelix_prob, bsheet_prob, 0.0};
                structureScores.add(temp);
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void loadDescriptorAndLogoScores(String filename) {
        try {
            FileInputStream fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            if (line != null) {
                segmentName = line.split("\\|");
                segments = segmentName.length;
                segmentType = new int[segments];
                int i = 0;
                while (i < segments) {
                    Dynamic.segmentType[i] = StructureTypes.get(segmentName[i].charAt(0));
                    ++i;
                }
            }
            segmentLogoSize = new int[segments];
            segmentMinLength = new int[segments];
            segmentMaxLength = new int[segments];
            int logos = 0;
            int i = 0;
            while (i < segments) {
                String[] temp = br.readLine().split(" ");
                Dynamic.segmentMinLength[i] = Integer.parseInt(temp[1]);
                Dynamic.segmentMaxLength[i] = Integer.parseInt(temp[2]);
                if (temp.length == 4) {
                    Dynamic.segmentLogoSize[i] = -1;
                    ++logos;
                } else {
                    Dynamic.segmentLogoSize[i] = 0;
                }
                ++i;
            }
            bondStart = new boolean[segments];
            bondEnd = new boolean[segments];
            bondParalel = new boolean[segments];
            bondSize = new int[segments];
            bondStartSeg = new int[segments];
            bondEndSeg = new int[segments];
            i = 0;
            while (i < segments) {
                Dynamic.bondStart[i] = false;
                Dynamic.bondEnd[i] = false;
                Dynamic.bondStartSeg[i] = -1;
                Dynamic.bondEndSeg[i] = -1;
                ++i;
            }
            line = br.readLine();
            int lastBondEnd = 0;
            boolean ignoredBond = false;
            while (line.charAt(0) != '*') {
                String[] temp = line.split(" ");
                int from = Dynamic.getSegmentByName(temp[1]);
                int to = Dynamic.getSegmentByName(temp[2].substring(0, temp[2].length() - 1));
                int size = Integer.parseInt(temp[3]);
                boolean paralel = false;
                if (temp[0].equals("+")) {
                    paralel = true;
                }
                if (from >= lastBondEnd) {
                    lastBondEnd = to;
                    Dynamic.bondStart[from] = true;
                    Dynamic.bondEnd[to] = true;
                    Dynamic.bondStartSeg[to] = from;
                    Dynamic.bondEndSeg[from] = to;
                    Dynamic.bondSize[to] = size;
                    Dynamic.segmentMinLength[from] = Math.max(segmentMinLength[from], 2 * bondSize[from] - 1);
                    Dynamic.segmentMinLength[to] = Math.max(segmentMinLength[to], 2 * bondSize[to] - 1);
                    Dynamic.bondParalel[to] = paralel;
                } else if (!ignoredBond) {
                    System.out.println("This skippped hydrogen bond will be added after computing of the alignment: " + line);
                    ignoredBond = true;
                    skippedBondStartSeg = from;
                    skippedBondEndSeg = to;
                    skippedBondSize = size;
                    skippedBondParalel = paralel;
                } else {
                    throw new Exception("Skipping of only one hydrogen bond is supported!");
                }
                line = br.readLine();
            }
            int seg = 0;
            while (seg < segments) {
                if (bondStart[seg] && (seg == skippedBondStartSeg || seg == skippedBondEndSeg) && bondSize[bondEndSeg[seg]] == skippedBondSize) {
                    Dynamic.segmentMinLength[seg] = 2 * skippedBondSize;
                }
                if (bondEnd[seg] && (seg == skippedBondStartSeg || seg == skippedBondEndSeg) && bondSize[seg] == skippedBondSize) {
                    Dynamic.segmentMinLength[seg] = 2 * skippedBondSize;
                }
                if (bondStart[seg] && bondEnd[seg] && bondSize[seg] == bondSize[bondEndSeg[seg]]) {
                    Dynamic.segmentMinLength[seg] = 2 * bondSize[seg];
                }
                ++seg;
            }
            prevBondStartSeg = new int[segments];
            int lastBondStartSeg = -1;
            int i2 = 0;
            while (i2 < segments) {
                if (bondEnd[i2]) {
                    lastBondStartSeg = -1;
                }
                Dynamic.prevBondStartSeg[i2] = lastBondStartSeg;
                if (bondStart[i2]) {
                    lastBondStartSeg = i2;
                }
                ++i2;
            }
            logoScores = new double[segments][][];
            i2 = 0;
            while (i2 < logos) {
                int logoSize;
                line = br.readLine();
                int seg2 = Dynamic.getSegmentByName(line.split("_")[0]);
                Dynamic.segmentLogoSize[seg2] = logoSize = Integer.parseInt(line.substring(line.indexOf(91) + 1, line.indexOf(93)));
                Dynamic.segmentMinLength[seg2] = Math.max(segmentMinLength[seg2], segmentLogoSize[seg2]);
                Dynamic.logoScores[seg2] = new double[logoSize][20];
                int j = 0;
                while (j < logoSize) {
                    String[] temp = br.readLine().split("\t");
                    int k = 0;
                    while (k < 20) {
                        Dynamic.logoScores[seg2][j][k] = Double.parseDouble(temp[k]);
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            segmentsMaxDistances = new int[segments][segments + 1];
            segmentsMinDistances = new int[segments][segments + 1];
            i2 = 0;
            while (i2 < segments + 1) {
                if (i2 < segments) {
                    Dynamic.segmentMaxLength[i2] = Math.min(segmentMaxLength[i2], sequence.size() - segments + 1);
                }
                int j = 0;
                while (j < i2) {
                    Dynamic.segmentsMaxDistances[j][i2] = segmentsMaxDistances[j][i2 - 1] + segmentMaxLength[i2 - 1];
                    Dynamic.segmentsMinDistances[j][i2] = segmentsMinDistances[j][i2 - 1] + segmentMinLength[i2 - 1];
                    ++j;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static double getLogoScore(int seg, int start) {
        Dynamic.dout(">>> computing sequence motif score for segment:" + seg + " at position:" + start);
        double score = 0.0;
        int i = 0;
        while (i < segmentLogoSize[seg]) {
            score += logoScores[seg][i][sequence.get(start + i)];
            ++i;
        }
        Dynamic.doutln(" >>> score: " + score);
        return score;
    }

    private static String generateKey(int acid1, int acid2, boolean paralel) {
        String first = "";
        String second = "";
        double check_sum = 0.0;
        int i = -2;
        while (i < 3) {
            first = String.valueOf(first) + AminoAcidTools.getAminoAcid(sequence.get(acid1 + i));
            check_sum += structureScores.get(acid1 + i)[2];
            ++i;
        }
        check_sum = 0.0;
        i = -2;
        while (i < 3) {
            if (paralel) {
                second = String.valueOf(second) + AminoAcidTools.getAminoAcid(sequence.get(acid2 + i));
                check_sum += structureScores.get(acid2 + i)[2];
            } else {
                second = String.valueOf(second) + AminoAcidTools.getAminoAcid(sequence.get(acid2 - i));
                check_sum += structureScores.get(acid2 - i)[2];
            }
            ++i;
        }
        return String.valueOf(first) + "~" + second;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getBondComponentScore(int acid1, int acid2, boolean paralel) {
        double check_sum;
        block20: {
            block21: {
                this.sample_key = "";
                if (this.bond_score_status.equals((Object)SVMScoreStatus.bond_scores_known) || this.bond_score_status.equals((Object)SVMScoreStatus.skipped_bond_score_known)) {
                    Double score = this.scoreHandler.getScoreForPositions(acid1, acid2, paralel);
                    if (score != Double.NEGATIVE_INFINITY) {
                        return score;
                    }
                    this.sample_key = Dynamic.generateKey(acid1, acid2, paralel);
                    if (paralel) {
                        score = this.scoreHandler.getYSampleScore(this.sample_key);
                        if (score == null) {
                            return Double.NaN;
                        }
                        this.scoreHandler.setScoreForPositions(acid1, acid2, paralel, score);
                        return score;
                    }
                    score = this.scoreHandler.getZSampleScore(this.sample_key);
                    if (score == null) {
                        return Double.NaN;
                    }
                    this.scoreHandler.setScoreForPositions(acid1, acid2, paralel, score);
                    return score;
                }
                this.first = "";
                this.second = "";
                int i = -2;
                while (i < 3) {
                    this.first = String.valueOf(this.first) + AminoAcidTools.getAminoAcid(sequence.get(acid1 + i));
                    ++i;
                }
                check_sum = 0.0;
                if (!this.bond_score_status.equals((Object)SVMScoreStatus.no_bond_scores)) break block20;
                if (!((check_sum += structureScores.get(acid1)[2]) < cutoff)) break block21;
                return Double.NaN;
            }
            check_sum = 0.0;
            check_sum += structureScores.get(acid2)[2];
            if (!(check_sum < cutoff)) break block20;
            return Double.NaN;
        }
        try {
            check_sum = 0.0;
            int i = -2;
            while (i < 3) {
                if (paralel) {
                    this.second = String.valueOf(this.second) + AminoAcidTools.getAminoAcid(sequence.get(acid2 + i));
                    check_sum += structureScores.get(acid2 + i)[2];
                } else {
                    this.second = String.valueOf(this.second) + AminoAcidTools.getAminoAcid(sequence.get(acid2 - i));
                    check_sum += structureScores.get(acid2 - i)[2];
                }
                ++i;
            }
            this.sample_key = String.valueOf(this.first) + "~" + this.second;
            if (paralel) {
                if (this.scoreHandler.getYFlag(acid1, acid2)) return 0.0;
                try {
                    this.scoreHandler.flag_Y[acid1][acid2] = true;
                    if (this.scoreHandler.contains_YSample(this.sample_key)) return 0.0;
                    this.scoreHandler.setGenerated_Y(true);
                    bw_Y.write(this.scoreHandler.getSvmFileGenerator().processSVMLine(0, this.first, this.second, this.sample_key));
                    bw_Y.newLine();
                    bw_Y.flush();
                    return 0.0;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0;
                }
            }
            if (this.scoreHandler.getZFlag(acid1, acid2)) return 0.0;
            try {
                this.scoreHandler.flag_Z[acid1][acid2] = true;
                if (this.scoreHandler.contains_ZSample(this.sample_key)) return 0.0;
                this.scoreHandler.setGenerated_Z(true);
                bw_Z.write(this.scoreHandler.getSvmFileGenerator().processSVMLine(0, this.first, this.second, this.sample_key));
                bw_Z.newLine();
                bw_Z.flush();
                return 0.0;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return 0.0;
        }
        catch (IndexOutOfBoundsException e) {
            return Double.NaN;
        }
    }

    public double getBondScore(int bondStartSegStart, int bondEndSegStart, int bondSize, boolean paralel) {
        double score = 0.0;
        int offset = 0;
        while (offset < bondSize) {
            score = paralel ? (score += this.getBondComponentScore(bondStartSegStart + offset * 2, bondEndSegStart + offset * 2, paralel)) : (score += this.getBondComponentScore(bondStartSegStart + offset * 2, bondEndSegStart + (bondSize - 1) * 2 - offset * 2, paralel));
            ++offset;
        }
        return score;
    }

    public Bond getIntervalMaxBondScore(int bondStartSegStart, int bondStartSegEnd, int bondEndSegStart, int bondEndSegEnd, int seg, int previousBondEndStartOffset) {
        Dynamic.doutln(" computing score for best placed bond from <" + bondStartSegStart + "," + bondStartSegEnd + ") to <" + bondEndSegStart + "," + bondEndSegEnd + ") ending in segment:" + seg + " previousBondEndStartOffset: " + previousBondEndStartOffset);
        Bond bestBond = new Bond();
        HashSet<Integer> notAvailable = new HashSet<Integer>();
        if (previousBondEndStartOffset != -1) {
            int offset = 0;
            while (offset < bondSize[bondStartSeg[seg]]) {
                notAvailable.add(bondStartSegStart + previousBondEndStartOffset + offset * 2);
                ++offset;
            }
            offset = 0;
            while (offset < bondSize[seg]) {
                notAvailable.add(bondStartSegStart + previousBondEndStartOffset - offset * 2);
                ++offset;
            }
        }
        if (previousBondEndStartOffset != -1) {
            Dynamic.doutln(" bond cannot be opened on this position " + notAvailable);
        }
        int i = bondStartSegStart;
        while (i < bondStartSegEnd - (2 * bondSize[seg] - 1) + 1) {
            if (!notAvailable.contains(i)) {
                int j = bondEndSegStart;
                while (j < bondEndSegEnd - (2 * bondSize[seg] - 1) + 1) {
                    BondScore score = new BondScore(this.getBondScore(i, j, bondSize[seg], bondParalel[seg]));
                    if (score.isGreaterThan(bestBond.score)) {
                        bestBond.score = score;
                        bestBond.start = i;
                        bestBond.end = j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Dynamic.doutln(" best bond score " + bestBond.score.getValue() + ". This bond begins on " + bestBond.start + " and ends on position " + bestBond.end);
        return bestBond;
    }

    public Bond findBestMissingBond(int bondStartSegStart, int bondStartSegEnd, int bondEndSegStart, int bondEndSegEnd, int bondSize, boolean paralel, HashSet<Integer> usedPositions) {
        Bond bestBond = new Bond();
        int i = bondStartSegStart;
        while (i < bondStartSegEnd - (2 * bondSize - 1) + 1) {
            if (!usedPositions.contains(i)) {
                int j = bondEndSegStart;
                while (j < bondEndSegEnd - (2 * bondSize - 1) + 1) {
                    BondScore score;
                    if (!usedPositions.contains(j) && (score = new BondScore(this.getBondScore(i, j, bondSize, paralel))).isGreaterThan(bestBond.score)) {
                        bestBond.score = score;
                        bestBond.start = i;
                        bestBond.end = j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return bestBond;
    }

    public Solution compute(int seg, int segEnd, int prevBondSegStartDistanceFromSegEnd, int prevBondSegLength, int usedByPreviousBondEndingStartOffset) throws Exception {
        debugSeg = seg;
        Dynamic.doutln("********");
        Dynamic.doutln("*CALLED seg: " + seg + " segEnd: " + segEnd + " prevBondSegStartDistanceFromSegEnd: " + prevBondSegStartDistanceFromSegEnd + " prevBondSegLength: " + prevBondSegLength + " usedByPreviousBondEndingStart: " + usedByPreviousBondEndingStartOffset);
        Dynamic.doutln("********");
        Solution solution = new Solution();
        try {
            if (seg < 0) {
                Dynamic.doutln(" seg < 0");
                return new Solution().setScore(new Score());
            }
            if (bigTable[seg][segEnd][prevBondSegStartDistanceFromSegEnd][prevBondSegLength][usedByPreviousBondEndingStartOffset] == null) {
                Dynamic.doutln("not yet computed, let's go!");
                if (bondStart[seg] && prevBondSegStartDistanceFromSegEnd != prevBondSegLength) {
                    Dynamic.doutln(" error: mismatch between length of segment and bond!");
                    Dynamic.doutln(" bondStart[seg] && (segEnd != prevBondSegEnd)");
                    Dynamic.bigTable[seg][segEnd][prevBondSegStartDistanceFromSegEnd][prevBondSegLength][usedByPreviousBondEndingStartOffset] = new Solution();
                } else {
                    int segMinStart = segEnd - segmentMaxLength[seg];
                    int segMaxStart = segEnd - segmentMinLength[seg];
                    Dynamic.doutln(" segMinStart je naivne: " + segMinStart);
                    Dynamic.doutln(" segMaxStart je naivne: " + segMaxStart);
                    segMinStart = Math.max(segMinStart, segmentsMinDistances[0][seg]);
                    Dynamic.doutln(" segMinStart minimal length to align previous segments: " + segMinStart);
                    if (prevBondStartSeg[seg] != -1) {
                        Dynamic.doutln(" som pod vazbou, ktora zacne na segmente " + prevBondStartSeg[seg]);
                        Dynamic.doutln(" segMinStart = Math.max(segMinStart<" + segMinStart + ">, prevBondSegEnd<" + (segEnd - prevBondSegStartDistanceFromSegEnd + prevBondSegLength) + "> + segmentsMinDistances[prevBondStartSeg[seg]<" + prevBondStartSeg[seg] + "> + 1][seg]<" + segmentsMinDistances[prevBondStartSeg[seg] + 1][seg] + ">);");
                        segMinStart = Math.max(segMinStart, segEnd - prevBondSegStartDistanceFromSegEnd + prevBondSegLength + segmentsMinDistances[prevBondStartSeg[seg] + 1][seg]);
                        Dynamic.doutln(" segMaxStart = Math.min(segMaxStart<" + segMaxStart + ">, prevBondSegEnd<" + (segEnd - prevBondSegStartDistanceFromSegEnd + prevBondSegLength) + "> + segmentsMaxDistances[prevBondStartSeg[seg]<" + prevBondStartSeg[seg] + "> + 1][seg]<" + segmentsMaxDistances[prevBondStartSeg[seg] + 1][seg] + ">);");
                        segMaxStart = Math.min(segMaxStart, segEnd - prevBondSegStartDistanceFromSegEnd + prevBondSegLength + segmentsMaxDistances[prevBondStartSeg[seg] + 1][seg]);
                    }
                    if (segMaxStart < segMinStart) {
                        Dynamic.doutln(" POZOR (segMaxStart=" + segMaxStart + " < segMinStart=" + segMaxStart + ") ");
                        Dynamic.bigTable[seg][segEnd][prevBondSegStartDistanceFromSegEnd][prevBondSegLength][usedByPreviousBondEndingStartOffset] = new Solution();
                        return new Solution();
                    }
                    Dynamic.doutln(" segMinStart:" + segMinStart + " segMaxStart:" + segMaxStart);
                    if (bondStart[seg]) {
                        Dynamic.doutln(" v tomto segmente ZACINA vazba");
                        if (segEnd - prevBondSegStartDistanceFromSegEnd < segMinStart || segEnd - prevBondSegStartDistanceFromSegEnd > segMaxStart) {
                            Dynamic.bigTable[seg][segEnd][prevBondSegStartDistanceFromSegEnd][prevBondSegLength][usedByPreviousBondEndingStartOffset] = new Solution();
                            return new Solution();
                        }
                        segMinStart = Math.max(segEnd - prevBondSegStartDistanceFromSegEnd, 2);
                        segMaxStart = segEnd - prevBondSegStartDistanceFromSegEnd;
                        Dynamic.doutln(" segMinStart=" + segMinStart + " segMaxStart=" + segMaxStart);
                    }
                    SegmentScore segmentScore = new SegmentScore(0.0);
                    int i = segMaxStart + 1;
                    while (i < segEnd) {
                        segmentScore = SegmentScore.add(segmentScore, new SegmentScore(structureScores.get(i)[segmentType[seg]]));
                        ++i;
                    }
                    LogoScore logoScore = new LogoScore(0.0);
                    int logoStart = -1;
                    if (segmentLogoSize[seg] > 0) {
                        logoScore.setToNaN();
                        int i2 = segMaxStart + 1;
                        while (i2 < segEnd - segmentLogoSize[seg] + 1) {
                            LogoScore ls = new LogoScore(Dynamic.getLogoScore(seg, i2));
                            if (ls.isGreaterThan(logoScore)) {
                                logoScore = ls;
                                logoStart = i2;
                            }
                            ++i2;
                        }
                    }
                    int prevSegEnd = segMaxStart;
                    while (prevSegEnd >= segMinStart) {
                        LogoScore ls;
                        Dynamic.doutln(" teraz som si vybral prevSegEnd=" + prevSegEnd);
                        segmentScore = SegmentScore.add(segmentScore, new SegmentScore(structureScores.get(prevSegEnd)[segmentType[seg]]));
                        if (segmentLogoSize[seg] > 0 && (ls = new LogoScore(Dynamic.getLogoScore(seg, prevSegEnd))).isGreaterThan(logoScore)) {
                            logoScore = ls;
                            logoStart = prevSegEnd;
                        }
                        if (!bondEnd[seg]) {
                            Dynamic.doutln(" v tomto segmente NEkonci vazba, tak nebudeme vymyslat");
                            Score previousScore = this.compute((int)(seg - 1), (int)prevSegEnd, (int)Math.max((int)(prevBondSegStartDistanceFromSegEnd - (segEnd - prevSegEnd)), (int)0), (int)prevBondSegLength, (int)usedByPreviousBondEndingStartOffset).score;
                            Score currentScore = Score.add(previousScore, new Score(segmentScore, logoScore, new BondScore(0.0)));
                            if (currentScore.isGreaterThan(solution.score)) {
                                solution.seg = seg - 1;
                                solution.segEnd = prevSegEnd;
                                solution.prevBondSegStartDistanceFromSegEnd = Math.max(prevBondSegStartDistanceFromSegEnd - (segEnd - prevSegEnd), 0);
                                solution.prevBondSegLength = prevBondSegLength;
                                solution.usedByPreviousBondEndingStartOffset = usedByPreviousBondEndingStartOffset;
                                solution.logoStart = logoStart;
                                solution.score = currentScore;
                            }
                        } else {
                            Dynamic.doutln(" v tomto segmente KONCI vazba");
                            Dynamic.doutln("prevBondSegStartMin = " + prevSegEnd + " - segmentsMaxDistances[bondStartSeg[seg]][seg + 1]<" + segmentsMaxDistances[bondStartSeg[seg]][seg] + ">");
                            Dynamic.doutln("prevBondSegStartMax = " + prevSegEnd + " - segmentsMinDistances[bondStartSeg[seg]][seg + 1]<" + segmentsMinDistances[bondStartSeg[seg]][seg] + ">");
                            int prevBondSegStartMin = prevSegEnd - segmentsMaxDistances[bondStartSeg[seg]][seg];
                            int prevBondSegStartMax = prevSegEnd - segmentsMinDistances[bondStartSeg[seg]][seg];
                            Dynamic.doutln(" podla vziadelenosti vychadza toto takto:");
                            Dynamic.doutln("  <prevBondSegStartMin, prevBondSegStartMax>=<" + prevBondSegStartMin + ", " + prevBondSegStartMax + ">");
                            Dynamic.doutln(" prevBondSegStartMin = Math.max(" + prevBondSegStartMin + ", segmentsMinDistances[0][bondStartSeg[seg]<" + bondStartSeg[seg] + ">]<" + segmentsMinDistances[0][bondStartSeg[seg]] + ">);");
                            prevBondSegStartMin = Math.max(prevBondSegStartMin, segmentsMinDistances[0][bondStartSeg[seg]]);
                            if (prevBondSegStartMax < prevBondSegStartMin) {
                                Dynamic.doutln(" OOPS (prevBondSegStartMax:" + prevBondSegStartMax + " < prevBondSegStartMin:" + prevBondSegStartMin + ")");
                                Dynamic.doutln(Arrays.toString(segmentsMinDistances[0]));
                                Dynamic.bigTable[seg][segEnd][prevBondSegStartDistanceFromSegEnd][prevBondSegLength][usedByPreviousBondEndingStartOffset] = new Solution();
                                throw new Exception("toto by sa nemalo volat");
                            }
                            Dynamic.doutln(Arrays.toString(segmentsMinDistances[0]));
                            Dynamic.doutln("  <prevBondSegStartMin, prevBondSegStartMax>=<" + prevBondSegStartMin + ", " + prevBondSegStartMax + ">");
                            Bond bestBond = new Bond();
                            int i3 = prevBondSegStartMin;
                            while (i3 <= prevBondSegStartMax) {
                                int prevBondSegLengthMax = segmentMaxLength[bondStartSeg[seg]];
                                prevBondSegLengthMax = Math.min(prevBondSegLengthMax, prevSegEnd - i3 - segmentsMinDistances[bondStartSeg[seg] + 1][seg]);
                                Dynamic.doutln("prevBondSegLengthMin = " + segmentMinLength[bondStartSeg[seg]]);
                                Dynamic.doutln("prevBondSegLengthMax = " + prevBondSegLengthMax + " (povodne " + segmentMaxLength[bondStartSeg[seg]] + ")");
                                int newPrevBondSegLength = segmentMinLength[bondStartSeg[seg]];
                                while (newPrevBondSegLength <= prevBondSegLengthMax) {
                                    Score previousScore;
                                    Dynamic.doutln(" pre hranice segmentu so zaciatkom vazby som vybral <" + i3 + ", " + (i3 + newPrevBondSegLength) + ")");
                                    int usedByPreviousBondEndingStartMinOffset = usedByPreviousBondEndingStartOffset;
                                    int usedByPreviousBondEndingStartMaxOffset = usedByPreviousBondEndingStartOffset;
                                    if (bondEnd[bondStartSeg[seg]]) {
                                        Dynamic.doutln(" !!! vazba ktora tu konci NEMOZE mat lubovolny zaciatok, lebo v segmente jej zaciatku konci predchadzajuca vazba");
                                        usedByPreviousBondEndingStartMinOffset = 0;
                                        usedByPreviousBondEndingStartMaxOffset = newPrevBondSegLength - (2 * bondSize[bondStartSeg[seg]] - 1);
                                        Dynamic.doutln(" !! obsadene mozu byt offsety od " + usedByPreviousBondEndingStartMinOffset + " po " + usedByPreviousBondEndingStartMaxOffset);
                                        previousScore = new Score().setToNaN();
                                        int ubpbes = usedByPreviousBondEndingStartMinOffset;
                                        while (ubpbes <= usedByPreviousBondEndingStartMaxOffset) {
                                            Dynamic.doutln(" nech je obsadeny offset " + ubpbes);
                                            if (bondStart[seg] && bondEnd[seg]) {
                                                Dynamic.doutln("  koniec vazby napevno zacina na: " + (prevSegEnd + usedByPreviousBondEndingStartOffset));
                                                bestBond = this.getIntervalMaxBondScore(i3, i3 + newPrevBondSegLength, prevSegEnd + usedByPreviousBondEndingStartOffset, prevSegEnd + usedByPreviousBondEndingStartOffset + (2 * bondSize[seg] - 1), seg, ubpbes);
                                            } else {
                                                bestBond = this.getIntervalMaxBondScore(i3, i3 + newPrevBondSegLength, prevSegEnd, segEnd, seg, ubpbes);
                                            }
                                            previousScore = this.compute((int)(seg - 1), (int)prevSegEnd, (int)(prevSegEnd - i3), (int)newPrevBondSegLength, (int)ubpbes).score;
                                            Score currentScore = Score.add(previousScore, new Score(segmentScore, logoScore, bestBond.score));
                                            if (currentScore.isGreaterThan(solution.score)) {
                                                solution.seg = seg - 1;
                                                solution.segEnd = prevSegEnd;
                                                solution.prevBondSegStartDistanceFromSegEnd = prevSegEnd - i3;
                                                solution.prevBondSegLength = newPrevBondSegLength;
                                                solution.usedByPreviousBondEndingStartOffset = ubpbes;
                                                solution.logoStart = logoStart;
                                                solution.bondBeginingStart = bestBond.start;
                                                solution.bondEndingStart = bestBond.end;
                                                solution.score = currentScore;
                                            }
                                            ++ubpbes;
                                        }
                                    } else {
                                        Dynamic.doutln(" urcenie vazby, ktora tu konci, nezavisi od predchadzajucich vazbieb");
                                        previousScore = this.compute((int)(seg - 1), (int)prevSegEnd, (int)(prevSegEnd - i3), (int)newPrevBondSegLength, (int)usedByPreviousBondEndingStartOffset).score;
                                        if (bondStart[seg] && bondEnd[seg]) {
                                            Dynamic.doutln("  koniec vazby napevno zacina na: " + (prevSegEnd + usedByPreviousBondEndingStartOffset));
                                            bestBond = this.getIntervalMaxBondScore(i3, i3 + newPrevBondSegLength, prevSegEnd + usedByPreviousBondEndingStartOffset, prevSegEnd + usedByPreviousBondEndingStartOffset + (2 * bondSize[seg] - 1), seg, -1);
                                        } else {
                                            bestBond = this.getIntervalMaxBondScore(i3, i3 + newPrevBondSegLength, prevSegEnd, segEnd, seg, -1);
                                        }
                                        Score currentScore = Score.add(previousScore, new Score(segmentScore, logoScore, bestBond.score));
                                        if (currentScore.isGreaterThan(solution.score)) {
                                            solution.seg = seg - 1;
                                            solution.segEnd = prevSegEnd;
                                            solution.prevBondSegStartDistanceFromSegEnd = prevSegEnd - i3;
                                            solution.prevBondSegLength = newPrevBondSegLength;
                                            solution.usedByPreviousBondEndingStartOffset = usedByPreviousBondEndingStartOffset;
                                            solution.logoStart = logoStart;
                                            solution.bondBeginingStart = bestBond.start;
                                            solution.bondEndingStart = bestBond.end;
                                            solution.score = currentScore;
                                        }
                                    }
                                    ++newPrevBondSegLength;
                                }
                                ++i3;
                            }
                        }
                        --prevSegEnd;
                    }
                    Dynamic.bigTable[seg][segEnd][prevBondSegStartDistanceFromSegEnd][prevBondSegLength][usedByPreviousBondEndingStartOffset] = solution;
                }
            }
            return bigTable[seg][segEnd][prevBondSegStartDistanceFromSegEnd][prevBondSegLength][usedByPreviousBondEndingStartOffset];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("***");
            System.err.println("* EXCEPTION");
            System.err.println("* seg: " + seg + " segEnd: " + segEnd + " prevBondSegStartDistanceFromSegEnd: " + prevBondSegStartDistanceFromSegEnd + " prevBondSegLength: " + prevBondSegLength + " usedByPreviousBondEndingStart: " + usedByPreviousBondEndingStartOffset);
            System.err.println("* segmentType: " + segmentType[seg]);
            e.printStackTrace();
            System.err.println("***");
            throw new Exception("veery bad!");
        }
    }

    public void init(String sequenceFile, String descriptorFile, String svmPath) {
        Dynamic.loadSequenceAndStructureScores(sequenceFile);
        Dynamic.loadDescriptorAndLogoScores(descriptorFile);
        int maxBondPosition = 0;
        int maxBondSegmentSize = 0;
        int maxPrevBondSegStartDistanceFromSegEnd = 0;
        int i = 0;
        while (i < segments) {
            if (bondStart[i]) {
                if (bondEnd[i]) {
                    maxBondPosition = Math.max(maxBondPosition, segmentMaxLength[i] - (2 * bondSize[i] - 1));
                }
                maxBondSegmentSize = Math.max(maxBondSegmentSize, segmentMaxLength[i]);
            }
            if (bondEnd[i]) {
                maxPrevBondSegStartDistanceFromSegEnd = Math.max(maxPrevBondSegStartDistanceFromSegEnd, segmentsMaxDistances[bondStartSeg[i]][i]);
            }
            ++i;
        }
        System.out.println("Creating table " + segments + "x" + (sequence.size() + 1) + "x" + (maxPrevBondSegStartDistanceFromSegEnd + 1) + "x" + (maxBondSegmentSize + 1) + "x" + (maxBondPosition + 1));
        bigTable = new Solution[segments][sequence.size() + 1][maxPrevBondSegStartDistanceFromSegEnd + 1][maxBondSegmentSize + 1][maxBondPosition + 1];
        System.out.println("Table created, memory used by input: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + "MB");
        this.scoreHandler.initializeLookupTables(sequence.size());
    }

    public Solution findBest() {
        Solution bestSolution = new Solution();
        Solution bestEnd = new Solution();
        try {
            int lastSegEnd = sequence.size() - 2;
            while (lastSegEnd >= segments - 1) {
                Solution solution = this.compute(segments - 1, lastSegEnd, 0, 0, 0);
                if (solution.score.isGreaterThan(bestSolution.score)) {
                    bestSolution = solution;
                    bestEnd.seg = segments - 1;
                    bestEnd.segEnd = lastSegEnd;
                    bestEnd.prevBondSegStartDistanceFromSegEnd = 0;
                    bestEnd.prevBondSegLength = 0;
                    bestEnd.usedByPreviousBondEndingStartOffset = 0;
                }
                --lastSegEnd;
            }
        }
        catch (Exception ex) {
            System.err.println("Computation went wrong!");
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
        System.out.println("Total used memory " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + "MB");
        return bestEnd;
    }

    public SolutionWithSkippedBond prepareSolution(Solution endPosition, boolean print) {
        SolutionWithSkippedBond fullSolution = new SolutionWithSkippedBond();
        LinkedList<Solution> solution = fullSolution.solution = new LinkedList();
        Solution temp = endPosition;
        while (true) {
            solution.add(0, temp);
            if (temp.seg == -1) break;
            temp = bigTable[temp.seg][temp.segEnd][temp.prevBondSegStartDistanceFromSegEnd][temp.prevBondSegLength][temp.usedByPreviousBondEndingStartOffset];
        }
        if (solution.size() == 1) {
            return null;
        }
        if (print) {
            int i = 0;
            while (i < segments) {
                System.out.println("segment " + i + " begins at position " + solution.get((int)i).segEnd);
                if (segmentLogoSize[i] > 0) {
                    System.out.print("  has sequence motif aligned at position " + solution.get((int)i).logoStart);
                    System.out.println(" with score " + Dynamic.getLogoScore(i, solution.get((int)i).logoStart));
                }
                if (bondStart[i]) {
                    System.out.println("  has bond starting");
                }
                if (bondEnd[i]) {
                    System.out.print(" and has bond ending here. This bond starts in segment " + bondStartSeg[i] + " at position " + solution.get((int)i).bondBeginingStart + " and ends in this segment at position" + solution.get((int)i).bondEndingStart);
                    System.out.println(" with score " + this.getBondScore(solution.get((int)i).bondBeginingStart, solution.get((int)i).bondEndingStart, bondSize[i], bondParalel[i]));
                }
                ++i;
            }
            System.out.println(solution.get((int)(Dynamic.segments - 1)).score);
        }
        if (skippedBondSize != -1 && this.bond_score_status.equals((Object)SVMScoreStatus.bond_scores_known)) {
            HashSet<Integer> usedPositions = new HashSet<Integer>();
            int missingBondBeginingRestrictingBond = 0;
            while (bondStartSeg[missingBondBeginingRestrictingBond] != skippedBondStartSeg && bondEndSeg[missingBondBeginingRestrictingBond] != skippedBondStartSeg) {
                ++missingBondBeginingRestrictingBond;
            }
            int missingBondEndRestrictingBond = 0;
            while (bondStartSeg[missingBondEndRestrictingBond] != skippedBondEndSeg && bondEndSeg[missingBondEndRestrictingBond] != skippedBondEndSeg) {
                ++missingBondEndRestrictingBond;
            }
            int offset = 0;
            while (offset < bondSize[missingBondBeginingRestrictingBond]) {
                usedPositions.add(solution.get((int)missingBondBeginingRestrictingBond).bondBeginingStart + 2 * offset);
                ++offset;
            }
            offset = 0;
            while (offset < skippedBondSize) {
                usedPositions.add(solution.get((int)missingBondBeginingRestrictingBond).bondBeginingStart - offset * 2);
                ++offset;
            }
            offset = 0;
            while (offset < bondSize[missingBondEndRestrictingBond]) {
                usedPositions.add(solution.get((int)missingBondEndRestrictingBond).bondBeginingStart + 2 * offset);
                ++offset;
            }
            offset = 0;
            while (offset < skippedBondSize) {
                usedPositions.add(solution.get((int)missingBondEndRestrictingBond).bondBeginingStart - offset * 2);
                ++offset;
            }
            String filename = "skippedbond_" + sequence_name.substring(sequence_name.lastIndexOf("/") + 1);
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(dynamic_properties));
                FileOutputStream foutstream_Z = new FileOutputStream(String.valueOf(prop.getProperty("svm_cached_folder_Z")) + "/temp/svm_" + filename + "_" + prop.getProperty("descriptor_file") + "_Z");
                DataOutputStream out_Z = new DataOutputStream(foutstream_Z);
                bw_Z = new BufferedWriter(new OutputStreamWriter(out_Z), 100000);
                FileOutputStream foutstream_Y = new FileOutputStream(String.valueOf(prop.getProperty("svm_cached_folder_Y")) + "/temp/svm_" + filename + "_" + prop.getProperty("descriptor_file") + "_Y");
                DataOutputStream out_Y = new DataOutputStream(foutstream_Y);
                bw_Y = new BufferedWriter(new OutputStreamWriter(out_Y), 100000);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.bond_score_status = SVMScoreStatus.no_skipped_bond_score;
            this.scoreHandler.setGenerated_Y(false);
            this.scoreHandler.setGenerated_Z(false);
            fullSolution.skippedBond = this.findBestMissingBond(solution.get((int)Dynamic.skippedBondStartSeg).segEnd, solution.get((int)(Dynamic.skippedBondStartSeg + 1)).segEnd, solution.get((int)Dynamic.skippedBondEndSeg).segEnd, solution.get((int)(Dynamic.skippedBondEndSeg + 1)).segEnd, skippedBondSize, skippedBondParalel, usedPositions);
            try {
                Dynamic.closeWriters();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.scoreHandler.getSVMResultsForFile(dynamic_properties, filename);
            this.bond_score_status = SVMScoreStatus.skipped_bond_score_known;
            fullSolution.skippedBond = this.findBestMissingBond(solution.get((int)Dynamic.skippedBondStartSeg).segEnd, solution.get((int)(Dynamic.skippedBondStartSeg + 1)).segEnd, solution.get((int)Dynamic.skippedBondEndSeg).segEnd, solution.get((int)(Dynamic.skippedBondEndSeg + 1)).segEnd, skippedBondSize, skippedBondParalel, usedPositions);
            fullSolution.totalScore = Score.add(fullSolution.solution.get((int)(Dynamic.segments - 1)).score, new Score(new SegmentScore(0.0), new LogoScore(0.0), fullSolution.skippedBond.score));
            fullSolution.skippedBondSize = skippedBondSize;
            fullSolution.skippedBondParalel = skippedBondParalel;
        } else {
            fullSolution.totalScore = fullSolution.solution.get((int)(Dynamic.segments - 1)).score;
        }
        return fullSolution;
    }

    public static void generateHtmlSolution(SolutionWithSkippedBond fullSolution, String sequenceLocation, String descriptorLocation, String resultFolder) {
        LinkedList<Solution> solution = fullSolution.solution;
        try {
            FileInputStream fi_sequenceFile = new FileInputStream(sequenceLocation);
            DataInputStream in_sequence = new DataInputStream(fi_sequenceFile);
            BufferedReader brSequenceFile = new BufferedReader(new InputStreamReader(in_sequence));
            String sequenceFilename = sequenceLocation.substring(sequenceLocation.lastIndexOf(47) + 1, sequenceLocation.lastIndexOf(".ss2"));
            String descriptorFilename = descriptorLocation.substring(descriptorLocation.lastIndexOf(47) + 1);
            String resultDir = sequenceLocation.substring(0, sequenceLocation.lastIndexOf(47));
            String resultFilename = String.valueOf(resultFolder) + "/" + sequenceFilename + "." + descriptorFilename + ".html";
            System.out.println("Sequence file: " + sequenceFilename);
            System.out.println("Descriptor file: " + descriptorFilename);
            System.out.println("Result file: " + resultFilename);
            FileOutputStream foutstream = new FileOutputStream(resultFilename);
            DataOutputStream out = new DataOutputStream(foutstream);
            BufferedWriter bwOutput = new BufferedWriter(new OutputStreamWriter(out));
            bwOutput.write("<html>\n");
            bwOutput.write("<head><title>" + descriptorFilename + " on " + sequenceFilename + "</title></head>\n");
            bwOutput.write("<body>\n");
            bwOutput.write("<h1>" + descriptorFilename + " on " + sequenceFilename + "</h1>\n");
            bwOutput.write("<style type=\"text/css\">\n\ttable tr td {text-align:center;\tmargin: 0 auto;}\n</style>\n");
            bwOutput.write("<br/>\n");
            bwOutput.write("<br/>\n");
            bwOutput.write("<table cellspacing=\"3\" border=\"1\">\n");
            String seqLine = "<td>sequence";
            String secstrLine = "<td>sec str";
            brSequenceFile.readLine();
            brSequenceFile.readLine();
            String pom = brSequenceFile.readLine();
            int seqCounter = 0;
            String indexLine = "<tr><td> number </td>";
            while (pom != null) {
                indexLine = String.valueOf(indexLine) + "<td>" + seqCounter + "</td>";
                seqLine = String.valueOf(seqLine) + "<td>" + pom.charAt(5) + "</td>";
                char z = pom.charAt(7);
                String color = "black";
                if (z == 'E') {
                    color = "blue";
                }
                if (z == 'H') {
                    color = "red";
                }
                secstrLine = String.valueOf(secstrLine) + "<td><span style=\"color:" + color + "\">" + z + "</span></td>";
                pom = brSequenceFile.readLine();
                ++seqCounter;
            }
            seqLine = String.valueOf(seqLine) + "</td>";
            secstrLine = String.valueOf(secstrLine) + "</td>";
            indexLine = String.valueOf(indexLine) + "</tr>\n";
            bwOutput.write(indexLine);
            bwOutput.write("<tr>");
            bwOutput.write(seqLine);
            bwOutput.write("</tr>\n");
            bwOutput.write("<tr>");
            bwOutput.write(secstrLine);
            bwOutput.write("</tr>\n");
            Object[] segmentsLine = new String[sequence.size()];
            Arrays.fill(segmentsLine, "_");
            Object[] logosLine = new String[sequence.size()];
            Arrays.fill(logosLine, "_");
            Object[] bondsLine = new String[sequence.size()];
            Arrays.fill(bondsLine, "_");
            String secstr_verbose = "";
            int i = 0;
            while (i < segments) {
                int j = solution.get((int)i).segEnd;
                while (j < solution.get((int)(i + 1)).segEnd) {
                    if (sequenceFilename.contains("RK20")) {
                        secstr_verbose = String.valueOf(secstr_verbose) + segmentName[i] + ": " + j + " " + structureScores.get(j)[0] + " " + structureScores.get(j)[1] + " " + structureScores.get(j)[2] + "<br/>";
                    }
                    switch (segmentType[i]) {
                        case 2: {
                            segmentsLine[j] = "<span style='color:blue;'>" + segmentName[i] + "</span>";
                            break;
                        }
                        case 1: {
                            segmentsLine[j] = "<span style='color:red;'>" + segmentName[i] + "</span>";
                            break;
                        }
                        default: {
                            segmentsLine[j] = segmentName[i];
                        }
                    }
                    ++j;
                }
                j = 0;
                while (j < segmentLogoSize[i]) {
                    logosLine[j + solution.get((int)i).logoStart] = segmentName[i];
                    ++j;
                }
                if (bondEnd[i]) {
                    String color = "";
                    switch (i % 5) {
                        case 0: {
                            color = "green";
                            break;
                        }
                        case 1: {
                            color = "red";
                            break;
                        }
                        case 2: {
                            color = "purple";
                            break;
                        }
                        case 3: {
                            color = "blue";
                            break;
                        }
                        case 4: {
                            color = "brown";
                        }
                    }
                    int offset = 0;
                    while (offset < bondSize[i]) {
                        bondsLine[2 * offset + solution.get((int)i).bondBeginingStart] = offset == 0 ? "<span style='color:" + color + ";'><b>" + segmentName[i] + "</b></span>" : "<span style='color:" + color + ";'>" + segmentName[i] + "</span>";
                        bondsLine[2 * offset + solution.get((int)i).bondEndingStart] = bondParalel[i] && offset == 0 || !bondParalel[i] && offset == bondSize[i] - 1 ? "<span style='color:" + color + ";'><b>" + segmentName[i] + "</b></span>" : "<span style='color:" + color + ";'>" + segmentName[i] + "</span>";
                        ++offset;
                    }
                }
                ++i;
            }
            if (fullSolution.skippedBond != null && fullSolution.skippedBond.score.getValue() > Double.NEGATIVE_INFINITY) {
                int offset = 0;
                while (offset < fullSolution.skippedBondSize) {
                    bondsLine[2 * offset + fullSolution.skippedBond.start] = offset == 0 ? "<i><b>X</b></i>" : "<i>X</i>";
                    bondsLine[2 * offset + fullSolution.skippedBond.end] = fullSolution.skippedBondParalel && offset == 0 || !fullSolution.skippedBondParalel && offset == skippedBondSize - 1 ? "<i><b>X</b></i>" : "<i>X</i>";
                    ++offset;
                }
            }
            bwOutput.write("<tr><td> segment results </td>");
            Object[] objectArray = segmentsLine;
            int n = segmentsLine.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                bwOutput.write("<td>" + (String)s + "</td>");
                ++n2;
            }
            bwOutput.write("</tr>\n");
            bwOutput.write("<tr><td> motive results </td>");
            objectArray = logosLine;
            n = logosLine.length;
            n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                bwOutput.write("<td>" + (String)l + "</td>");
                ++n2;
            }
            bwOutput.write("</tr>\n");
            bwOutput.write("<tr><td> bond results </td>");
            objectArray = bondsLine;
            n = bondsLine.length;
            n2 = 0;
            while (n2 < n) {
                Object b = objectArray[n2];
                bwOutput.write("<td>" + (String)b + "</td>");
                ++n2;
            }
            bwOutput.write("</tr>\n");
            bwOutput.write("</table>");
            bwOutput.write("<br/>");
            bwOutput.write(fullSolution.totalScore.toString().replace("\n", "<br/>\n"));
            if (sequenceFilename.contains("RK20")) {
                bwOutput.write("<br/>");
                bwOutput.write(secstr_verbose);
            }
            bwOutput.write("</body>\n");
            bwOutput.write("</html>\n");
            bwOutput.flush();
            bwOutput.close();
            brSequenceFile.close();
            System.out.println("Result written to " + resultFilename);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        long start0 = System.nanoTime();
        String svmResultsFolder = "/projects/net/telomere/cplex/data/";
        if (args.length < 2) {
            System.out.println("Not enought arguments! Expecting: descriptorFile sequenceFile [svmResultsFolder]");
        } else {
            if (args.length > 2) {
                svmResultsFolder = args[2];
            }
            String descriptorFile = args[0];
            String sequenceFile = args[1];
            Score.bondFactor = 1.0;
            Score.segmentFactor = 1.0;
            Score.logoFactor = 1.0;
        }
        long time0 = System.nanoTime() - start0;
        System.out.printf("Took %.3fs to compute.\n", (double)time0 / 1.0E9);
    }

    public static final class StructureTypes {
        public static final int B = 2;
        public static final int A = 1;
        public static final int C = 0;
        public static final int N = 3;

        public static int get(char c) {
            switch (c) {
                case 'B': {
                    return 2;
                }
                case 'A': {
                    return 1;
                }
                case 'C': {
                    return 0;
                }
                case 'N': {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Segment of this type: " + c + " doesn't exist!");
        }
    }
}

