/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class HBondScoreHandler {
    public int window = 5;
    private Map<String, Double> seen_samples_Y = new Hashtable<String, Double>();
    private Map<String, Double> seen_samples_Z = new Hashtable<String, Double>();
    private double[][] lookup_Y;
    private double[][] lookup_Z;
    boolean[][] flag_Y;
    boolean[][] flag_Z;
    private static String SVM_CACHED_FOLDER_Y = "svm_cached_folder_Y";
    private static String SVM_CACHED_FOLDER_Z = "svm_cached_folder_Z";
    private Boolean generated_Y = false;
    private Boolean generated_Z = false;
    private AbstractSVMFileGenerator svmFileGenerator;
    private Boolean verbose = false;

    public void initializeLookupTables(int sequence_length) {
        int j;
        this.lookup_Y = new double[sequence_length][sequence_length];
        this.lookup_Z = new double[sequence_length][sequence_length];
        int i = 0;
        while (i < sequence_length) {
            j = 0;
            while (j < sequence_length) {
                this.lookup_Z[i][j] = Double.NEGATIVE_INFINITY;
                this.lookup_Y[i][j] = Double.NEGATIVE_INFINITY;
                ++j;
            }
            ++i;
        }
        this.flag_Y = new boolean[sequence_length][sequence_length];
        this.flag_Z = new boolean[sequence_length][sequence_length];
        i = 0;
        while (i < sequence_length) {
            j = 0;
            while (j < sequence_length) {
                this.flag_Z[i][j] = false;
                this.flag_Y[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public double getScoreForPositions(int index1, int index2, boolean paralel) {
        if (paralel) {
            return this.lookup_Y[index1][index2];
        }
        return this.lookup_Z[index1][index2];
    }

    public boolean getYFlag(int index1, int index2) {
        return this.flag_Y[index1][index2];
    }

    public boolean getZFlag(int index1, int index2) {
        return this.flag_Z[index1][index2];
    }

    public void setScoreForPositions(int index1, int index2, boolean paralel, double value) {
        if (paralel) {
            this.lookup_Y[index1][index2] = value;
        } else {
            this.lookup_Z[index1][index2] = value;
        }
    }

    public Boolean getGenerated_Z() {
        return this.generated_Z;
    }

    public void setGenerated_Z(Boolean generatedZ) {
        this.generated_Z = generatedZ;
    }

    public Boolean getGenerated_Y() {
        return this.generated_Y;
    }

    public void setGenerated_Y(Boolean generatedY) {
        this.generated_Y = generatedY;
    }

    public void setSvmFileGenerator(AbstractSVMFileGenerator svmFileGenerator) {
        this.svmFileGenerator = svmFileGenerator;
    }

    public AbstractSVMFileGenerator getSvmFileGenerator() {
        return this.svmFileGenerator;
    }

    public void getSVMResultsForFile(String cplex_properties_file, String source_filename) {
        File new_output;
        File new_result;
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(cplex_properties_file));
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        String descriptor = prop.getProperty("descriptor_file");
        String result_folder_Y = String.valueOf(prop.getProperty(SVM_CACHED_FOLDER_Y)) + "/temp";
        String result_folder_Z = String.valueOf(prop.getProperty(SVM_CACHED_FOLDER_Z)) + "/temp";
        String file_core_name = "svm_" + source_filename + "_" + descriptor;
        String svm_samples_prefix_Y = String.valueOf(result_folder_Y) + "/" + file_core_name;
        String svm_samples_prefix_Z = String.valueOf(result_folder_Z) + "/" + file_core_name;
        String svm_samples_Y = String.valueOf(svm_samples_prefix_Y) + "_Y";
        String svm_samples_Z = String.valueOf(svm_samples_prefix_Z) + "_Z";
        Runtime r = Runtime.getRuntime();
        try {
            String line;
            Process p_Y = null;
            Process p_Z = null;
            if (this.generated_Y.booleanValue()) {
                line = String.valueOf(prop.getProperty("svm_classify_path")) + " " + svm_samples_Y + " " + prop.getProperty("svm_model_path_Y") + " " + result_folder_Y + "/" + file_core_name + "_Y.res";
                p_Y = r.exec(line);
                if (this.verbose.booleanValue()) {
                    System.out.println(line);
                }
            }
            if (this.generated_Z.booleanValue()) {
                line = String.valueOf(prop.getProperty("svm_classify_path")) + " " + svm_samples_Z + " " + prop.getProperty("svm_model_path_Z") + " " + result_folder_Z + "/" + file_core_name + "_Z.res";
                p_Z = r.exec(line);
                if (this.verbose.booleanValue()) {
                    System.out.println(line);
                }
            }
            if (this.generated_Y.booleanValue()) {
                p_Y.waitFor();
            }
            if (this.generated_Z.booleanValue()) {
                p_Z.waitFor();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean delete_svm_files = false;
        File svm_output_file = new File(svm_samples_Y);
        File svm_result_file = new File(String.valueOf(svm_samples_Y) + ".res");
        if (this.generated_Y.booleanValue()) {
            System.out.println("*****");
            System.out.println("svm parallel sample file: " + svm_samples_Y);
            System.out.println("svm parallel result file: " + svm_samples_Y + ".res");
            if (svm_result_file.exists()) {
                this.createNewSVMResults(svm_result_file, svm_output_file, 1, delete_svm_files);
                new_result = new File(String.valueOf(prop.getProperty(SVM_CACHED_FOLDER_Y)) + "/temp/cachedResults_" + svm_output_file.getName());
                new_output = new File(String.valueOf(prop.getProperty(SVM_CACHED_FOLDER_Y)) + "/cachedResults_" + svm_output_file.getName());
                if (new_output.exists()) {
                    System.out.println("Svm results collision " + new_result.getName());
                }
            } else {
                System.err.println("no svm result " + svm_result_file.getAbsolutePath());
            }
        }
        svm_output_file.delete();
        svm_result_file.delete();
        svm_output_file = new File(svm_samples_Z);
        svm_result_file = new File(String.valueOf(svm_samples_Z) + ".res");
        if (this.generated_Z.booleanValue()) {
            System.out.println("*****");
            System.out.println("svm antiparallel sample file: " + svm_samples_Z);
            System.out.println("svm antiparallel result file: " + svm_samples_Z + ".res");
            if (svm_result_file.exists()) {
                this.createNewSVMResults(svm_result_file, svm_output_file, -1, delete_svm_files);
                new_result = new File(String.valueOf(prop.getProperty(SVM_CACHED_FOLDER_Z)) + "/temp/cachedResults_" + svm_output_file.getName());
                new_output = new File(String.valueOf(prop.getProperty(SVM_CACHED_FOLDER_Z)) + "/cachedResults_" + svm_output_file.getName());
                if (new_output.exists()) {
                    System.out.println("Svm results collision " + new_result.getName());
                }
            } else {
                System.err.println("no svm result " + svm_result_file.getAbsolutePath());
            }
            System.out.println("*****");
        }
        svm_output_file.delete();
        svm_result_file.delete();
    }

    public HBondScoreHandler(Boolean verbose) {
        this.verbose = verbose;
    }

    public void clearSeenSamples() {
        this.seen_samples_Y.clear();
        this.seen_samples_Z.clear();
    }

    public Double getYSampleScore(String sampleKey) {
        return this.seen_samples_Y.get(sampleKey);
    }

    public Double getZSampleScore(String sampleKey) {
        return this.seen_samples_Z.get(sampleKey);
    }

    public void setZSampleScore(String key, Double value) {
        this.seen_samples_Z.put(key, value);
    }

    public void setYSampleScore(String key, Double value) {
        this.seen_samples_Y.put(key, value);
    }

    public boolean contains_YSample(String key) {
        return this.seen_samples_Y.containsKey(key);
    }

    public boolean contains_ZSample(String key) {
        return this.seen_samples_Z.containsKey(key);
    }

    public void processNewSVMResults(File result_File, int direction) {
        if (result_File.exists()) {
            try {
                String strLine;
                if (this.verbose.booleanValue()) {
                    System.out.println("Processed files: " + result_File.getName() + " " + result_File.getName());
                }
                FileInputStream f_svmresults_stream = new FileInputStream(result_File);
                DataInputStream in_svmresults = new DataInputStream(f_svmresults_stream);
                BufferedReader brSvmResultsInput = new BufferedReader(new InputStreamReader(in_svmresults));
                String key = null;
                int counter = 0;
                while ((strLine = brSvmResultsInput.readLine()) != null) {
                    if (strLine.contains("#")) {
                        key = strLine.substring(0, strLine.indexOf("#"));
                        String valueString = strLine.substring(strLine.indexOf("#") + 1);
                        Double value = Double.parseDouble(valueString);
                        if (direction == 1) {
                            this.setYSampleScore(key, value);
                        } else {
                            this.setZSampleScore(key, value);
                        }
                        ++counter;
                        continue;
                    }
                    System.err.println("ERROR key for sample not found: " + strLine);
                }
                System.out.println("Processed and cached " + counter + " evaluated svm samples.");
                f_svmresults_stream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void createNewSVMResults(File result_File, File svm_File, int direction, Boolean delete_temp_files) {
        try {
            String strLine;
            if (this.verbose.booleanValue()) {
                System.out.println("Processed files: " + svm_File.getName() + " " + result_File.getName());
            }
            FileInputStream f_svmfile_stream = new FileInputStream(svm_File);
            DataInputStream in_svmfile = new DataInputStream(f_svmfile_stream);
            BufferedReader brSvmFileInput = new BufferedReader(new InputStreamReader(in_svmfile));
            FileInputStream f_svmresults_stream = new FileInputStream(result_File);
            DataInputStream in_svmresults = new DataInputStream(f_svmresults_stream);
            BufferedReader brSvmResultsInput = new BufferedReader(new InputStreamReader(in_svmresults));
            String path = svm_File.getPath();
            FileWriter outFile = new FileWriter(String.valueOf(path.substring(0, path.lastIndexOf("/"))) + "/cachedResults_" + svm_File.getName());
            PrintWriter out = new PrintWriter(outFile);
            if (this.verbose.booleanValue()) {
                System.out.println("Results of svm samples stored in: " + path.substring(0, path.lastIndexOf("/")) + "/cachedResults_" + svm_File.getName());
            }
            int counter = 0;
            while ((strLine = brSvmFileInput.readLine()) != null) {
                if (!strLine.contains("#")) continue;
                String key = strLine.substring(strLine.indexOf("#") + 1).trim();
                String valueString = brSvmResultsInput.readLine();
                out.print(String.valueOf(key) + "#" + valueString + "\n");
                out.flush();
                Double value = Double.parseDouble(valueString);
                if (direction == 1) {
                    this.setYSampleScore(key, value);
                } else {
                    this.setZSampleScore(key, value);
                }
                ++counter;
            }
            System.out.println("Processed and cached " + counter + " evaluated svm samples.");
            strLine = brSvmFileInput.readLine();
            if (strLine != null) {
                System.err.print("TU");
            }
            out.close();
            f_svmfile_stream.close();
            f_svmresults_stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int processSVMResults(File result_File, File svm_File, int direction, Boolean delete_temp_files) {
        int counter = 0;
        try {
            String strLine;
            FileInputStream f_svmfile_stream = new FileInputStream(svm_File);
            DataInputStream in_svmfile = new DataInputStream(f_svmfile_stream);
            BufferedReader brSvmFileInput = new BufferedReader(new InputStreamReader(in_svmfile));
            FileInputStream f_svmresults_stream = new FileInputStream(result_File);
            DataInputStream in_svmresults = new DataInputStream(f_svmresults_stream);
            BufferedReader brSvmResultsInput = new BufferedReader(new InputStreamReader(in_svmresults));
            while ((strLine = brSvmFileInput.readLine()) != null) {
                if (!strLine.contains("#")) continue;
                String key = strLine.substring(strLine.indexOf("#") + 1).trim();
                String valueString = brSvmResultsInput.readLine();
                Double value = Double.parseDouble(valueString);
                if (direction == 1) {
                    this.setYSampleScore(key, value);
                } else {
                    this.setZSampleScore(key, value);
                }
                ++counter;
            }
            strLine = brSvmFileInput.readLine();
            if (strLine != null) {
                System.err.print("TU");
            }
            f_svmfile_stream.close();
            f_svmresults_stream.close();
            if (delete_temp_files.booleanValue()) {
                svm_File.delete();
                result_File.delete();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return counter;
    }

    public void createAllSvmFileHelper(int direction, File inputFolder, String outputSvmFolder) {
        File allFile = new File(String.valueOf(outputSvmFolder) + "/cachedResults_svm_ALL" + (direction == 1 ? "_Y" : "_Z"));
        this.clearSeenSamples();
        this.processNewSVMResults(allFile, direction);
        File[] listOfFiles = inputFolder.listFiles();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].getName().startsWith("cachedResults_svm") && listOfFiles[i].getName().endsWith(direction == 1 ? "_Y" : "_Z")) {
                    this.mergeNewSVMFiles(allFile, listOfFiles[i], direction);
                }
                ++i;
            }
        }
    }

    public void mergeNewSVMFiles(File allFile, File file, int direction) {
        try {
            String strLine;
            FileInputStream f_svmresults_stream = new FileInputStream(file);
            DataInputStream in_svmresults = new DataInputStream(f_svmresults_stream);
            BufferedReader brSvmResultsInput = new BufferedReader(new InputStreamReader(in_svmresults));
            BufferedWriter writer = new BufferedWriter(new FileWriter(allFile, true));
            System.out.println("Merge to file: " + allFile.getAbsolutePath());
            System.out.println("Source file for merging: " + file.getName());
            String key = null;
            int counter = 0;
            while ((strLine = brSvmResultsInput.readLine()) != null) {
                if (strLine.contains("#")) {
                    key = strLine.substring(0, strLine.indexOf("#"));
                    String valueString = strLine.substring(strLine.indexOf("#") + 1);
                    Double value = Double.parseDouble(valueString);
                    if (direction == 1) {
                        if (this.contains_YSample(key)) continue;
                        this.setYSampleScore(key, value);
                        writer.append(String.valueOf(key) + "#" + valueString);
                        writer.newLine();
                        ++counter;
                        continue;
                    }
                    if (this.contains_ZSample(key)) continue;
                    this.setZSampleScore(key, value);
                    writer.append(String.valueOf(key) + "#" + valueString);
                    writer.newLine();
                    ++counter;
                    continue;
                }
                System.err.println("Neobsahuje kluc: " + strLine);
            }
            System.out.println("Merged keys" + counter);
            ((InputStream)f_svmresults_stream).close();
            writer.close();
            file.delete();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

