/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class ROCTest {
    private static HBondScoreHandler scoreHandler = new HBondScoreHandler(true);
    private static Properties prop = new Properties();
    private static String MAIN_PROPERTIES = "newsvm.properties";

    public static void convertSVMCachedResults(File aFile, int direction) {
        String suffix;
        String string = suffix = direction == 1 ? "_Y" : "_Z";
        if (aFile.isFile() && aFile.getName().endsWith(suffix) && aFile.getName().startsWith("svm_")) {
            String sequenceFile = aFile.getName();
            System.out.println("Svm cached result: " + sequenceFile);
            File result_File = new File(String.valueOf(aFile.getAbsolutePath()) + ".res");
            if (result_File.exists()) {
                scoreHandler.createNewSVMResults(result_File, aFile, direction, false);
            }
        } else if (aFile.isDirectory() && !aFile.getName().contains("temp")) {
            File[] listOfFiles = aFile.listFiles();
            if (listOfFiles != null) {
                int i = 0;
                while (i < listOfFiles.length) {
                    ROCTest.convertSVMCachedResults(listOfFiles[i], direction);
                    ++i;
                }
            } else {
                System.out.println(" [ACCESS DENIED]");
            }
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(MAIN_PROPERTIES);
            prop.load(new FileInputStream(MAIN_PROPERTIES));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File svm_cached_folder_Y = new File(String.valueOf(prop.getProperty("svm_cached_folder_Y")) + "/temp");
        File svm_cached_folder_Z = new File(String.valueOf(prop.getProperty("svm_cached_folder_Z")) + "/temp");
        scoreHandler.createAllSvmFileHelper(1, svm_cached_folder_Y, prop.getProperty("svm_cached_folder_Y"));
        scoreHandler.createAllSvmFileHelper(-1, svm_cached_folder_Z, prop.getProperty("svm_cached_folder_Z"));
    }
}

