/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class RunDynamic {
    private static boolean verbose = false;
    public static String MAIN_PROPERTIES = "cplex_feeder.properties";
    static Dynamic dynamic = new Dynamic();
    private static Properties prop = new Properties();
    private HBondScoreHandler scoreHandler;

    public void loadSVMCachedResults(File aFile, int direction) {
        String suffix;
        String string = suffix = direction == 1 ? "_Y" : "_Z";
        if (aFile.isFile() && aFile.getName().endsWith(suffix) && aFile.getName().startsWith("new_svm_")) {
            String sequenceFile = aFile.getName();
            System.out.println("Svm cached result: " + sequenceFile);
            this.scoreHandler.processNewSVMResults(aFile, direction);
        } else if (aFile.isDirectory() && !aFile.getName().contains("temp")) {
            File[] listOfFiles = aFile.listFiles();
            if (listOfFiles != null) {
                int i = 0;
                while (i < listOfFiles.length) {
                    this.loadSVMCachedResults(listOfFiles[i], direction);
                    ++i;
                }
            } else {
                System.out.println(" [ACCESS DENIED]");
            }
        }
    }

    private void setup(String properties_file) {
        try {
            MAIN_PROPERTIES = properties_file;
            System.out.println("Properties file: " + MAIN_PROPERTIES);
            prop.load(new FileInputStream(MAIN_PROPERTIES));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        verbose = new String("true").equals(prop.getProperty("verbose"));
        if (verbose) {
            System.out.println("*****");
            System.out.println("Verbose output on.");
            System.out.println("*****");
        }
        this.scoreHandler = new HBondScoreHandler(verbose);
        AbstractSVMFileGenerator svmGenerator = null;
        try {
            if (verbose) {
                System.out.println("SVM classifier: " + prop.getProperty("svm_generator_classname"));
                System.out.println("Score matrix: " + prop.getProperty("score_matrix_file"));
            }
            Class<?> c = Class.forName(prop.getProperty("svm_generator_classname"));
            Constructor<?>[] cons = c.getConstructors();
            svmGenerator = (AbstractSVMFileGenerator)cons[0].newInstance(prop.getProperty("score_matrix_file"));
        }
        catch (InstantiationException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.scoreHandler.setSvmFileGenerator(svmGenerator);
        dynamic.setScoreHandler(this.scoreHandler);
        Dynamic.setCutoff(Double.parseDouble(prop.getProperty("cutoff")));
        File svm_cached_folder_Y = new File(prop.getProperty("svm_cached_folder_Y"));
        File svm_cached_folder_Z = new File(prop.getProperty("svm_cached_folder_Z"));
        if (!svm_cached_folder_Y.exists()) {
            if (verbose) {
                System.out.println("creating temporary folder for parallel svm samples");
            }
            svm_cached_folder_Y.mkdirs();
            new File(String.valueOf(prop.getProperty("svm_cached_folder_Y")) + "/temp").mkdir();
        }
        if (!svm_cached_folder_Z.exists()) {
            if (verbose) {
                System.out.println("creating temporary folder for antiparallel svm samples");
            }
            svm_cached_folder_Z.mkdirs();
            new File(String.valueOf(prop.getProperty("svm_cached_folder_Z")) + "/temp").mkdir();
        }
        this.loadSVMCachedResults(svm_cached_folder_Y, 1);
        this.loadSVMCachedResults(svm_cached_folder_Z, -1);
    }

    public static void main(String[] args) {
        Runtime runtime = Runtime.getRuntime();
        RunDynamic run = new RunDynamic();
        long start = System.currentTimeMillis();
        run.setup(args[0]);
        long end = System.currentTimeMillis();
        System.out.println("Setup: Cached SVM loaded in " + (end - start) / 1000L + "seconds");
        String descriptor = prop.getProperty("descriptor_file");
        String result_folder = prop.getProperty("result_folder");
        File res_folder = new File(result_folder);
        if (!res_folder.exists()) {
            res_folder.mkdirs();
        }
        String sequenceFile = args[1];
        try {
            FileOutputStream foutstream = new FileOutputStream(String.valueOf(result_folder) + "/" + prop.getProperty("identifier_prefix") + "_" + sequenceFile + "_results.txt");
            DataOutputStream out = new DataOutputStream(foutstream);
            BufferedWriter bwOutput = new BufferedWriter(new OutputStreamWriter(out));
            System.out.println();
            System.out.println("********BEGIN*********");
            String output = sequenceFile.substring(sequenceFile.lastIndexOf("/") + 1, sequenceFile.lastIndexOf(".ss2"));
            String currentfolder = System.getProperty("user.dir");
            if (verbose) {
                System.out.println("Current folder: " + currentfolder);
            }
            BufferedWriter bwOutput_Y = null;
            try {
                FileOutputStream foutstream_Y = new FileOutputStream(String.valueOf(prop.getProperty("svm_cached_folder_Y")) + "/temp/svm_" + output + "_" + descriptor + "_Y");
                DataOutputStream out_Y = new DataOutputStream(foutstream_Y);
                bwOutput_Y = new BufferedWriter(new OutputStreamWriter(out_Y), 100000);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BufferedWriter bwOutput_Z = null;
            try {
                FileOutputStream foutstream_Z = new FileOutputStream(String.valueOf(prop.getProperty("svm_cached_folder_Z")) + "/temp/svm_" + output + "_" + descriptor + "_Z");
                DataOutputStream out_Z = new DataOutputStream(foutstream_Z);
                bwOutput_Z = new BufferedWriter(new OutputStreamWriter(out_Z), 100000);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Dynamic.setCutoff(Double.parseDouble(prop.getProperty("cutoff")));
            Dynamic.setBw(bwOutput_Y, bwOutput_Z);
            System.out.println("Processing file: " + sequenceFile);
            start = System.currentTimeMillis();
            String svmResultsFolder = "/projects/net/telomere/cplex/data/";
            dynamic.init(String.valueOf(currentfolder) + "/" + sequenceFile, descriptor, svmResultsFolder);
            end = System.currentTimeMillis();
            System.out.println("Init in " + (end - start) / 1000L + "seconds");
            start = end;
            Score.segmentFactor = Double.parseDouble(args[2]);
            Score.logoFactor = Double.parseDouble(args[3]);
            Score.bondFactor = Double.parseDouble(args[4]);
            run.scoreHandler.setGenerated_Y(false);
            run.scoreHandler.setGenerated_Z(false);
            dynamic.setKnown_bond_score(SVMScoreStatus.no_bond_scores);
            Dynamic.setDynamic_properties(MAIN_PROPERTIES);
            System.out.println("Generating SVM samples for hydrogen bonds.");
            SolutionWithSkippedBond solution = dynamic.prepareSolution(dynamic.findBest(), false);
            end = System.currentTimeMillis();
            System.out.println("SVM samples generated in " + (end - start) / 1000L + "seconds");
            System.out.println("Evaluating SVM samples for hydrogen bonds.");
            start = end;
            try {
                Dynamic.closeWriters();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (solution != null) {
                System.gc();
                run.scoreHandler.getSVMResultsForFile(MAIN_PROPERTIES, output);
                end = System.currentTimeMillis();
                System.out.println(" SVM samples processed in " + (end - start) / 1000L + "seconds");
                start = end;
                Dynamic.setCutoff(Double.parseDouble(prop.getProperty("cutoff")));
                Dynamic.setDynamic_properties(MAIN_PROPERTIES);
                dynamic.init(String.valueOf(currentfolder) + "/" + sequenceFile, descriptor, svmResultsFolder);
                dynamic.setKnown_bond_score(SVMScoreStatus.bond_scores_known);
                solution = dynamic.prepareSolution(dynamic.findBest(), false);
                end = System.currentTimeMillis();
                System.out.println(" Solution computed in " + (end - start) / 1000L + "seconds");
                if (solution != null) {
                    Dynamic.generateHtmlSolution(solution, String.valueOf(currentfolder) + "/" + sequenceFile, descriptor, result_folder);
                    String target = "";
                    if (currentfolder.contains("negative")) {
                        target = "0";
                    } else if (currentfolder.contains("positive")) {
                        target = "1";
                    }
                    String line = String.valueOf(target) + " " + solution.getResutsScore() + "\t= " + solution.totalScore.getTotalScore() + " start descriptor: " + solution.solution.get((int)0).segEnd + " end position: " + solution.solution.get((int)(Dynamic.segments - 1)).segEnd + " #" + args[1] + " weights: " + Score.segmentFactor + " " + Score.logoFactor + " " + Score.bondFactor;
                    try {
                        bwOutput.write(line);
                        bwOutput.newLine();
                        bwOutput.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    String line = String.valueOf(sequenceFile) + " - no feasible alignment due to cut off: " + Dynamic.getCutoff();
                    try {
                        bwOutput.write(line);
                        bwOutput.newLine();
                        bwOutput.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String line = String.valueOf(sequenceFile) + " - no feasible alignment due to cut off: " + Dynamic.getCutoff();
                try {
                    bwOutput.write(line);
                    bwOutput.newLine();
                    bwOutput.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("********END*********");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
    }
}

