/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class SVMSingleBondGenerator
extends AbstractSVMFileGenerator {
    private int window = 3;

    public SVMSingleBondGenerator(String score_matrix_file_path) {
        super(score_matrix_file_path);
    }

    @Override
    public String processSVMLine(int target, String first, String last, String comment) {
        String result = null;
        result = String.valueOf(String.valueOf(target)) + " ";
        int featureIndex = 1;
        double pairScore = AbstractSVMFileGenerator.getScoreMatrix()[AminoAcidTools.getAminoIndexJava(first.charAt(2))][AminoAcidTools.getAminoIndexJava(last.charAt(2))];
        result = String.valueOf(result) + String.valueOf(featureIndex) + ':' + String.valueOf(pairScore) + ' ';
        result = String.valueOf(result) + this.processSingleSample(first, ++featureIndex);
        result = String.valueOf(result) + this.processSingleSample(first, featureIndex += first.length() * 20);
        result = !comment.equals("") ? String.valueOf(result) + " #" + comment : String.valueOf(result) + " #" + first + ' ' + last;
        return result;
    }

    @Override
    public LinkedList<String> generateTripletsForSVMSamples(int index1, int index2, int dir, int length) {
        LinkedList<String> samplesList = new LinkedList<String>();
        int i = 0;
        while (i < length) {
            int ind1 = index1 + 2 * i;
            int ind2 = index2 + dir * 2 * i;
            String sample1 = "";
            String sample2 = "";
            int j = -(this.window - 1);
            while (j <= this.window - 1) {
                if (ind1 + j < 0 || ind2 + dir * j < 0 || ind1 + j > this.aminList.size() || ind2 + dir * j > this.aminList.size()) {
                    return null;
                }
                sample1 = String.valueOf(sample1) + ((AminoAcid)this.aminList.get(ind1 + j)).getAminoAcid();
                sample2 = String.valueOf(sample2) + ((AminoAcid)this.aminList.get(ind2 + dir * j)).getAminoAcid();
                ++j;
            }
            if (sample1.length() + sample2.length() == (this.window + this.window - 1) * 2) {
                samplesList.add(String.valueOf(sample1) + "~" + sample2);
            }
            ++i;
        }
        return samplesList;
    }
}

