/*
 * Decompiled with CFR 0.152.
 */
public class Score {
    public static double segmentFactor = 1.0;
    public static double logoFactor = 1.0;
    public static double bondFactor = 1.0;
    public SegmentScore segmentsScore = new SegmentScore();
    public LogoScore logosScore = new LogoScore();
    public BondScore bondsScore = new BondScore();

    Score() {
        this.segmentsScore.setToZero();
        this.logosScore.setToZero();
        this.bondsScore.setToZero();
    }

    Score(SegmentScore sScore, LogoScore lScore, BondScore bScore) {
        this.segmentsScore = sScore;
        this.logosScore = lScore;
        this.bondsScore = bScore;
    }

    public double getTotalScore() {
        return this.segmentsScore.getValue() + this.bondsScore.getValue() + this.logosScore.getValue();
    }

    public Score setToNaN() {
        this.segmentsScore.setToNaN();
        this.logosScore.setToNaN();
        this.bondsScore.setToNaN();
        return this;
    }

    public boolean isGreaterThan(Score s) {
        if (Double.isNaN(this.getTotalScore())) {
            return false;
        }
        if (Double.isNaN(s.getTotalScore())) {
            return true;
        }
        return this.getTotalScore() > s.getTotalScore();
    }

    public String toString() {
        String s = "Total score: " + this.getTotalScore() + "\n";
        s = String.valueOf(s) + " segments:   " + this.segmentsScore.getValue() + " = " + this.segmentsScore.getValue() / segmentFactor + " * " + segmentFactor + "\n";
        s = String.valueOf(s) + " logos:      " + this.logosScore.getValue() + " = " + this.logosScore.getValue() / logoFactor + " * " + logoFactor + "\n";
        s = String.valueOf(s) + " bonds:      " + this.bondsScore.getValue() + " = " + this.bondsScore.getValue() / bondFactor + " * " + bondFactor + "\n";
        return s;
    }

    public static Score add(Score s1, Score s2) {
        Score sum = new Score();
        sum.bondsScore = BondScore.add(s1.bondsScore, s2.bondsScore);
        sum.logosScore = LogoScore.add(s1.logosScore, s2.logosScore);
        sum.segmentsScore = SegmentScore.add(s1.segmentsScore, s2.segmentsScore);
        return sum;
    }

    public static Score max(Score s1, Score s2) {
        if (s1.isGreaterThan(s2)) {
            return s1;
        }
        return s2;
    }

    public String getTotalScoreAsString() {
        return String.valueOf(this.segmentsScore.getValue()) + "\t" + this.logosScore.getValue() + "\t" + this.bondsScore.getValue();
    }
}

