
/**
 * This class provides some general candidate generation functions.
 */
public class CandidateGenerator {

	/**
	 * Adds the current genome of each node into the candidate list
	 */
	public static void addSelf(Phylogeny phylogeny) {
		for (PhylogenyNode node : phylogeny.getNodes()) {
			Genome candidate = new Genome(node.getGenome());
			node.addCandidate(candidate);
		}
	}
	
	/**
	 * Clears the candidates of every INTERNAL node, leaves will keep the candidates
	 */
	public static void clearCandidates(Phylogeny phylogeny) {
		for (PhylogenyNode node : phylogeny.getInternalNodes()) {
			node.clearCandidates();
		}
	}
	
	/**
	 * Adds the candidate of descendants into the candidates list
	 */
	public static void addDescendants(Phylogeny phylogeny) {
		addDescendantsRecursive(phylogeny.getRoot());
	}

	/**
	 * Recursively adds the candidates of descendants into own candidates list
	 */
	private static void addDescendantsRecursive(PhylogenyNode node) {
		if (!node.isLeaf()) {
			addDescendantsRecursive(node.getLeft());
			addDescendantsRecursive(node.getRight());
			for (Genome candidate : node.getLeft().getCandidates()) {
				Genome candidate2 = new Genome(candidate);
				node.addCandidate(candidate2);
			}
			for (Genome candidate : node.getRight().getCandidates()) {
				Genome candidate2 = new Genome(candidate);
				node.addCandidate(candidate2);
			}
		}
	}
	
	public static void addParents(Phylogeny phylogeny) {
		addParentsRecursive(phylogeny.getRoot());
	}

	private static void addParentsRecursive(PhylogenyNode node) {
		if (node.getParent()!=null && !node.isLeaf()) {
			for (Genome candidate: node.getParent().getCandidates()) {
				Genome candidate2 = new Genome(candidate);
				node.addCandidate(candidate2);
			}
		}
		if (!node.isLeaf()) {
			addParentsRecursive(node.getLeft());
			addParentsRecursive(node.getRight());
		}
	}
}
