/**
 * Chromosome Penalty Calculator
 * Allows only single circular or several linear chromosomes.
 */
public class ChromosomePenalty_LC implements ChromosomePenalty {

	@Override
	public float calculatePenalty(Genome genome) {
		int[] chromosomes = genome.getChromosomeCount();
		return calculatePenalty(chromosomes[0], chromosomes[1]);
	}

	private float calculatePenalty(int linear, int circular) {
		if (linear>0) return 2*circular;
		return 2*(circular-1);
	}
}
