import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Candidate generator class
 * <p>Adds the best solutions as candidates.
 */
public class JoinSolutionsCandidateGenerator {

	private int solutionCount;
	private String pathToSolutions;
	private EvolutionModel model;
	
	public JoinSolutionsCandidateGenerator(int solutionCount, String pathToSolutions, EvolutionModel model) {
		this.solutionCount = solutionCount;
		this.pathToSolutions = pathToSolutions;
		this.model = model;
	}
	
	public void generateCandidates(Phylogeny phylogeny) {
		ArrayList<Genome> candidates = new ArrayList<>();
		
		File[] files = new File(pathToSolutions).listFiles();
		if (files==null) return;
		Arrays.sort(files);
		for (int i=0; i<Math.min(solutionCount, files.length); i++) {
			candidates.addAll(parseOutGenomes(files[i]));
		}
		
		for (PhylogenyNode node : phylogeny.getInternalNodes()) {
			for (Genome candidate : candidates) {
				Genome candidateCopy = new Genome(candidate);
				node.addCandidate(candidateCopy);
				Genome candidateMutated = new Genome(candidate);
				model.mutate(candidateMutated);
				node.addCandidate(candidateMutated);
			}
		}
	}

	private List<Genome> parseOutGenomes(File file) {
		ArrayList<Genome> genomes = new ArrayList<>();
		try {
			BufferedReader br = new BufferedReader(new FileReader(file));
			String line;
			while((line=br.readLine())!=null) {
				String parts[] = line.split("\\s+", 3);
				Genome genome = new Genome(parts[2]);
				genomes.add(genome);
			}
		} catch (Exception e) {
			System.out.println("Error JoinSolutionsCandidateGenerator: could not load genomes from solution");
			e.printStackTrace();
		}
		return genomes;
	}
}
