#include "dialog.h"
#include "ui_dialog.h"

void Dialog::done(int r)
{
  if(r == QDialog::Accepted) { // ok was pressed
    QString error = correctValues(); // validate the data 
    if(error=="") {  // no error
      getValues();  // save data
      QDialog::done(r);
    }
    else {  // Data not correct, continue editing
      QMessageBox::warning(this, "Error", error);
    }
  }
  else {    // cancel, close or exc was pressed
    QDialog::done(r);
  }
}

Dialog::Dialog(Helix *helix, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    this->helix=helix;
    ui->setupUi(this);
    ui->upstreamEdit->setText(helix->upstream);
    ui->downstreamEdit->setText(helix->downstream);
    ui->upstreamMismatches->setValue(helix->mismup);
    ui->downstreamMismatches->setValue(helix->mismdown);
    ui->relationCheck->setChecked(helix->relation);
    ui->relationEdit->setText(helix->relationString);
    ui->insertionCount->setValue(helix->insertions);
    ui->insertionLetter->setText(helix->insertionLetter);
    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(accepted()));
}

void Dialog::accepted() {
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

QString Dialog::correctValues() {
  // check if values in dialog are correct
  if(ui->upstreamEdit->text()=="e" || ui->downstreamEdit->text()=="e"
     || ui->upstreamEdit->text()=="" || ui->downstreamEdit->text()=="") {
    return "Helix cannot have length 0";
  }

  //!! more checks
  return "";
}

void Dialog::getValues() {
  // read values from ui to helix structures
  helix->upstream=ui->upstreamEdit->text();
  helix->downstream=ui->downstreamEdit->text();
  helix->mismup=ui->upstreamMismatches->value();
  helix->mismdown=ui->downstreamMismatches->value();
  helix->relation=ui->relationCheck->checkState();
  helix->relationString=ui->relationEdit->text();
  helix->insertionLetter=ui->insertionLetter->text();
  helix->insertions=ui->insertionCount->value();
  if (helix->upstream!="" && helix->downstream!="") {
    helix->a1->loop="Ok";
    helix->a2->loop="Ok";
  } else {
    helix->a1->loop="";
    helix->a2->loop="";
  }
  //!!resize better - take into account blocks of numbers or stars
  helix->resize(helix->upstream.size()*10+10);
}
