#include "edge.h"
#include <assert.h>

Edge::Edge(Node *start, Node *end, QGraphicsItem *parent, QGraphicsScene *scene)
    : QGraphicsLineItem(parent, scene)
{
    source=start;
    target=end;
    setFlag(QGraphicsItem::ItemIsSelectable,true);
    this->mism=0;
    this->myHelix=NULL;
}

Edge::~Edge() {
  if (source->small()) {
    if (source->helixEdge!=NULL) {
      if (source->helixEdge==this) source->helixEdge=NULL;
      else source->loopEdge=NULL;
    } else if (source->loopEdge!=NULL) {
      source->loopEdge=NULL;
    }
    if (source->helixEdge==NULL && source->loopEdge==NULL) {
      delete source;
    }
  } else {
    if (source->loopEdge!=NULL) this->source->loopEdge=NULL;
  }
  if (target->small()) {
    if (target->helixEdge!=NULL) {
      if (target->helixEdge==this) target->helixEdge=NULL;
      else target->loopEdge=NULL;
    } else if (target->loopEdge!=NULL) {
      target->loopEdge=NULL;
    }
    if (target->helixEdge==NULL && target->loopEdge==NULL) {
      delete target;
    }
  } else{
    if (target->loopEdge!=NULL) this->target->loopEdge=NULL;
  }
}

void Edge::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                  QWidget *widget) {
    QPen pen;
    pen.setWidth(3);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(Qt::black);
    if (this->isSelected()|| (myHelix!=NULL && myHelix->isSelected())) pen.setColor(QColor::fromRgb(0,225,0,255));
    else if (this->loop=="e") pen.setStyle(Qt::DashLine);
    else if (this->loop=="") pen.setColor(QColor::fromRgb(220,0,0,255));
    this->setPen(pen);
    painter->setPen(this->pen());
    painter->drawLine(this->line());
}


void Edge::updatePosition() {
    QLineF line(mapFromItem(source, 0, 0), mapFromItem(target, 0, 0));
    setLine(line);
}

Node * Edge::next(Node *node) {
  assert(node);
  if (this->source==node) return this->target;
  assert(this->target==node);
  return this->source;
}

