#ifndef EDGE_H
#define EDGE_H

#include <QtGui>
#include "helix.h"
#include "node.h"

class Node;
class Helix;

class Edge : public QGraphicsLineItem {
public slots:
    void updatePosition();

public:
    Node *source,*target;
    Edge(Node *start, Node *end, QGraphicsItem *parent, QGraphicsScene *scene);
    ~Edge();
    QString loop;
    int mism;
    QString id;
    Helix *myHelix;
    Node* next(Node *node);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
};

#endif // EDGE_H
