#ifndef EDITORSCENE_H
#define EDITORSCENE_H

#include <QGraphicsScene>
#include "edge.h"
#include "helix.h"

class EditorScene : public QGraphicsScene
{
public:
    EditorScene(QObject *parent = 0);
    enum Mode { Move, Connect, Insert };
    QGraphicsLineItem *line;
    QList <Helix *> helices;
    QList <Edge *> edges;
    QList <Node *> nodes;  // [0] = 3'  [1] = 5'

    void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void wheelEvent(QGraphicsSceneWheelEvent *event);
    void deleteItem();
    
    // Edge edge was just added by connecting two nodes with a loop.
    // Does this create a cycle? (true = ok, false = cycle created)
    bool checkCycles(Edge *edge);

    // Edge edge was just added by connecting two nodes with a loop.
    // Does it create a contradiction in strands if this edge 
    // is directed as specified? (direction = 1: source->target, -1: target->source)
    // (true=ok, false = inconsistent direction) 
    bool checkStrand(Edge *edge, int direction);

    // delete edge and any adjacent nodes that have degree 0
    void deleteEdge(Edge *edge); 

public slots:
    void setMode(Mode mode);

private:
    Mode sceneMode;
};

#endif // EDITORSCENE_H
