#ifndef HELIX_H
#define HELIX_H

#include <QtGui>
#include "edge.h"
#include "node.h"

class Edge;
class Node;

class Helix: public QGraphicsItem {
public:
    QVariant itemChange(GraphicsItemChange change, const QVariant &value);
    int length;
    void resize(int length);
    Helix(QGraphicsScene *scene, int length);
    ~Helix();
    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    void setEdges(Edge *edge, int n);
    Node* opposite(Node *node);
    Edge* opposite(Edge *edge);
    Node *a,*b,*c,*d;
    Edge *a1,*a2;
    QString upstream,downstream,id;
    int mismup, mismdown;
    bool relation;
    QString relationString;
    int insertions;
    QString insertionLetter;
};

#endif // HELIX_H
