#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <iostream>
using namespace std;

const char *FORMAT = "Format v.1.1";

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    initialize();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::newScene() {
    for (int i=0;i<scene->edges.size();i++) {
        this->scene->removeItem(scene->edges[i]);
        delete scene->edges[i];
    }
    this->scene->helices.clear();
    this->scene->nodes.clear();
    this->scene->edges.clear();
    this->scene->clear();
    n3 = new Node('3');
    n3->setPos(-20,0);
    n3->setFlag(QGraphicsItem::ItemIsMovable, true);
    this->scene->nodes.insert(0,n3);
    scene->addItem(n3);
    QGraphicsTextItem *id3= new QGraphicsTextItem(n3);
    id3->setHtml("3'");
    id3->setPos(-5,2);
    n5 = new Node('5');
    n5->setPos(30,0);
    n5->setFlag(QGraphicsItem::ItemIsMovable, true);
    this->scene->nodes.insert(1,n5);
    scene->addItem(n5);
    QGraphicsTextItem *id5= new QGraphicsTextItem(n5);
    id5->setHtml("5'");
    id5->setPos(-5,2);

}

void MainWindow::save() {
    QString fileName = QFileDialog::getSaveFileName(this,
        tr("Save file"), ".", tr("Editor save file (*.eds)"));
    if (!fileName.size()) return;
    QFile data(fileName);
    data.open(QIODevice::WriteOnly);
    QDataStream out(&data);

    out << QString(FORMAT);

    //   NODY
    out<<(qint32)scene->nodes.size();
    for (int i=0;i<scene->nodes.size();i++) {
        Node *node=scene->nodes[i];
        out<<(qint32)node->pos().x()<<(qint32)node->pos().y();
    }

    //   HELIXY
    out<<(qint32)scene->helices.size();
    for (int i=0;i<scene->helices.size();i++) {
        Helix *helix=scene->helices[i];
        out<<(qint32)helix->pos().x();
        out<<(qint32)helix->pos().y();
        out<<(qreal)helix->rotation();
        out<<(qint32)helix->length;
        out<<QString(helix->upstream);
        out<<(qint32)helix->mismup;
        out<<QString(helix->downstream);
        out<<(qint32)helix->mismdown;
        out<<helix->relation;
        out<<QString(helix->relationString);
	out<<(qint32)helix->insertions;
        out<<QString(helix->insertionLetter);
    }
    //     ARRRROWS
    out<<(qint32)scene->edges.size();
    for (int i=0;i<scene->edges.size();i++) {
        Edge *edge=scene->edges[i];
        out<<(qint32)edge->mism<<(QString)edge->loop;
        if (scene->nodes.contains(edge->source)) {
            out<<true<<(qint32)scene->nodes.indexOf(edge->source);
        } else {
            Helix *helix=edge->source->helixEdge->myHelix;
            out<<false<<(qint32)scene->helices.indexOf(helix);
            if (helix->a==edge->source) out<<(qint32)1;
            if (helix->b==edge->source) out<<(qint32)2;
            if (helix->c==edge->source) out<<(qint32)3;
            if (helix->d==edge->source) out<<(qint32)4;
        }
        if (scene->nodes.contains(edge->target)) {
            out<<true<<scene->nodes.indexOf(edge->target);
        } else {
            Helix *helix=edge->target->helixEdge->myHelix;
            out<<false<<scene->helices.indexOf(helix);
            if (helix->a==edge->target) out<<(qint32)1;
            if (helix->b==edge->target) out<<(qint32)2;
            if (helix->c==edge->target) out<<(qint32)3;
            if (helix->d==edge->target) out<<(qint32)4;
        }

    }

    data.close();
}

void MainWindow::load() {
    QString fileName = QFileDialog::getOpenFileName(this,
        tr("Load file"), ".", tr("Editor save file (*.eds)"));
    if (!fileName.size()) return;
    QFile data(fileName);
    data.open(QFile::ReadOnly);
    QDataStream in(&data);

    // Check version
    QString format;
    in >> format;
    if(format!=QString(FORMAT)) {
      QMessageBox::warning(this,"Error","Wrong file format.");
      return;
    }

    // remove old objects
    for (int i=0;i<scene->edges.size();i++) {
        this->scene->removeItem(scene->edges[i]);
        delete scene->edges[i];
    }
    this->scene->helices.clear();
    this->scene->nodes.clear();
    this->scene->edges.clear();
    this->scene->clear();

    // read nodes
    qint32 n,x,y;
    in>>n;
    in>>x>>y;
    n3 = new Node('3'); n3->setPos(x,y); 
    n3->setFlag(QGraphicsItem::ItemIsMovable, true); scene->addItem(n3);
    QGraphicsTextItem *id3= new QGraphicsTextItem(n3); 
    id3->setHtml("3'"); id3->setPos(-5,2);
    scene->nodes.insert(0,n3);
    in>>x>>y;
    n5 = new Node('5'); n5->setPos(x,y); 
    n5->setFlag(QGraphicsItem::ItemIsMovable, true); scene->addItem(n5);
    QGraphicsTextItem *id5= new QGraphicsTextItem(n5); 
    id5->setHtml("5'"); id5->setPos(-5,2);
    scene->nodes.insert(1,n5);
    for (int i=2;i<n;i++) {
        in>>x>>y;
        Node *node=new Node('s');
        node->setPos(x,y);
        scene->addItem(node);
        scene->nodes.insert(i,node);
        node->setFlag(QGraphicsItem::ItemIsMovable, true);
    }

    //     HELICES
    in>>n;
    for (int i=0;i<n;i++) {
      qint32 len,mismup,mismdown,insertions;
        qreal rot;
        bool rel;
        QString upstream,downstream,relationString,insertionLetter;
        in>>x>>y>>rot>>len>>upstream>>mismup>>downstream>>mismdown;
	in>>rel>>relationString>>insertions>>insertionLetter;
        Helix *helix=new Helix(this->scene,len);
        scene->helices.insert(scene->helices.size(),helix);
        helix->setRotation(rot);
        helix->setPos(x,y);
        helix->mismdown=mismdown;
        helix->mismup=mismup;
        helix->downstream=downstream;
        helix->upstream=upstream;
        helix->relation=rel;
	helix->relationString=relationString;
	helix->insertions=insertions;
	helix->insertionLetter=insertionLetter;
        if (helix->upstream!="" && helix->downstream!="") {
            helix->a1->loop="Ok";
            helix->a2->loop="Ok";
        } else {
            helix->a1->loop="";
            helix->a2->loop="";
        }
    }
    //  ARROWS
    in>>n;
    for (int i=0;i<n;i++) {
        qint32 mism, hel,ind; QString loop; bool nod;
        Node *source=0,*target=0;
        in>>mism>>loop;
        in>>nod;
        if (nod) {
            in>>ind;
            source=scene->nodes[ind];
        } else {
            in>>hel>>ind;
            if (ind==1) source=scene->helices[hel]->a;
            if (ind==2) source=scene->helices[hel]->b;
            if (ind==3) source=scene->helices[hel]->c;
            if (ind==4) source=scene->helices[hel]->d;
        }
        in>>nod;
        if (nod) {
            in>>ind;
            target=scene->nodes[ind];
        } else {
            in>>hel>>ind;
            if (ind==1) target=scene->helices[hel]->a;
            if (ind==2) target=scene->helices[hel]->b;
            if (ind==3) target=scene->helices[hel]->c;
            if (ind==4) target=scene->helices[hel]->d;
        }

        Edge *edge=new Edge(source,target,0,this->scene);
        edge->mism=mism;
        edge->loop=loop;
        if (source->helixEdge==NULL && source->loopEdge!=NULL) {
            source->helixEdge=source->loopEdge;
            source->loopEdge=NULL;
        }
        if (target->helixEdge==NULL && target->loopEdge!=NULL) {
            target->helixEdge=target->loopEdge;
            target->loopEdge=NULL;
        }
        source->loopEdge=edge;
        target->loopEdge=edge;
        edge->updatePosition();
        this->scene->edges.insert(i,edge);
    }

    data.close();
}

void MainWindow::initialize() {
    connect(ui->actionExit, SIGNAL(triggered()), this, SLOT(close()));
    connect(ui->actionSave, SIGNAL(triggered()), this, SLOT(save()));
    connect(ui->actionLoad, SIGNAL(triggered()), this, SLOT(load()));
    connect(ui->actionNew, SIGNAL(triggered()), this, SLOT(newScene()));
    scene = new EditorScene();
    scene->setSceneRect(-100,-100,200,200);
    ui->graphicsView->setScene(scene);
    n3 = new Node('3');
    n3->setPos(-20,0);
    n3->setFlag(QGraphicsItem::ItemIsMovable, true);
    this->scene->nodes.insert(0,n3);
    scene->addItem(n3);
    QGraphicsTextItem *id3= new QGraphicsTextItem(n3);
    id3->setHtml("3'");
    id3->setPos(-5,2);
    n5 = new Node('5');
    n5->setPos(30,0);
    n5->setFlag(QGraphicsItem::ItemIsMovable, true);
    this->scene->nodes.insert(1,n5);
    scene->addItem(n5);
    QGraphicsTextItem *id5= new QGraphicsTextItem(n5);
    id5->setHtml("5'");
    id5->setPos(-5,2);


    modeGroup = new QButtonGroup;
    modeGroup->addButton(ui->toolButton,int(EditorScene::Move));
    modeGroup->addButton(ui->toolButton_2,int(EditorScene::Connect));
    modeGroup->addButton(ui->toolButton_3,int(EditorScene::Insert));
    connect(modeGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(modeGroupClicked(int)));
    connect(ui->pushButton, SIGNAL(clicked()),SLOT(deleteClicked()));
    connect(ui->pushButton_2,SIGNAL(clicked()),SLOT(editClicked()));
    connect(ui->pushButton_3,SIGNAL(clicked()),SLOT(exportClicked()));
}

void MainWindow::modeGroupClicked(int) {
    scene->setMode(EditorScene::Mode(modeGroup->checkedId()));
}

void MainWindow::deleteClicked() {
    scene->deleteItem();
}

void MainWindow::editClicked() {
    if (scene->selectedItems().size()) {
        QGraphicsItem *temp=scene->selectedItems().first();
        if (temp->type()!=Edge::Type) {
            Dialog dialog(qgraphicsitem_cast<Helix *>(temp));
            dialog.exec();
        } else {
            loopDialog dialog(qgraphicsitem_cast<Edge *>(temp));
            dialog.exec();
        }
    }
}

void MainWindow::exportClicked() {
  QString fileName = QFileDialog::getSaveFileName
    (this, tr("Export descriptor"), ".", tr("Descriptor files (*.des)"));
  if (!fileName.size()) return;
  QFile output(fileName);
  if (!output.open(QFile::WriteOnly | QFile::Truncate)) {
    return;
  }
  QTextStream out(&output);
  
  int s=1,h=1;  
  QQueue <Edge *>loops,helices;
  Node *node=n5, *nnode;
  if (n5->loopEdge==NULL) {
    output.close();
    QMessageBox::warning(this,"Error",
			 "Wrong structure: 5' and 3' not connected.");
    return;
  }
  QString spacer="";
  Edge *edge=n5->loopEdge, *nedge;
  do {
    if (edge->id=="") {
      if (edge->myHelix==NULL) {
	if (edge->loop!="e") {      
	  // "e" oznacuje epsilonovy loop (nadvazujuce helixy)
	  edge->id="s";
	  edge->id.append(QString::number(s));
	  s++;
	}
      } else {
	edge->myHelix->setEdges(edge,h);
	h++;
      }
    }
    if (edge->id!="") {
      out << spacer << edge->id;
      spacer = " ";
      if (edge->id[edge->id.size()-1]!='\'') {
	if (edge->id[0]=='s') loops.enqueue(edge);
	else helices.enqueue(edge);
      }
    }
    nnode=edge->next(node);
    if (nnode->helixEdge!=NULL && nnode->loopEdge!=NULL) {
      nedge=nnode->next(edge);
    } else if (nnode!=n3){
      QMessageBox::warning(this,"Error","Wrong structure: 5' and 3' not connected.");
      output.close();
      return;
    }
    node=nnode;
    edge=nedge;
  } while (nnode!=n3);
  out<<endl;
  while (!helices.empty()) {
    Edge *edge = helices.dequeue();
    Helix *helix = edge->myHelix;
    out << edge->id << " " << helix->mismup << ":" << helix->mismdown;
    if(helix->insertions > 0) {
      out << ":" << helix->insertions;
    }
    out << " " << helix->upstream << ":" << helix->downstream;
    if(helix->insertions > 0) {
      out << ":" << helix->insertionLetter;
    }
    if(helix->relation) {
      out << " " << helix->relationString;
    }
    out << endl; 
    edge->id = "";
  }
  while (!loops.empty()) {
    Edge *edge = loops.dequeue();
    out<<edge->id<<" "<<edge->mism<<" "<<edge->loop<<endl; 
    edge->id="";
  }
  output.close();
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
