#include "node.h"
#include <assert.h>

Node::Node(char nNodeType, QGraphicsItem *parent)
  : QGraphicsItem(parent), nodeType(nNodeType) {
  assert(nodeType=='s' || nodeType=='h' 
	 || nodeType=='3'|| nodeType=='5');
  setFlag(QGraphicsItem::ItemSendsGeometryChanges, true);
  this->loopEdge=NULL;
  this->helixEdge=NULL;
  this->setZValue(10);
}

Node::~Node() {
    if (loopEdge!=NULL) this->loopEdge->~Edge();
    if (helixEdge!=NULL) this->helixEdge->~Edge();
}

bool Node::small() const {
  return nodeType=='s';
}

QRectF Node::boundingRect() const {
    return QRectF(-4.0,-4.0,8.0,8.0);
}

void Node::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget) {
  if (this->small())
    painter->drawEllipse(QPoint(0,0),2,2);
  else
    painter->drawEllipse(QPoint(0,0),4,4);
}

QVariant Node::itemChange(GraphicsItemChange change, const QVariant &value) {
    if (change == QGraphicsItem::ItemPositionChange) {
        if (loopEdge!=NULL) loopEdge->updatePosition();
        if (helixEdge!=NULL) helixEdge->updatePosition();
    }
    return value;
}

Edge* Node::next(Edge *edge) {
  assert(edge);
  if (this->loopEdge==edge) return this->helixEdge;
  assert(helixEdge==edge);
  return this->loopEdge;
}

