#ifndef NODE_H
#define NODE_H

#include <QtGui>
#include "edge.h"

class Edge;

class Node : public QGraphicsItem {
public:
  Node(char nNodeType, QGraphicsItem *parent = 0);
  ~Node();
  char nodeType; //'3' = 3', '5' = 5', 's' = small, 'h' = helix
  bool small() const;
  QRectF boundingRect() const;
  void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
	     QWidget *widget);
  QVariant itemChange(GraphicsItemChange change, const QVariant &value);
  Edge *loopEdge,*helixEdge;
  Edge* next(Edge *edge);
};

#endif // NODE_H
