/*
 * $Id: generalfuncs.h,v 1.3 2011-09-26 06:59:12 laci Exp $
 *
 * Project      : RNA motif searching in genomic sequences
 * Description  : the header file for generalfuncs.cpp
 *
 * Author       : Ladislav Rampasek <rampasek@gmail.com>
 * Institution  : Comenius University in Bratislava
 *
 */

#include <fstream>
#include <string>
using namespace std;

// end program with an error message
extern int die(string errmsg);

// get next noncomment nonempty line from given ifstream
extern bool get_valuable_line(ifstream &fin, string &str);

//normalize the given string = bring to uppercase and replace 'U's by 'T's
extern void normalize_seq(string &seq);

// evaluate if @ch fits @patt according to IUPAC Notation
extern bool fits(char &ch, char &patt);

// evaluate if @ch_strand1 is complementary to @ch_strand2 according to @transf_matrix and IUPAC Notation
extern bool is_complemntary(char &ch_strand1, char &ch_strand2, string &transf_matrix);

// reverse and make complement of the given substring
void reverse_complement(string::iterator first, string::iterator last);

// filter out all whitespaces from the given string @s
extern void filter_whitespaces(string &s);
