#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <vector>

using namespace std;

int main() {
  int n; scanf("%d", &n);
  vector<vector<int> > h(n, vector<int>(n));

  // Nacitame ceny hran
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++) {
      scanf("%d", &h[i][j]);
    }
  }

  // Vyrobime vstup pre CSIP
  FILE *f = fopen("tmp.lp", "w");

  // Najprv celkovy ciel
  fprintf(f, "Minimize\n");
  fprintf(f, "obj: ");
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++) {
      if (i == j) continue;
      fprintf(f, "%d x%d_%d %c", h[i][j], i+1, j+1, j + 2 == n && i + 1 == n ? '\n' : '+');
    }
  }

  // Podmienky
  fprintf(f, "Subject To\n");
  // Do kazdeho vrchola vchadza prave jedna hrana
  for (int i = 0; i < n; i++) {
    fprintf(f, "ci%d: ", i+1);
    for (int j = 0; j < n; j++) {
      if (i == j) continue;
      fprintf(f, "x%d_%d %c", i+1, j+1, (j + 1 == n) || (j+2 == n && i + 1 == n) ? '=' : '+');
    }
    fprintf(f, "1\n");
  }

  // Z kazdeho vrchola vychadza prave jedna hrana
  for (int j = 0; j < n; j++) {
    fprintf(f, "co%d: ", j+1);
    for (int i = 0; i < n; i++) {
      if (i == j) continue;
      fprintf(f, "x%d_%d %c", i+1, j+1, (i + 1 == n) || (i+2 == n && j + 1 == n) ? '=' : '+');
    }
    fprintf(f, "1\n");
  }

  // Podmienky preto, aby sme mali len jeden cyklus
  for (int i = 1; i < n; i++) {
    for (int j = 1; j < n; j++) {
      if (i == j) continue;
      fprintf(f, "cc%d_%d: u%d - u%d + %d x%d_%d <= %d\n",
              i+1, j+1, i+1, j+1, n, i+1, j+1, n-1);
    }
  }

  // Este spomenieme, ze premenne su binarne
  fprintf(f, "Binary\n");
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++) {
      if (i == j) continue;
      fprintf(f, "x%d_%d%c", i+1, j+1, j+2 == n && i+1 == n ? '\n' : ' ');
    }
  }
  fprintf(f, "End");
  fclose(f);

  // Pustime scip
  system("./scip -c \"read tmp.lp\" -c \"optimize\" -c \"write solution tmp.sol\" -c \"q\" >/dev/null");

  // Precitame vystup
  FILE *fs = fopen("tmp.sol", "r");
  char buf[2000];
  vector<int> next(n);
  while (fscanf(fs, "%s", buf)>0) {
    if (buf[0]=='x') {
      char *split = strchr(buf+1, '_');
      split[0] = 0;
      int from = atoi(buf+1);
      int to = atoi(split+1);
      next[from-1] = to - 1;
    }
  }
  int price = 0;
  for (int i = 0; i < next.size(); i++)
    price += h[i][next[i]];
  printf("price: %d\n", price);
 
  vector<int> out;
  int cur = 0;
  do {
    out.push_back(cur);
    cur = next[cur];
  } while (cur != 0);
  if (out.size() != n) {
    printf("nieco je zle\n");
  } else {
    for (int i = 0; i < out.size(); i++)
      printf("%d%c", out[i]+1, i + 1 == n ? '\n' : ' ');
  }
}
