#include <cstdlib>
#include <cstdio>
#include <vector>

using namespace std;

int main() {
  int n, m;
  scanf("%d %d", &n, &m);
  // Zoznam hran
  vector<pair<int, int> > h(m);  
  for (int i = 0; i < m; i++) {
    scanf("%d %d", &h[i].first, &h[i].second);
  }

  // Vyrobime vstup pre CSIP
  FILE *f = fopen("tmp.lp", "w");

  // Najprv celkovy ciel
  fprintf(f, "Minimize\n");
  fprintf(f, "obj: ");
  for (int i = 0; i < n; i++) {
    fprintf(f, "x%d%c", i+1, i + 1 == n ? '\n' : '+');
  }

  // Potom podmienky, pre kazdu hranu jedna
  fprintf(f, "Subject To\n");
  for (int i = 0; i < m; i++) {
    fprintf(f, "c%d: x%d + x%d >= 1\n", i+1, h[i].first, h[i].second);
  }

  // Este spomenieme, ze premenne su binarne
  fprintf(f, "Binary\n");
  for (int i = 0; i < n; i++) {
    fprintf(f, "x%d%c", i+1, i+1 == n ? '\n' : ' ');
  }
  fprintf(f, "End");
  fclose(f);

  // Pustime scip
  system("./scip -c \"read tmp.lp\" -c \"optimize\" -c \"write solution tmp.sol\" -c \"q\" >/dev/null");


  // Precitame vystup (trochu hulvatskym sposobom, ale pre binarne premenne to staci)
  FILE *fs = fopen("tmp.sol", "r");
  char buf[2000];
  while (fscanf(f, "%s", buf)>0) {
    if (buf[0]=='x')
      printf("%s ", buf+1);
  }
  printf("\n");

  fclose(fs);
}
