#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <vector>
#include <set>
#include <unistd.h>

using namespace std;

// Dostane maticu susednosti a zoznam zlych cyklov, vrati ktory vrchol nasleduje za
// ktorym
vector<int> SolveTSP(vector<vector<int> >&h, vector<set<int> >&bad_cycles) {
  int n = h.size();
  // Vyrobime vstup pre CSIP
  FILE *f = fopen("tmp.lp", "w");

  // Najprv celkovy ciel
  fprintf(f, "Minimize\n");
  fprintf(f, "obj: ");
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++) {
      if (i == j) continue;
      fprintf(f, "%d x%d_%d %c", h[i][j], i+1, j+1, j + 2 == n && i + 1 == n ? '\n' : '+');
    }
  }

  // Podmienky
  fprintf(f, "Subject To\n");
  // Do kazdeho vrchola vchadza prave jedna hrana
  for (int i = 0; i < n; i++) {
    fprintf(f, "ci%d: ", i+1);
    for (int j = 0; j < n; j++) {
      if (i == j) continue;
      fprintf(f, "x%d_%d %c", i+1, j+1, (j + 1 == n) || (j+2 == n && i + 1 == n) ? '=' : '+');
    }
    fprintf(f, "1\n");
  }

  // Z kazdeho vrchola vychadza prave jedna hrana
  for (int j = 0; j < n; j++) {
    fprintf(f, "co%d: ", j+1);
    for (int i = 0; i < n; i++) {
      if (i == j) continue;
      fprintf(f, "x%d_%d %c", i+1, j+1, (i + 1 == n) || (i+2 == n && j + 1 == n) ? '=' : '+');
    }
    fprintf(f, "1\n");
  }

  // Podmienky pre kazdy zakazany cyklus
  for (int i = 0; i < bad_cycles.size(); i++) {
    fprintf(f, "bco%d: ", i+1);
    bool first = true;
    for (int j = 0; j < n; j++) {
      for (int k = 0; k < n; k++) {
        if (k == j) continue;
        if (bad_cycles[i].count(j) > 0 && bad_cycles[i].count(k) == 0) {
          if (!first) {
            fprintf(f, " + ");
          }
          first = false;
          fprintf(f, "x%d_%d", j+1, k+1);
        }
      }
    }
    fprintf(f, " >= 1\n");

    fprintf(f, "bci%d: ", i+1);
    first = true;
    for (int j = 0; j < n; j++) {
      for (int k = 0; k < n; k++) {
        if (k == j) continue;
        if (bad_cycles[i].count(j) > 0 && bad_cycles[i].count(k) == 0) {
          if (!first) {
            fprintf(f, " + ");
          }
          first = false;
          fprintf(f, "x%d_%d", k+1, j+1);
        }
      }
    }
    fprintf(f, " >= 1\n");

  }

  // Este spomenieme, ze premenne su binarne
  fprintf(f, "Binary\n");
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++) {
      if (i == j) continue;
      fprintf(f, "x%d_%d%c", i+1, j+1, j+2 == n && i+1 == n ? '\n' : ' ');
    }
  }
  fprintf(f, "End");
  fclose(f);

  // Pustime scip
  system("./scip -c \"read tmp.lp\" -c \"optimize\" -c \"write solution tmp.sol\" -c \"q\" >/dev/null");

  // Precitame vystup
  FILE *fs = fopen("tmp.sol", "r");
  char buf[2000];
  vector<int> next(n);
  while (fscanf(fs, "%s", buf)>0) {
    if (buf[0]=='x') {
      char *split = strchr(buf+1, '_');
      split[0] = 0;
      int from = atoi(buf+1);
      int to = atoi(split+1);
      next[from-1] = to - 1;
    }
  }
  fclose(fs);
  return next;
}

int main() {
  int n; scanf("%d", &n);
  vector<vector<int> > h(n, vector<int>(n));

  // Nacitame ceny hran
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++) {
      scanf("%d", &h[i][j]);
    }
  }

  vector<set<int> > bad_cycles; 
  while (true) {
    vector<int> next = SolveTSP(h, bad_cycles);
    int price = 0;
    for (int i = 0; i < next.size(); i++)
      price += h[i][next[i]];
    printf("current price: %d\n", price);
    // Spocitame cykly
    vector<vector<int> > cycles;
    vector<int> vis(n, false);
    for (int i = 0; i < n; i++) {
      if (vis[i] == true) continue;
      int cur = i;
      vector<int> cycle;
      do {
        if (vis[cur]) return 1;
        cycle.push_back(cur);
        vis[cur] = true;
        cur = next[cur];
      } while (cur != i);
      cycles.push_back(cycle);
    }

    if (cycles.size() == 1) {
      // Ak mame jeden cyklus tak koncime
      vector<int> out = cycles[0];
      for (int i = 0; i < out.size(); i++)
        printf("%d%c", out[i]+1, i + 1 == n ? '\n' : ' ');
      return 0;
    }

    printf("zakazujem %d cykly\n", cycles.size());
    for (int i = 0; i < cycles.size(); i++) {
      bad_cycles.push_back(set<int>(cycles[i].begin(), cycles[i].end()));
    }
  }
}
