import numpy as np
import matplotlib.pyplot as plt
from sklearn import svm

np.random.seed(47)

def gen_data():
  X = []
  y = []
  m = []
  for i in range(200):
    x1 = np.random.uniform(-2, 2)
    x2 = np.random.uniform(-2, 2)
    X.append([x1, x2])
    if (x1 > 0) != (x2 > 0):
      y.append(1)
      m.append('+')
    else:
      y.append(0)
      m.append('o')
  return np.array(X), np.array(y), m

X, y, m = gen_data()

h = .02  # step size in the mesh

# we create an instance of SVM and fit out data.
clf = svm.SVC(kernel='rbf', gamma=1, C=1)
clf.fit(X, y)

# Plot the decision boundary. For that, we will assign a color to each
# point in the mesh [x_min, m_max]x[y_min, y_max].
x_min, x_max = X[:, 0].min() - 1, X[:, 0].max() + 1
y_min, y_max = X[:, 1].min() - 1, X[:, 1].max() + 1
xx, yy = np.meshgrid(np.arange(x_min, x_max, h), np.arange(y_min, y_max, h))
Z = clf.predict(np.c_[xx.ravel(), yy.ravel()])

# Put the result into a color plot
Z = Z.reshape(xx.shape)
plt.pcolormesh(xx, yy, Z, cmap=plt.cm.Paired)

# Plot also the training points
plt.scatter(X[:, 0], X[:, 1], c=(3*y+1))
plt.axis('tight')
plt.show()
