import pandas as pd

reference_countries: list[str] = [
    "Singapore", "Laos", "Zimbabwe", "American Samoa", "Saint Vincent/Grenadines", 
    "Comoros", "Cameroon", "United Arab Emirates", "Ghana", "Norway", "Tunisia", 
    "Honduras", "Sri Lanka", "Romania", "Central African Republic", "British Virgin Islands", "Austria", 
    "Mauritania", "Iceland", "Brunei", "Canada", "Grenada", "China", "Bangladesh", "Burundi"]

def get_data(path: str = "electricity.csv") -> pd.DataFrame:
    return pd.read_csv(path, index_col="Country")

def get_reference_countries(data: pd.DataFrame) -> pd.DataFrame:
    return data.loc[data.index.isin(reference_countries)]

def get_other_countries(data: pd.DataFrame) -> pd.DataFrame:
    return data.loc[~data.index.isin(reference_countries)]
