package graphgui;

/**
 * Rozhranie pre hranu grafu.
 * Každá hrana spája dva rôzne vrcholy u a v.
 * Tieto vrcholy nazývame first a second, pričom first je vždy ten s
 * menším číslom.
 * Okrem má každá hrana priradenú tiež celočíselnú hodnotu (value)
 * a farbu.
 */
public interface Edge {

    /** Vráti prvý vrchol hrany (vrchol s menším id).
     * @return  prvý vrchol hrany */
    public Vertex getFirst();

    /** Vráti id prvého vrchola hrany.
     * @return  id prvého vrchola hrany*/
    public int getFirstId();

    /** Vráti druhý vrchol hrany (vrchol s väčším id). */
    public Vertex getSecond();

    /** Vráti id druhého vrchola hrany. */
    public int getSecondId();

    /** Vráti true, ak zadaný vrchol je jedným z koncových
     * vrcholov hrany */
    public boolean isIncident(Vertex vertex);

    /** Vráti true, ak vrchol so zadaným číslom je jedným z koncových
     * vrcholov hrany */
    public boolean isIncident(int id);

    /** Dostane jeden koncový vrchol a vráti opačný.
     * @throws IllegalArgumentException ak zadaný vrchol nie je na konci hrany
     */
    public Vertex getOtherEnd(Vertex vertex)
    throws IllegalArgumentException;

    /** Dostane id jedného koncového vrcholu a vráti id opačného.
     * @throws IllegalArgumentException ak zadaný vrchol nie je na konci hrany
     */
    public int getOtherEnd(int id)
    throws IllegalArgumentException;

    /** Vráti celočíselnú hodnotu uloženú na hrane. */
    public int getValue();

    /** Nastaví hodnotu hrany na zadané číslo.
     * @param value nová hodnota hrany.
     */
    void setValue(int value);

    /** Vráti meno farby hrany ako String. */
    public String getColorName();

    /**  Nastaví novú farbu hrany z reťazca.
     * @param colorName meno požadovanej novej farby pre hranu.
     * @throws IllegalArgumentException ak meno nereprezentuje platnú farbu
     */
    public void setColorName(String colorName)
    throws IllegalArgumentException;

    /**  Nastaví novú farbu hrany z rgb hodnôt. Tieto hodnoty majú byť
     *  od 0 po 255. Ak dostane čísla mimo rozsahu, hodí výnimku.
     * @param red intenzita červenej (číslo od 0 po 255)
     * @param green intenzita zelenej (číslo od 0 po 255)
     * @param blue intenzita modrej (číslo od 0 po 255)
     * @throws IllegalArgumentException ak hodnoty mimo rozsahu
     */
    public void setColorRgb(int red, int green, int blue)
    throws IllegalArgumentException;
}
