package graphgui;

import javafx.event.ActionEvent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;

/**
 * Trieda, ktorá má obsahovať implementáciu JavaFXovej úlohy A. V
 * tejto triede používajte iba metódy rozhraní Graph, Vertex, Edge a
 * EditorException.  Nevolajte priamo žiadne metódy z iných tried
 * balíčka graphgui. Nemeňte hlavičku konštruktora ani public metódy
 * edit, môžete však samozrejme zmeniť ich telo a pridávať do triedy
 * vlastné metódy, premenné, prípadne pomocné triedy.
 */
public class Editor {

    // POMOCNÁ TRIEDA PRE UKÁŽKOVÝ PRÍKLAD, MEŇTE PODĽA POTREBY
    class MyStage extends Stage {
        Edge edge;

        MyStage(Edge edge) {
            this.edge = edge;
            GridPane pan = new GridPane();
            MyStage dialog = this;

            Color c = Color.web(edge.getColorName());

            final TextField rText = new TextField((int)(c.getRed() * 255) + "");
            final TextField gText = new TextField((int)(c.getGreen() * 255) + "");
            final TextField bText = new TextField((int)(c.getBlue() * 255) + "");
            final Label rLabel = new Label("Red (0-255): ");
            final Label gLabel = new Label("Green (0-255): ");
            final Label bLabel = new Label("Blue (0-255): ");
            Button ok = new Button("OK");

            pan.add(rLabel, 0, 0);
            pan.add(rText, 1, 0);
            pan.add(gLabel, 0, 1);
            pan.add(gText, 1, 1);
            pan.add(bLabel, 0, 2);
            pan.add(bText, 1, 2);
            pan.add(ok, 1, 3);

            ok.setOnAction((ActionEvent event) -> {
                int r, g, b;
                try {
                    r = Integer.parseInt(rText.getText());
                    g = Integer.parseInt(gText.getText());
                    b = Integer.parseInt(bText.getText());
                } catch (Exception e) {
                    showError("Bad color value (should be a number)");
                    return;
                }
                try {
                    if (r >= 0 && g >= 0 && b >= 0
                    && r < 256 && g < 256 && b < 256) {
                        edge.setColorRgb(r, g, b);
                        dialog.close();
                    } else {
                        showError("Bad color value (should be in range 0-255)");
                    }
                } catch (Exception e) {
                    showError("Color could not be set");
                }
            });

            Scene sc = new Scene(pan);
            this.setScene(sc);
        }

        /** Zobrazí dialógové okno s chybovou správou a čaká, kým ho
         * používateľ zavrie. */
        private void showError(String message) {
            Alert error = new Alert(AlertType.ERROR, message);
            error.setHeaderText(null);
            error.initOwner(this);
            error.showAndWait();
        }
    }

    // PREMENNÉ TRIEDY, UPRAVTE SI PODĽA POTREBY
    private Graph graph;

    // KONŠTRUKTOR: NEMEŇTE HLAVIČKU, TELO UPRAVTE PODĽA POTREBY
    /** Konštruktor triedy, ktorý dostane graf. */
    public Editor(Graph graph) {
        this.graph = graph;
    }

    // METÓDA edit: NEMEŇTE HLAVIČKU, TELO UPRAVTE PODĽA POTREBY
    /**
     * Vytvorí a spustí samotné dialógové okno
     * @throws graphgui.EditorException
     */
    public void edit() throws EditorException {
        Edge edge = graph.getSelectedEdge();
        if (edge == null) {
            throw new EditorException("No edge selected");
        }
        MyStage dialog = new MyStage(edge);
        dialog.initStyle(StageStyle.UTILITY);
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.showAndWait();
    }
}
