package graphgui;

/**
 * Trieda, ktorá má obsahovať implementáciu požadovaného grafového
 * algoritmu z úlohy B. V tejto triede používajte iba metódy z
 * rozhraní Graph, Edge a Vertex. Nevolajte priamo žiadne metódy
 * z iných tried balíčka main.graphgui. Nemeňte hlavičku
 * konštruktora ani metódy performAlgorithm, môžete však
 * samozrejme zmeniť ich telo a pridávať do triedy vlastné metódy,
 * premenné a pomocné triedy.
 */
public class GraphAlgorithm {

    //PREMENNÉ TRIEDY, UPRAVTE SI PODĽA POTREBY

    /** Samotný graf, na ktorom spúšťame algoritmus. */
    private final Graph graph;

    // KONŠTRUKTOR: NEMEŇTE HLAVIČKU, TELO UPRAVTE PODĽA POTREBY
    /**
     * Konštruktor triedy, ktorý dostane graf.
     * @param graph vstupný graf, na ktorom bude bežať algoritmus
     */
    public GraphAlgorithm(Graph graph) {
        // uloz vstupne udaje
        this.graph = graph;
    }


    // METÓDA performAlgorithm: NEMEŇTE HLAVIČKU, TELO UPRAVTE PODĽA POTREBY
    /**
     * Metóda, ktorá spustí výpočet a upraví graf podľa špecifikácie
     * v zadaní úlohy. Vráti výsledok v textovej forme sformátovaný podľa
     * pokynov v zadaní.
     * @return výsledok v textovej forme
     */
    public String performAlgorithm() {
        // ukazkovy jednoduchy algoritmus:
        // ak selectedVertex nie je null, prejdeme jeho susedov,
        // ofarbíme ich na oranzovo a vratime ich zoznam oddeleny medzerami
        Vertex selected = graph.getSelectedVertex();

        // ak bol nejaky vrchol vybrany
        if (selected != null) {
            String result = "";
            for (Vertex other : selected.adjVertices()) {
                other.setColorName("orange");
                if (!result.isEmpty()) {
                    result = result + " ";
                }
                result = result + other.getId();
            }
            return result;
        }
        return "no vertex selected";
    }

}
