package graphgui;

/**
 * Stav aplikácie, udržuje editovací mód a samotný graf.
 */
public final class State {

    public static enum GraphMode {
        SELECT, ADD, DELETE
    }

    public static GraphImplementation getGraph() {
        return getState().getStateGraph();
    }

    public static void setMode(GraphMode m) {
        getState().setStateMode(m);
    }

    public static GraphMode getMode() {
        return getState().getStateMode();
    }


    private static State state = null;

    /**
     * State má vždy len jednu inštanciu (singleton).
     */
    private static State getState() {
        if (state == null) {
            state = new State();
        }
        return state;
    }

    private GraphMode mode = GraphMode.ADD;
    private final GraphImplementation graph = new GraphImplementation();

    protected State() {}

    private GraphImplementation getStateGraph() {
        return graph;
    }

    private GraphMode getStateMode() {
        return this.mode;
    }

    private void setStateMode(GraphMode m) {
        this.mode = m;
    }
}
