/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf;

import calhoun.analysis.crf.CompositeFeatureManager;
import calhoun.analysis.crf.ModelManager;
import calhoun.util.DenseBooleanMatrix2D;
import java.io.Serializable;
import java.util.List;

public class BeanModel
extends CompositeFeatureManager
implements ModelManager {
    private static final long serialVersionUID = -6641426879906871691L;
    protected List<Node> nodes;
    protected List<Edge> edges;

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    @Override
    public int getNumStates() {
        return this.nodes.size();
    }

    @Override
    public String getStateName(int state) {
        return this.nodes.get((int)state).name;
    }

    @Override
    public int getStateIndex(String name) {
        for (Node n : this.nodes) {
            if (!n.name.equals(name)) continue;
            return n.index;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public DenseBooleanMatrix2D getLegalTransitions() {
        int nStates = this.getNumStates();
        DenseBooleanMatrix2D ret = new DenseBooleanMatrix2D(nStates, nStates);
        for (Edge e : this.edges) {
            ret.setQuick(e.from.index, e.to.index, true);
        }
        return ret;
    }

    public static class Edge
    implements Serializable {
        private static final long serialVersionUID = 5429589777288279645L;
        Node from;
        Node to;

        public Edge() {
        }

        public Edge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public Node getFrom() {
            return this.from;
        }

        public void setFrom(Node from) {
            this.from = from;
        }

        public Node getTo() {
            return this.to;
        }

        public void setTo(Node to) {
            this.to = to;
        }
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1550966522391566799L;
        int index;
        String name;

        public Node() {
        }

        public Node(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

