/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf;

import calhoun.analysis.crf.CompositeFeatureManager;
import calhoun.analysis.crf.FeatureManager;
import calhoun.analysis.crf.ModelManager;
import calhoun.util.Assert;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ConstrainedFeatureManager
extends CompositeFeatureManager {
    private static final long serialVersionUID = 5061912595256694050L;

    @Override
    public int getNumFeatures() {
        return 1;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        Object[] names = new String[this.allFeatureTypes.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((FeatureManager)this.allFeatureTypes.get(i)).getFeatureName(featureIndex);
        }
        return "Composite: " + StringUtils.join((Object[])names, (String)",");
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
        Assert.a(this.allFeatureTypes.size() > 0, "No features types have been assigned.");
        Assert.a(this.startIndexes == null, "FeatureManager has already been trained.");
        this.startIx = startingIndex;
        for (int i = 0; i < this.allFeatureTypes.size(); ++i) {
            FeatureManager fm = (FeatureManager)this.allFeatureTypes.get(i);
            List compData = fm.getInputComponent() == null ? data : new CompositeFeatureManager.ComponentList(data, fm.getInputComponent());
            fm.train(this.startIx, modelInfo, compData);
            Assert.a(fm.getNumFeatures() == 1, "Constrained FeatureManagers must all have 1 feature.  ", fm, " had ", fm.getNumFeatures());
        }
    }
}

