/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.analysis.crf.Conrad;
import calhoun.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CRFTester {
    public static void main(String[] args) throws Exception {
        File[] names;
        String dir = args[0];
        String outputDir = args[1];
        ArrayList<String> modelFiles = new ArrayList<String>();
        ArrayList<String> trainingSets = new ArrayList<String>();
        ArrayList<String> testSets = new ArrayList<String>();
        File f = new File(dir);
        for (File name : names = f.listFiles()) {
            String fName = name.getAbsolutePath();
            if (fName.indexOf("Model") != -1) {
                modelFiles.add(fName);
                continue;
            }
            if (fName.indexOf("Train") != -1) {
                trainingSets.add(fName);
                continue;
            }
            if (fName.indexOf("Test") == -1) continue;
            testSets.add(fName);
        }
        CRFTester.runTests(modelFiles, trainingSets, testSets, outputDir);
    }

    static void runTests(List<String> modelFiles, List<String> trainingSets, List<String> testSets, String outputDir) throws Exception {
        File dir = new File(outputDir);
        File results = new File(dir, "results.csv");
        File weights = new File(dir, "weights.csv");
        dir.mkdirs();
        FileWriter rw = new FileWriter(results);
        rw.write("Model\tTraining\tFeatures\tTrainTime\tTrain\t" + StringUtils.join(testSets.iterator(), (char)'\t'));
        FileWriter ww = new FileWriter(weights);
        for (String model : modelFiles) {
            String modelName = FileUtil.getBaseAndExtension(new File(model))[0];
            for (String train : trainingSets) {
                String trainName = FileUtil.getBaseAndExtension(new File(train))[0];
                Conrad r = new Conrad(model);
                System.out.println("A model was successfully initiailized");
                r.train(train);
                System.out.println("Model has been trained");
                r.write(new File(dir, modelName + trainName + ".ser").getAbsolutePath());
                System.out.println("Trained model has been written to file");
                ww.write(modelName + trainName + '\n' + r.printWeights());
                System.out.println("Weights written to file");
                System.out.println("Testing performance of model on training data");
                r.test(train, new File(dir, "predicted" + modelName + trainName + trainName + ".txt").getAbsolutePath());
                for (String test : testSets) {
                    String testName = FileUtil.getBaseAndExtension(new File(test))[0];
                    r.test(test, new File(dir, "predicted" + modelName + trainName + testName + ".txt").getAbsolutePath());
                }
                ((Writer)rw).append("\n");
                System.out.println("Model has been tested on all data; moving to next model or stopping");
            }
        }
        ((Writer)rw).close();
        ((Writer)ww).close();
        System.out.println("Done with Run Tests");
    }
}

