/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.analysis.crf.io.OutputHandlerGeneCallStats;
import calhoun.analysis.crf.statistics.PredictedActualBinaryContingencyTable;
import calhoun.util.ColtUtil;
import calhoun.util.FileUtil;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;

public class GatherResults {
    static String[] graphList = new String[]{"crypto_mean", "crypto_2way_gen", "crypto_2way_cml", "crypto_2way_mea", "crypto_2way_mean", "crypto_2way_gaps_foot_mean", "crypto_5way_mean", "crypto_5way_gaps_foot_mean", "crypto_5way_gaps_foot_halfest_mean"};
    static String[] specList = new String[]{"crypto_mean", "crypto_2way_gen", "crypto_2way_cml", "crypto_2way_mea", "crypto_2way_mean", "crypto_2way_gaps_foot_mean", "crypto_5way_mean", "crypto_5way_gaps_foot_mean", "crypto_5way_gaps_foot_halfest_mean"};
    static String[] speciesList = new String[]{"AN1_A_oryzae_RIB40", "AN1_A_oryzae_RIB40_AFL2", "AN1_AC2_NF2_AF2_ANIG1_AT1_AFL2_A_oryzae_RIB40", "AN1_AC2_NF2_AF2_ANIG1_AT1_AFL2_A_oryzae_RIB40_CI2", "AN1_AF2", "AN1_AF2_A_oryzae_RIB40", "AN1_AF2_A_oryzae_RIB40_AFL2", "AN1_AF2_A_oryzae_RIB40_CI2", "AN1_AF2_ANIG1_A_oryzae", "AN1_CI2"};
    static String[] modelList = new String[]{"comp_gaps_foot_mean"};
    static String[] sizes = new String[]{"50", "100", "200", "400", "600", "800", "1000"};
    static String template = "y:/scripts/conrad/daved/results/";
    static String specSet = "CND1_600";

    public static void main(String[] args) throws Exception {
        if (args[0].equals("spec")) {
            String ret = "";
            for (String model : specList) {
                ret = ret + GatherResults.sensSpec(template, specSet + "/" + model + "_" + specSet);
            }
            FileUtil.writeFile("sensSpec.txt", ret);
        } else if (args[0].equals("graph")) {
            GatherResults.graphs(template, graphList);
        } else if (args[0].equals("asp")) {
            String ret = "\tNuc. sens.\tNuc. spec.\tExon sens.\tExon spec.\tGene sens.\tGene spec.\n";
            ret = ret + GatherResults.sensSpec(template, speciesList[0] + "/ss_mean_" + speciesList[0]);
            for (String species : speciesList) {
                for (String model : modelList) {
                    ret = ret + GatherResults.sensSpec(template, species + "/" + model + "_" + species);
                }
            }
            FileUtil.writeFile("aspSensSpec.txt", ret);
        }
    }

    public static void graphs(String dir, String[] graphList) throws Exception {
        DefaultStatisticalCategoryDataset nuc = new DefaultStatisticalCategoryDataset();
        DefaultStatisticalCategoryDataset exon = new DefaultStatisticalCategoryDataset();
        DefaultStatisticalCategoryDataset gene = new DefaultStatisticalCategoryDataset();
        StandardDeviation s = new StandardDeviation();
        for (String baseModel : graphList) {
            for (String size : sizes) {
                double[] nucWeights = new double[10];
                double[] exonWeights = new double[10];
                double[] geneWeights = new double[10];
                double[] nucWeightsT = new double[10];
                double[] exonWeightsT = new double[10];
                double[] geneWeightsT = new double[10];
                for (int i = 0; i < 10; ++i) {
                    String file = dir + "CND1_" + size + "/" + baseModel + "_CND1_" + size + "_" + i + ".ser.test_" + i + ".dat";
                    try {
                        OutputHandlerGeneCallStats.Results res = (OutputHandlerGeneCallStats.Results)FileUtil.readObject(file);
                        nucWeights[i] = res.ctCodingNucleotide.sensitivity();
                        exonWeights[i] = res.ctExons.sensitivity();
                        float total = res.perfect + res.imperfect;
                        geneWeights[i] = (float)res.perfect / total;
                        System.out.println(String.format("%s %.1f", file, geneWeights[i] * 100.0));
                        file = dir + "CND1_" + size + "/" + baseModel + "_CND1_" + size + "_" + i + ".ser.train_" + i + ".dat";
                        res = (OutputHandlerGeneCallStats.Results)FileUtil.readObject(file);
                        nucWeightsT[i] = res.ctCodingNucleotide.sensitivity();
                        exonWeightsT[i] = res.ctExons.sensitivity();
                        total = res.perfect + res.imperfect;
                        geneWeightsT[i] = (float)res.perfect / total;
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println(String.format("Skipping %s", file));
                    }
                }
                nuc.add(GatherResults.myMean(nucWeights), s.evaluate(GatherResults.filter(nucWeights)), (Comparable)((Object)baseModel), (Comparable)((Object)size));
                exon.add(GatherResults.myMean(exonWeights), s.evaluate(GatherResults.filter(exonWeights)), (Comparable)((Object)baseModel), (Comparable)((Object)size));
                gene.add(GatherResults.myMean(geneWeights), s.evaluate(GatherResults.filter(geneWeights)), (Comparable)((Object)baseModel), (Comparable)((Object)size));
                nuc.add(GatherResults.myMean(nucWeightsT), s.evaluate(GatherResults.filter(nucWeightsT)), (Comparable)((Object)(baseModel + "_training")), (Comparable)((Object)size));
                exon.add(GatherResults.myMean(exonWeightsT), s.evaluate(GatherResults.filter(exonWeightsT)), (Comparable)((Object)(baseModel + "_training")), (Comparable)((Object)size));
                gene.add(GatherResults.myMean(geneWeightsT), s.evaluate(GatherResults.filter(geneWeightsT)), (Comparable)((Object)(baseModel + "_training")), (Comparable)((Object)size));
            }
        }
        FileUtil.writeObject("nuc.dat", nuc);
        FileUtil.writeObject("exon.dat", exon);
        FileUtil.writeObject("gene.dat", gene);
        FileUtil.writeFile("nuc.txt", GatherResults.printSet(nuc));
        FileUtil.writeFile("exon.txt", GatherResults.printSet(exon));
        FileUtil.writeFile("gene.txt", GatherResults.printSet(gene));
    }

    static double myMean(double[] vals) {
        return StatUtils.mean((double[])GatherResults.filter(vals));
    }

    static double[] filter(double[] vals) {
        int count = 0;
        for (double val : vals) {
            if (val == 0.0) continue;
            ++count;
        }
        double[] nonZero = new double[count];
        count = 0;
        for (double val : vals) {
            if (val == 0.0) continue;
            nonZero[count++] = val;
        }
        return nonZero;
    }

    static String printSet(DefaultStatisticalCategoryDataset set) {
        int col;
        StringBuffer buf = new StringBuffer();
        for (col = 0; col < set.getRowCount(); ++col) {
            buf.append("\t").append(set.getRowKey(col));
        }
        for (col = 0; col < set.getRowCount(); ++col) {
            buf.append("\t").append(set.getRowKey(col) + "StdDev");
        }
        buf.append("\n");
        for (int row = 0; row < set.getColumnCount(); ++row) {
            int col2;
            buf.append(set.getColumnKey(row));
            for (col2 = 0; col2 < set.getRowCount(); ++col2) {
                buf.append("\t").append(set.getMeanValue(col2, row).floatValue() * 100.0f);
            }
            for (col2 = 0; col2 < set.getRowCount(); ++col2) {
                buf.append("\t").append(set.getStdDevValue(col2, row).floatValue() * 100.0f);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String sensSpec(String dir, String model) throws Exception {
        double[][] values = new double[Stat.values().length][10];
        System.out.println(model);
        for (int i = 0; i < 10; ++i) {
            try {
                String file = dir + model + "_" + i + ".ser.test_" + i + ".dat";
                OutputHandlerGeneCallStats.Results res = (OutputHandlerGeneCallStats.Results)FileUtil.readObject(file);
                values[Stat.NUC_SENS.value][i] = res.ctCodingNucleotide.sensitivity();
                values[Stat.NUC_SPEC.value][i] = res.ctCodingNucleotide.specificity();
                values[Stat.EXON_SENS.value][i] = res.ctExons.sensitivity();
                values[Stat.EXON_SPEC.value][i] = res.ctExons.specificity();
                float total = res.perfect + res.imperfect;
                values[Stat.GENE_SENS.value][i] = (float)res.perfect / total;
                for (int k = 0; k < 6; ++k) {
                    PredictedActualBinaryContingencyTable tab = res.ctTransitions.get(1 + k);
                    total += (float)(tab.getFP() - tab.getFN());
                }
                values[Stat.GENE_SPEC.value][i] = (float)res.perfect / total;
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Skipping %s %d", model, i));
            }
        }
        StandardDeviation s = new StandardDeviation();
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        StringBuffer b = new StringBuffer();
        b.append(model);
        for (int j = 0; j < 6; ++j) {
            System.out.println((Object)((Object)Stat.values()[j]) + " " + ColtUtil.format(values[j]));
            double mean = GatherResults.myMean(values[j]);
            double stddev = s.evaluate(GatherResults.filter(values[j]));
            dataset.add(mean, stddev, (Comparable)((Object)model), (Comparable)((Object)Stat.values()[j].name()));
            b.append("\t").append(String.format("%.1f\t%.1f", mean * 100.0, stddev * 100.0));
        }
        b.append("\n");
        return b.toString();
    }

    static enum Stat {
        NUC_SENS(0),
        NUC_SPEC(1),
        EXON_SENS(2),
        EXON_SPEC(3),
        GENE_SENS(4),
        GENE_SPEC(5);

        int value;

        private Stat(int value) {
            this.value = value;
        }
    }
}

