/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class PartitionRandomlyTrainTestFiles {
    public static void main(String[] args) throws Exception {
        String configFile = args[0];
        String inputFile = args[1];
        int nTrain = Integer.parseInt(args[2]);
        String outputTrain = args[3];
        String outputTest = args[4];
        Conrad c = new Conrad(configFile);
        Iterator<TrainingSequence<?>> iter = c.getInputHandler().readTrainingData(inputFile).iterator();
        ArrayList t = new ArrayList();
        while (iter.hasNext()) {
            t.add(iter.next());
        }
        int nTotal = t.size();
        Assert.a(nTrain > 0);
        Assert.a(nTrain < nTotal);
        boolean[] trainflag = PartitionRandomlyTrainTestFiles.randomBooleanVector(nTotal, nTrain);
        ArrayList train = new ArrayList();
        ArrayList test = new ArrayList();
        for (int i = 0; i < nTotal; ++i) {
            if (trainflag[i]) {
                train.add(t.get(i));
                continue;
            }
            test.add(t.get(i));
        }
        c.getInputHandler().writeTrainingData(outputTrain, train);
        c.getInputHandler().writeTrainingData(outputTest, test);
    }

    private static boolean[] randomBooleanVector(int total, int train) {
        int i;
        boolean[] bv = new boolean[total];
        for (i = 0; i < total; ++i) {
            bv[i] = false;
        }
        for (i = 0; i < train; ++i) {
            int x;
            Random r = new Random();
            while (bv[x = r.nextInt(total)]) {
            }
            bv[x] = true;
        }
        return bv;
    }
}

