/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables.viewer;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.executables.viewer.ViterbiTableModel;
import calhoun.analysis.crf.io.TrainingSequence;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ViterbiViewerApp
extends JFrame {
    private static final long serialVersionUID = -5564046976928448201L;
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 600;
    ViterbiViewer recordViewer;

    public ViterbiViewerApp(String model, String data) throws IOException {
        super("Viterbi Path Viewer");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Conrad r = Conrad.read(model);
        List<TrainingSequence<?>> trainingData = r.getInputHandler().readTrainingData(data);
        this.recordViewer = new ViterbiViewer(r, trainingData.get(0));
        JScrollPane scrollPane = new JScrollPane(this.recordViewer);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.setContentPane(scrollPane);
        this.setSize(800, 600);
    }

    public static void main(String[] args) throws Exception {
        String model = "";
        String data = "";
        if (args.length == 2) {
            model = args[0];
            data = args[1];
        }
        ViterbiViewerApp app = new ViterbiViewerApp(model, data);
        app.pack();
        app.setVisible(true);
    }

    static class ViterbiViewer
    extends JTable {
        private static final long serialVersionUID = 7592581578644968579L;
        ViterbiTableModel model;

        public ViterbiViewer(Conrad crfModel, TrainingSequence seq) throws IOException {
            this.model = new ViterbiTableModel(crfModel, seq);
            this.setModel(this.model);
            this.setDefaultRenderer(String.class, this.model.new ViterbiTableModel.ViterbiCellRenderer());
            this.setAutoResizeMode(0);
        }
    }
}

