/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.interval13.Interval13Tools;
import calhoun.analysis.crf.features.supporting.LogProbLookup;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.List;

public abstract class ReferenceBasePredictorInterval13Base
extends AbstractFeatureManager<Character> {
    private static final long serialVersionUID = 8194502006226691957L;
    ModelManager model;
    int startIx;
    boolean multipleFeatures = false;
    double pseudoCounts;
    int lookback;
    LogProbLookup intron;
    LogProbLookup intergenic;
    LogProbLookup[] exonic;

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.multipleFeatures) {
            String[] vals = new String[]{"Intergenic", "Exon pos.", "Intron pos.", "Exon neg.", "Intron neg."};
            int feat = featureIndex - this.startIx;
            String table = vals[feat];
            return table + " base composition";
        }
        return "referenceBasePredictorInterval13";
    }

    @Override
    public int getNumFeatures() {
        return this.multipleFeatures ? 5 : 1;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        Interval13Tools.verify(modelInfo);
        this.pseudoCounts = 1.0;
        this.lookback = 3;
        this.exonic = new LogProbLookup[3];
        for (int j = 0; j < 3; ++j) {
            this.exonic[j] = new LogProbLookup(this.lookback, this.pseudoCounts);
        }
        this.intron = new LogProbLookup(this.lookback, this.pseudoCounts);
        this.intergenic = new LogProbLookup(this.lookback, this.pseudoCounts);
        for (TrainingSequence<? extends Character> trainingSequence : data) {
            block9: for (int pos = 0; pos < trainingSequence.length(); ++pos) {
                int state = trainingSequence.getY(pos);
                switch (state) {
                    case 0: {
                        this.intergenic.increment(trainingSequence, pos, true);
                        this.intergenic.increment(trainingSequence, pos, false);
                        continue block9;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.exonic[((pos - state + 1) % 3 + 3) % 3].increment(trainingSequence, pos, true);
                        continue block9;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        this.intron.increment(trainingSequence, pos, true);
                        continue block9;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        this.exonic[((-pos + state + 1) % 3 + 3) % 3].increment(trainingSequence, pos, false);
                        continue block9;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        this.intron.increment(trainingSequence, pos, false);
                        continue block9;
                    }
                    default: {
                        Assert.a(false);
                    }
                }
            }
        }
        for (int j = 0; j < 3; ++j) {
            this.exonic[j].finalize();
        }
        this.intron.finalize();
        this.intergenic.finalize();
    }

    public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
        double evaluation = 0.0;
        int indexOffset = Integer.MIN_VALUE;
        switch (state) {
            case 0: {
                evaluation = this.intergenic.lookup(seq, pos, true);
                indexOffset = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int phase = ((pos - state + 1) % 3 + 3) % 3;
                evaluation = this.exonic[phase].lookup(seq, pos, true);
                indexOffset = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                evaluation = this.intron.lookup(seq, pos, true);
                indexOffset = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                int phase = ((-pos + state + 1) % 3 + 3) % 3;
                evaluation = this.exonic[phase].lookup(seq, pos, false);
                indexOffset = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                evaluation = this.intron.lookup(seq, pos, false);
                indexOffset = 4;
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        result.addFeature(this.startIx + (this.multipleFeatures ? indexOffset : 0), evaluation);
    }

    public boolean isMultipleFeatures() {
        return this.multipleFeatures;
    }

    public void setMultipleFeatures(boolean weightPerState) {
        this.multipleFeatures = weightPerState;
    }
}

