/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval13;

import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNodeExplicitLength;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.SequenceConverter;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.statistics.MixtureOfGammas;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateLengthLogprobInterval13
implements FeatureManagerNodeExplicitLength<Character> {
    private static final long serialVersionUID = 8685543199212865835L;
    private static final Log log = LogFactory.getLog(StateLengthLogprobInterval13.class);
    private int startIx;
    ModelManager mi;
    private String inputComponentName;
    MixtureOfGammas intergenicMixGamma;
    MixtureOfGammas exonMixGamma;
    MixtureOfGammas intronMixGamma;
    private boolean forceExponential = false;
    private boolean exonExponential = false;
    private boolean intronExponential = false;
    private boolean multipleFeatures = false;
    private boolean noIntergenic = false;

    public void setForceExponential(boolean forceExponential) {
        this.forceExponential = forceExponential;
    }

    public void setExonExponential(boolean exonExponential) {
        this.exonExponential = exonExponential;
    }

    public void setIntronExponential(boolean intronExponential) {
        this.intronExponential = intronExponential;
    }

    @Override
    public void evaluateNodeLength(InputSequence<? extends Character> seq, int pos, int length, int state, FeatureList result) {
        Assert.a(length > 0);
        MixtureOfGammas mg = null;
        int indexOffset = Integer.MIN_VALUE;
        switch (state) {
            case 0: {
                if (this.noIntergenic) {
                    return;
                }
                indexOffset = 0;
                mg = this.intergenicMixGamma;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                indexOffset = 1;
                mg = this.exonMixGamma;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                indexOffset = 2;
                mg = this.intronMixGamma;
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        double val = mg.logEvaluate(length);
        Assert.a(val != Double.NEGATIVE_INFINITY && val != Double.POSITIVE_INFINITY && !Double.isNaN(val));
        if (val > 0.0) {
            log.warn((Object)"About to return a state length logprob evaluation that is greater than zero, see notes in source code.");
        }
        result.addFeature(this.startIx + (this.multipleFeatures ? indexOffset : 0), val);
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.LENGTHFUNCTION);
    }

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.multipleFeatures) {
            String[] vals = new String[]{"Intergenic", "Exon", "Intron"};
            String type = vals[featureIndex - this.startIx];
            return type + " lengths";
        }
        return "StateDurationLogProbForModelInterval13";
    }

    @Override
    public String getInputComponent() {
        return this.inputComponentName;
    }

    @Override
    public void setInputComponent(String name) {
        this.inputComponentName = name;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.startIx = startingIndex;
        this.mi = modelInfo;
        Assert.a(this.mi.getNumStates() == 13);
        ArrayList<ArrayList<Integer>> stateDurations = SequenceConverter.stateVector2StateLengths(data, this.mi.getNumStates());
        ArrayList exonLengths = new ArrayList();
        ArrayList intronLengths = new ArrayList();
        ArrayList intergenicLengths = new ArrayList();
        intergenicLengths.addAll(stateDurations.get(0));
        exonLengths.addAll(stateDurations.get(1));
        exonLengths.addAll(stateDurations.get(2));
        exonLengths.addAll(stateDurations.get(3));
        exonLengths.addAll(stateDurations.get(7));
        exonLengths.addAll(stateDurations.get(8));
        exonLengths.addAll(stateDurations.get(9));
        intronLengths.addAll(stateDurations.get(4));
        intronLengths.addAll(stateDurations.get(5));
        intronLengths.addAll(stateDurations.get(6));
        intronLengths.addAll(stateDurations.get(10));
        intronLengths.addAll(stateDurations.get(11));
        intronLengths.addAll(stateDurations.get(12));
        double[] inter = new double[intergenicLengths.size()];
        for (int j = 0; j < intergenicLengths.size(); ++j) {
            inter[j] = ((Integer)intergenicLengths.get(j)).intValue();
        }
        double[] exon = new double[exonLengths.size()];
        for (int j = 0; j < exonLengths.size(); ++j) {
            exon[j] = ((Integer)exonLengths.get(j)).intValue();
        }
        double[] intron = new double[intronLengths.size()];
        for (int j = 0; j < intronLengths.size(); ++j) {
            intron[j] = ((Integer)intronLengths.get(j)).intValue();
        }
        if (this.forceExponential) {
            this.intergenicMixGamma = new MixtureOfGammas(inter, true);
            this.exonMixGamma = new MixtureOfGammas(exon, true);
            this.intronMixGamma = new MixtureOfGammas(intron, true);
        } else if (this.exonExponential) {
            this.intergenicMixGamma = new MixtureOfGammas(inter, true);
            this.exonMixGamma = new MixtureOfGammas(exon, true);
            this.intronMixGamma = new MixtureOfGammas(intron);
        } else if (this.intronExponential) {
            this.intergenicMixGamma = new MixtureOfGammas(inter, true);
            this.exonMixGamma = new MixtureOfGammas(exon);
            this.intronMixGamma = new MixtureOfGammas(intron, true);
        } else {
            this.intergenicMixGamma = new MixtureOfGammas(inter, true);
            this.exonMixGamma = new MixtureOfGammas(exon);
            this.intronMixGamma = new MixtureOfGammas(intron);
        }
    }

    @Override
    public int getNumFeatures() {
        return this.multipleFeatures ? 3 : 1;
    }

    public boolean isMultipleFeatures() {
        return this.multipleFeatures;
    }

    public void setMultipleFeatures(boolean multipleFeatures) {
        this.multipleFeatures = multipleFeatures;
    }

    public boolean isNoIntergenic() {
        return this.noIntergenic;
    }

    public void setNoIntergenic(boolean noIntergenic) {
        this.noIntergenic = noIntergenic;
    }
}

