/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting.phylogenetic;

import calhoun.analysis.crf.features.supporting.phylogenetic.NucleotideSubstitutionModel;
import calhoun.analysis.crf.features.supporting.phylogenetic.PhylogeneticTreeFelsensteinOrder;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import cern.colt.matrix.DoubleMatrix2D;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvolutionaryModel
implements Serializable {
    private static final long serialVersionUID = -4531626481183209673L;
    private static final Log log = LogFactory.getLog(EvolutionaryModel.class);
    PhylogeneticTreeFelsensteinOrder T;
    double[] pi;
    NucleotideSubstitutionModel R;
    int numSpecies;
    int[] ileft;
    int[] iright;
    double[][] Tleft;
    double[][] Tright;
    double[][] P;
    static KmerHasher hforward = new KmerHasher(KmerHasher.ACGTother, 1);
    static KmerHasher hbackward = new KmerHasher(KmerHasher.ACGTotherRC, 1);

    public EvolutionaryModel(PhylogeneticTreeFelsensteinOrder T, double[] pi, NucleotideSubstitutionModel R) {
        this.T = T;
        this.pi = pi;
        this.R = R;
        this.numSpecies = T.numSpecies();
        this.setup();
    }

    private void setup() {
        this.ileft = this.T.getileft();
        this.iright = this.T.getiright();
        double[] bleft = this.T.getbleft();
        double[] bright = this.T.getbright();
        this.Tleft = new double[this.T.nSteps][];
        this.Tright = new double[this.T.nSteps][];
        for (int j = 0; j < this.T.nSteps; ++j) {
            this.Tleft[j] = EvolutionaryModel.createArrayFromTransitionMatrix(this.R.transitionMatrix(bleft[j]));
            this.Tright[j] = EvolutionaryModel.createArrayFromTransitionMatrix(this.R.transitionMatrix(bright[j]));
        }
        Assert.a(this.ileft.length == this.T.nSteps);
        Assert.a(this.iright.length == this.T.nSteps);
        this.P = new double[this.T.nNodes][4];
    }

    public double logprobRC(MultipleAlignmentInputSequence.MultipleAlignmentColumn col, boolean conditionref) {
        return this.logprob(col, conditionref, hbackward);
    }

    public double logprob(MultipleAlignmentInputSequence.MultipleAlignmentColumn col, boolean conditionref) {
        return this.logprob(col, conditionref, hforward);
    }

    private double logprob(MultipleAlignmentInputSequence.MultipleAlignmentColumn C, boolean conditionref, KmerHasher h) {
        int i;
        if (C.numSpecies() != this.numSpecies) {
            Assert.a(false, "C.numspecies is " + C.numSpecies() + "  and numSpecies is " + this.numSpecies);
        }
        for (int i2 = 0; i2 < this.numSpecies; ++i2) {
            int x = h.hash(C.nucleotide(i2));
            for (int j = 0; j < 4; ++j) {
                this.P[i2][j] = x >= 4 || x == j ? 1.0 : 0.0;
            }
        }
        for (int step = 0; step < this.T.nSteps; ++step) {
            int node = step + this.numSpecies;
            EvolutionaryModel.felsenstein(this.P[this.ileft[step]], this.Tleft[step], this.P[this.iright[step]], this.Tright[step], this.P[node]);
        }
        double prob = 0.0;
        for (i = 0; i < 4; ++i) {
            prob += this.pi[i] * this.P[this.T.numNodes() - 1][i];
        }
        if (conditionref) {
            for (i = 1; i < this.T.numSpecies(); ++i) {
                Arrays.fill(this.P[i], 1.0);
            }
            for (int step = 0; step < this.T.nSteps; ++step) {
                int node = step + this.numSpecies;
                EvolutionaryModel.felsenstein(this.P[this.ileft[step]], this.Tleft[step], this.P[this.iright[step]], this.Tright[step], this.P[node]);
            }
            double denom = 0.0;
            for (int i3 = 0; i3 < 4; ++i3) {
                denom += this.pi[i3] * this.P[this.T.numNodes() - 1][i3];
            }
            if (!(prob / denom < 1.00000001)) {
                Assert.a(false, "prob=" + prob + "  denom=" + denom);
            }
            prob /= denom;
        }
        if (!(prob > 0.0)) {
            Assert.a(false, "prob=" + prob);
        }
        if (!(prob < 1.00000001)) {
            Assert.a(false, "prob=" + prob);
        }
        return Math.log(prob);
    }

    private static double[] createArrayFromTransitionMatrix(DoubleMatrix2D R) {
        double[] ret = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ret[i * 4 + j] = R.getQuick(i, j);
            }
        }
        return ret;
    }

    private static void felsenstein(double[] lp, double[] lT, double[] rp, double[] rT, double[] pp) {
        for (int i = 0; i < 4; ++i) {
            double leftprob = 0.0;
            double rightprob = 0.0;
            for (int j = 0; j < 4; ++j) {
                leftprob += lT[i * 4 + j] * lp[j];
                rightprob += rT[i * 4 + j] * rp[j];
            }
            pp[i] = leftprob * rightprob;
        }
    }

    public void summarize() {
        log.debug((Object)("Evolutionary model, initial probabilities:   pi = " + this.pi[0] + "\t" + this.pi[1] + "\t" + this.pi[2] + "\t" + this.pi[3]));
        this.R.summarize();
    }
}

