/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting.phylogenetic;

import calhoun.util.Assert;
import calhoun.util.ColtUtil;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NucleotideSubstitutionModel
implements Serializable {
    private static final Log log = LogFactory.getLog(NucleotideSubstitutionModel.class);
    DoubleMatrix2D R = new DenseDoubleMatrix2D(4, 4);

    public abstract String getEvolutionaryModelName();

    public abstract double[] getParameters();

    public abstract void setParameters(double[] var1);

    public DoubleMatrix2D getRateMatrix() {
        return this.R;
    }

    public DoubleMatrix2D transitionMatrix(double t) {
        DenseDoubleMatrix2D S = new DenseDoubleMatrix2D(4, 4);
        S.assign(this.R);
        ColtUtil.scalarmultiply((DoubleMatrix2D)S, t);
        DenseDoubleMatrix2D T = new DenseDoubleMatrix2D(4, 4);
        ColtUtil.exponentiate_real_matrix((DoubleMatrix2D)S, (DoubleMatrix2D)T, 100);
        for (int i = 0; i < 4; ++i) {
            double sumi = 0.0;
            for (int j = 0; j < 4; ++j) {
                sumi += T.getQuick(i, j);
            }
            if (!(sumi < 0.999) && !(sumi > 1.001)) continue;
            log.warn((Object)"Assertion failure imminent.  The matrix S is:");
            log.warn((Object)ColtUtil.format((DoubleMatrix2D)S));
            log.warn((Object)"The matrix T (which should be exponential of S) is:");
            log.warn((Object)ColtUtil.format((DoubleMatrix2D)T));
            Assert.a(false);
        }
        return T;
    }

    public abstract void summarize();
}

