/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting.phylogenetic;

import calhoun.util.Assert;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhylogeneticTreeFelsensteinOrder
implements Serializable {
    private static final long serialVersionUID = -2394371116379001213L;
    private static final Log log = LogFactory.getLog(PhylogeneticTreeFelsensteinOrder.class);
    int[] ileft;
    int[] iright;
    double[] bleft;
    double[] bright;
    int nSpecies;
    int nSteps;
    int nNodes;

    public PhylogeneticTreeFelsensteinOrder() {
        this.ileft = new int[]{0, 5, 3, 6};
        this.iright = new int[]{1, 2, 4, 7};
        this.bleft = new double[]{0.0025, 0.0475, 0.02, 0.02};
        this.bright = new double[]{0.0025, 0.05, 0.02, 0.05};
        this.setup();
    }

    public PhylogeneticTreeFelsensteinOrder(int[] ileft, int[] iright, double[] bleft, double[] bright) {
        this.ileft = ileft;
        this.iright = iright;
        this.bleft = bleft;
        this.bright = bright;
        this.setup();
    }

    public void summarize() throws IOException {
        log.debug((Object)"Summary of an order-of-computations object for Felsenstein recursion");
        log.debug((Object)("Number of species: " + this.nSpecies));
        log.debug((Object)("Number of steps:   " + this.nSteps));
        log.debug((Object)("Number of nodes:   " + this.nNodes));
        log.debug((Object)("  Nodes 0 to " + (this.nSpecies - 1) + " are given."));
        for (int step = 0; step < this.nSteps; ++step) {
            log.debug((Object)("  Node " + (this.nSpecies + step) + " combines nodes " + this.ileft[step] + " and " + this.iright[step] + " with branchlengths " + this.bleft[step] + " and " + this.bright[step]));
        }
    }

    private void setup() {
        this.nSteps = this.ileft.length;
        Assert.a(this.iright.length == this.nSteps);
        Assert.a(this.bleft.length == this.nSteps);
        Assert.a(this.bright.length == this.nSteps);
        this.nSpecies = this.nSteps + 1;
        this.nNodes = this.nSpecies + this.nSteps;
    }

    public int numSpecies() {
        return this.nSpecies;
    }

    public int numSteps() {
        return this.nSteps;
    }

    public int numNodes() {
        return this.nNodes;
    }

    public int[] getileft() {
        return this.ileft;
    }

    public int[] getiright() {
        return this.iright;
    }

    public double[] getbleft() {
        return this.bleft;
    }

    public double[] getbright() {
        return this.bright;
    }
}

