/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting.phylogenetic;

import calhoun.analysis.crf.features.supporting.phylogenetic.BinaryTreeNode;
import calhoun.analysis.crf.features.supporting.phylogenetic.PhylogeneticTreeFelsensteinOrder;
import calhoun.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RootedBinaryPhylogeneticTree
implements Serializable {
    private static final long serialVersionUID = 4800435332663788163L;
    private static final Log log = LogFactory.getLog(RootedBinaryPhylogeneticTree.class);
    public ArrayList<BinaryTreeNode> T;

    public RootedBinaryPhylogeneticTree(String ss) {
        ss = ss.trim();
        this.weaklyValidateNewickString(ss);
        ss = ss.substring(0, ss.length() - 1);
        if (ss.lastIndexOf(41) == ss.length() - 1) {
            ss = ss + ":0.0";
        }
        this.T = new ArrayList();
        this.growBranch(this.T, -1, ss);
    }

    private RootedBinaryPhylogeneticTree(ArrayList<BinaryTreeNode> TT) {
        this.T = TT;
    }

    public String newick() {
        Assert.a(this.T.get((int)0).p == -1);
        String s = this.newick_recursion(0);
        s = s + ";";
        return s;
    }

    public void summarize_tree() {
        log.debug((Object)"Now printing an extended summary of a RootedBiinaryPhylogeneticTree:");
        log.debug((Object)("Representation as a Newick String --->" + this.newick()));
        log.debug((Object)("Total branch length (normalized): " + this.total_branch_length()));
        log.debug((Object)("Longest branch length (normalized): " + this.longest_branch_length()));
        for (int j = 0; j < this.T.size(); ++j) {
            log.debug((Object)("" + j + " -- " + this.T.get(j).toString()));
        }
    }

    public double total_branch_length() {
        double dist = 0.0;
        for (int j = 0; j < this.T.size(); ++j) {
            if (this.T.get((int)j).p == -1) {
                Assert.a(this.T.get((int)j).d == 0.0);
            }
            dist += this.T.get((int)j).d;
        }
        return dist;
    }

    public double longest_branch_length() {
        double longest = 0.0;
        for (int j = 0; j < this.T.size(); ++j) {
            double x;
            if (this.T.get((int)j).p == -1) {
                x = this.T.get((int)this.T.get((int)j).l).d + this.T.get((int)this.T.get((int)j).r).d;
                if (!(x > longest)) continue;
                longest = x;
                continue;
            }
            x = this.T.get((int)j).d;
            if (!(x > longest)) continue;
            longest = x;
        }
        return longest;
    }

    public int getNumSpecies() {
        return this.getSpeciesSet().size();
    }

    public PhylogeneticTreeFelsensteinOrder getFelsensteinOrder(String[] msaOrder) {
        log.debug((Object)"Attempting to determine the order for a Felsenstein recursion given a phylogenetic tree");
        int nSpecies = msaOrder.length;
        int nSteps = nSpecies - 1;
        Set<String> treeSpecies = this.getSpeciesSet();
        if (treeSpecies.size() != msaOrder.length) {
            Assert.a(false, "treeSpecies.size = " + treeSpecies.size() + "   and msaOrder.length = " + msaOrder.length);
        }
        for (int j = 0; j < msaOrder.length; ++j) {
            Assert.a(treeSpecies.contains(msaOrder[j]));
        }
        HashMap<Integer, Integer> new2old = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> old2new = new HashMap<Integer, Integer>();
        HashMap<Integer, Boolean> needParent = new HashMap<Integer, Boolean>();
        for (int j = 0; j < nSpecies; ++j) {
            int oldIndex = this.getSpeciesIndex(msaOrder[j]);
            log.debug((Object)("Species " + j + " is " + msaOrder[j]));
            old2new.put(oldIndex, j);
            new2old.put(j, oldIndex);
            needParent.put(j, true);
        }
        for (int step = 0; step < nSteps; ++step) {
            int nextNodeOldIndex = -1;
            for (int j = 0; j < new2old.size(); ++j) {
                if (!((Boolean)needParent.get(j)).booleanValue()) continue;
                int thisOldIndex = (Integer)new2old.get(j);
                int parentOldIndex = this.T.get((int)((Integer)new2old.get((Object)Integer.valueOf((int)j))).intValue()).p;
                int leftOldIndex = this.T.get((int)parentOldIndex).l;
                int rightOldIndex = this.T.get((int)parentOldIndex).r;
                Assert.a(thisOldIndex == leftOldIndex || thisOldIndex == rightOldIndex);
                if (!old2new.containsKey(leftOldIndex) || !old2new.containsKey(rightOldIndex)) continue;
                nextNodeOldIndex = parentOldIndex;
                break;
            }
            Assert.a(nextNodeOldIndex != -1);
            new2old.put(nSpecies + step, nextNodeOldIndex);
            old2new.put(nextNodeOldIndex, nSpecies + step);
            needParent.put(nSpecies + step, true);
            needParent.put((Integer)old2new.get(this.T.get((int)nextNodeOldIndex).l), false);
            needParent.put((Integer)old2new.get(this.T.get((int)nextNodeOldIndex).r), false);
        }
        int[] ileft = new int[nSteps];
        int[] iright = new int[nSteps];
        double[] bleft = new double[nSteps];
        double[] bright = new double[nSteps];
        for (int step = 0; step < nSteps; ++step) {
            int oldNodeIndex = (Integer)new2old.get(nSpecies + step);
            ileft[step] = (Integer)old2new.get(this.T.get((int)oldNodeIndex).l);
            iright[step] = (Integer)old2new.get(this.T.get((int)oldNodeIndex).r);
            bleft[step] = this.T.get((int)((Integer)new2old.get((Object)Integer.valueOf((int)ileft[step]))).intValue()).d;
            bright[step] = this.T.get((int)((Integer)new2old.get((Object)Integer.valueOf((int)iright[step]))).intValue()).d;
        }
        return new PhylogeneticTreeFelsensteinOrder(ileft, iright, bleft, bright);
    }

    public RootedBinaryPhylogeneticTree subtree(String[] sn) {
        HashMap<String, Integer> selected = new HashMap<String, Integer>();
        for (int j = 0; j < sn.length; ++j) {
            selected.put(sn[j], 0);
        }
        return this.subtree(selected);
    }

    private RootedBinaryPhylogeneticTree subtree(HashMap<String, Integer> selected) {
        int j;
        ArrayList<BinaryTreeNode> oldT = this.T;
        for (int j2 = 0; j2 < oldT.size(); ++j2) {
            if (oldT.get((int)j2).l != -1) continue;
            Assert.a(oldT.get((int)j2).r == -1);
            Integer a = selected.get(oldT.get((int)j2).n);
            if (a == null) continue;
            selected.put(oldT.get((int)j2).n, selected.get(oldT.get((int)j2).n) + 1);
            oldT.get((int)j2).lm = true;
            oldT.get((int)j2).rm = true;
            int s = j2;
            int p = oldT.get((int)s).p;
            while (p != -1) {
                Assert.a(oldT.get((int)p).l == s || oldT.get((int)p).r == s);
                if (oldT.get((int)p).l == s) {
                    oldT.get((int)p).lm = true;
                }
                if (oldT.get((int)p).r == s) {
                    oldT.get((int)p).rm = true;
                }
                s = p;
                p = oldT.get((int)s).p;
            }
        }
        log.debug((Object)"About to doublecheck that all selected species were found exactly once...");
        for (Map.Entry<String, Integer> me : selected.entrySet()) {
            if (me.getValue() == 1) continue;
            log.debug((Object)("  NOT FOUND UNIQUELY: " + me.getKey() + "   " + me.getValue()));
        }
        log.debug((Object)"DONE");
        HashMap<Integer, Integer> old_to_new = new HashMap<Integer, Integer>();
        int numNew = 0;
        for (int j3 = 0; j3 < oldT.size(); ++j3) {
            if (!oldT.get((int)j3).lm.booleanValue() || !oldT.get((int)j3).rm.booleanValue()) continue;
            old_to_new.put(j3, numNew);
            ++numNew;
        }
        ArrayList<BinaryTreeNode> newT = new ArrayList<BinaryTreeNode>();
        for (j = 0; j < numNew; ++j) {
            newT.add(new BinaryTreeNode());
        }
        for (j = 0; j < oldT.size(); ++j) {
            if (!oldT.get((int)j).lm.booleanValue() || !oldT.get((int)j).rm.booleanValue()) continue;
            int s = (Integer)old_to_new.get(j);
            newT.set(s, oldT.get(j));
            int p = oldT.get((int)j).p;
            double dist = oldT.get((int)j).d;
            while (!(p == -1 || oldT.get((int)p).lm.booleanValue() && oldT.get((int)p).rm.booleanValue())) {
                dist += oldT.get((int)p).d;
                p = oldT.get((int)p).p;
            }
            if (p == -1) {
                newT.get((int)s).p = -1;
                newT.get((int)s).d = 0.0;
            } else {
                newT.get((int)s).p = (Integer)old_to_new.get(p);
                newT.get((int)s).d = dist;
            }
            int l = oldT.get((int)j).l;
            if (l == -1) {
                newT.get((int)s).l = -1;
            } else {
                while (!oldT.get((int)l).lm.booleanValue() || !oldT.get((int)l).rm.booleanValue()) {
                    Assert.a(oldT.get((int)l).lm != false || oldT.get((int)l).rm != false);
                    if (oldT.get((int)l).lm.booleanValue()) {
                        l = oldT.get((int)l).l;
                        continue;
                    }
                    if (!oldT.get((int)l).rm.booleanValue()) continue;
                    l = oldT.get((int)l).r;
                }
                newT.get((int)s).l = (Integer)old_to_new.get(l);
            }
            int r = oldT.get((int)j).r;
            if (r == -1) {
                newT.get((int)s).r = -1;
                continue;
            }
            while (!oldT.get((int)r).lm.booleanValue() || !oldT.get((int)r).rm.booleanValue()) {
                Assert.a(oldT.get((int)r).lm != false || oldT.get((int)r).rm != false);
                if (oldT.get((int)r).lm.booleanValue()) {
                    r = oldT.get((int)r).l;
                    continue;
                }
                if (!oldT.get((int)r).rm.booleanValue()) continue;
                r = oldT.get((int)r).r;
            }
            newT.get((int)s).r = (Integer)old_to_new.get(r);
        }
        RootedBinaryPhylogeneticTree subRBPT = new RootedBinaryPhylogeneticTree(newT);
        return subRBPT;
    }

    private Integer getSpeciesIndex(String name) {
        Integer ret = -1;
        for (int j = 0; j < this.T.size(); ++j) {
            String temp = this.T.get((int)j).n;
            if (!name.equals(temp)) continue;
            ret = j;
        }
        Assert.a(ret != -1, " Could not find species " + name);
        return ret;
    }

    public Set<String> getSpeciesSet() {
        HashSet<String> ret = new HashSet<String>();
        for (int j = 0; j < this.T.size(); ++j) {
            BinaryTreeNode btn = this.T.get(j);
            if (btn.l != -1) continue;
            Assert.a(btn.r == -1);
            String name = btn.n;
            Assert.a(name != "");
            Assert.a(!ret.contains(name));
            ret.add(name);
        }
        return ret;
    }

    private String newick_recursion(int top) {
        String s = "";
        if (this.T.get((int)top).l == -1) {
            Assert.a(this.T.get((int)top).r == -1);
            s = s + this.T.get((int)top).n;
        } else {
            s = s + "(";
            s = s + this.newick_recursion(this.T.get((int)top).l);
            s = s + ",";
            s = s + this.newick_recursion(this.T.get((int)top).r);
            s = s + ")";
        }
        s = s + ":" + this.T.get((int)top).d;
        return s;
    }

    private void growBranch(ArrayList<BinaryTreeNode> T1, int parent, String S) {
        String S3;
        int currentNode = T1.size();
        int x = S.lastIndexOf(":");
        Assert.a(x != -1, "we require that all nodes in Newick format have a branch length");
        Assert.a(x != S.length() - 1);
        double dist = Double.parseDouble(S.substring(x + 1));
        String S2 = S.substring(0, x);
        if (S2.charAt(0) == '(') {
            Assert.a(S2.charAt(S2.length() - 1) == ')');
            S3 = S2.substring(1, S2.length() - 1);
        } else {
            S3 = S2;
        }
        int depth = 0;
        for (int j = 0; j < S3.length() - 1; ++j) {
            if (S3.charAt(j) == '(') {
                ++depth;
            }
            if (S3.charAt(j) == ')') {
                --depth;
            }
            if (depth != 0 || S3.charAt(j) != ',') continue;
            String leftString = S3.substring(0, j);
            String rightString = S3.substring(j + 1, S3.length());
            BinaryTreeNode TN = new BinaryTreeNode(parent, -1, -1, dist, "");
            T1.add(TN);
            T1.get((int)currentNode).l = T1.size();
            this.growBranch(T1, currentNode, leftString);
            T1.get((int)currentNode).r = T1.size();
            this.growBranch(T1, currentNode, rightString);
            return;
        }
        Assert.a(depth == 0);
        BinaryTreeNode T2 = new BinaryTreeNode(parent, -1, -1, dist, S3);
        T1.add(T2);
    }

    private void weaklyValidateNewickString(String ss) {
        int depth = 0;
        Assert.a(ss.charAt(ss.length() - 1) == ';', "Invalid newick tree: " + ss);
        for (int j = 0; j < ss.length() - 1; ++j) {
            if (ss.charAt(j) == '(') {
                ++depth;
            }
            if (ss.charAt(j) == ')') {
                --depth;
            }
            Assert.a(depth >= 0);
        }
        Assert.a(depth == 0);
    }

    public int nSpecies() {
        int m = this.T.size();
        Assert.a(m % 2 == 1);
        return m / 2;
    }
}

