/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.BeanModel;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.supporting.phylogenetic.ColumnConditionalLogProbability;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FelsensteinFeatures
extends AbstractFeatureManager<MultipleAlignmentInputSequence.MultipleAlignmentColumn>
implements FeatureManagerNode<MultipleAlignmentInputSequence.MultipleAlignmentColumn> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(FelsensteinFeatures.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    ColumnConditionalLogProbability mo;
    boolean tieFlag = false;
    List<int[]> clusterIndices;
    private int eModelNum = 0;

    public FelsensteinFeatures(List<int[]> clusters) throws ClassNotFoundException {
        this.clusterIndices = clusters;
    }

    public void setClusters(List<List<BeanModel.Node>> clusters) {
        this.clusterIndices = new ArrayList<int[]>();
        for (List<BeanModel.Node> nodeList : clusters) {
            int[] cluster = new int[nodeList.size()];
            this.clusterIndices.add(cluster);
            for (int i = 0; i < nodeList.size(); ++i) {
                cluster[i] = nodeList.get(i).getIndex();
            }
        }
    }

    public FelsensteinFeatures() {
    }

    public FelsensteinFeatures(List<int[]> clusters, List<int[]> eModelNum) {
        this.clusterIndices = clusters;
        this.eModelNum = eModelNum.get(0)[0];
    }

    public FelsensteinFeatures(List<int[]> clusters, List<int[]> eModelNum, List<int[]> flags) {
        this.tieFlag = true;
        this.clusterIndices = clusters;
        this.eModelNum = eModelNum.get(0)[0];
    }

    @Override
    public int getNumFeatures() {
        if (this.tieFlag) {
            return 1;
        }
        return this.mo.numClusters();
    }

    @Override
    public String getFeatureName(int featureIndex) {
        return "FelsensteinFeatures";
    }

    @Override
    public void evaluateNode(InputSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> seq, int pos, int state, FeatureList result) {
        int cl = this.tieFlag ? 0 : this.mo.state2cluster(state);
        result.addFeature(this.startIx + cl, this.mo.condLogProb(seq, pos, state));
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        this.mo = new ColumnConditionalLogProbability(this.clusterIndices, this.eModelNum);
        this.mo.train(modelInfo, data);
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

