/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KmerFeatures
extends AbstractFeatureManager<Character>
implements FeatureManagerNode<Character> {
    private static final long serialVersionUID = 5959560033335736926L;
    private static final Log log = LogFactory.getLog(KmerFeatures.class);
    static final int DEFAULT_RARE_THRESHOLD = 25;
    int startIx;
    ModelManager model;
    int nStates;
    List<int[]> kmerDefs;
    Map<String, double[]>[] counts;
    Map<String, Integer>[] kmerIds;
    Cardinality cardinality = Cardinality.PER_STATE;
    int rareThreshold = 25;
    transient InputSequence<? extends Character> lastSeq;
    transient int lastPos;
    String[] kmers;
    double[][] vals;

    public KmerFeatures(Cardinality cardinality) {
        this.cardinality = cardinality;
        this.kmerDefs = Collections.singletonList(new int[]{0});
    }

    public KmerFeatures() {
        this.kmerDefs = Collections.singletonList(new int[]{0});
    }

    public KmerFeatures(List<int[]> kmerDefs) {
        this.kmerDefs = kmerDefs;
    }

    public KmerFeatures(List<int[]> kmerDefs, Cardinality cardinality) {
        this.cardinality = cardinality;
        this.kmerDefs = kmerDefs;
    }

    public void setKmerDefinitions(List<List<Integer>> defs) {
        this.kmerDefs = new ArrayList<int[]>();
        for (List<Integer> def : defs) {
            int[] kmer = new int[def.size()];
            this.kmerDefs.add(kmer);
            for (int i = 0; i < def.size(); ++i) {
                kmer[i] = def.get(i);
            }
        }
    }

    public void setRareThreshold(int threshold) {
        Assert.a(this.model == null, "Can't set threshold after training.");
        this.rareThreshold = threshold;
    }

    @Override
    public int getNumFeatures() {
        switch (this.cardinality) {
            case SINGLE: {
                return this.kmerDefs.size();
            }
            case PER_STATE: {
                return this.kmerDefs.size() * this.model.getNumStates();
            }
        }
        Assert.a(this.cardinality == Cardinality.PER_KMER);
        int num = 0;
        for (Map<String, double[]> m : this.counts) {
            num += m.size();
        }
        return num;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        int raw = featureIndex - this.startIx;
        int label = raw / this.kmerDefs.size();
        int kmer = raw % this.kmerDefs.size();
        String name = this.kmerName(kmer);
        String val = "";
        if (this.cardinality == Cardinality.PER_STATE) {
            val = this.model.getStateName(label) + ".";
        } else if (this.cardinality == Cardinality.PER_KMER) {
            val = "(InsertKMer)";
        }
        return "Kmer." + val + name;
    }

    @Override
    public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
        int j;
        if (seq != this.lastSeq || pos != this.lastPos) {
            this.lastSeq = seq;
            this.lastPos = pos;
            for (j = 0; j < this.kmerDefs.size(); ++j) {
                String kmer = this.getKmer(seq, pos, this.kmerDefs.get(j));
                this.vals[j] = this.counts[j].get(kmer);
                if (this.cardinality != Cardinality.PER_KMER) continue;
                this.kmers[j] = kmer;
            }
        }
        for (j = 0; j < this.kmerDefs.size(); ++j) {
            int index;
            double[] kmerVals = this.vals[j];
            if (kmerVals == null || kmerVals[state] == 0.0) continue;
            if (this.cardinality == Cardinality.SINGLE) {
                index = this.startIx + j;
            } else if (this.cardinality == Cardinality.PER_STATE) {
                index = this.startIx + j + this.kmerDefs.size() * state;
            } else {
                Assert.a(this.cardinality == Cardinality.PER_KMER);
                Integer id = this.kmerIds[j].get(this.kmers[j]);
                if (id == null) continue;
                index = id;
            }
            result.addFeature(index, kmerVals[state]);
        }
    }

    public String getKmer(InputSequence<? extends Character> seq, int pos, int[] def) {
        StringBuffer buf = new StringBuffer(def.length);
        for (int i = 0; i < def.length; ++i) {
            int loc = pos + def[i];
            if (loc < 0 || loc >= seq.length()) {
                return null;
            }
            buf.append(seq.getX(loc));
        }
        return buf.toString();
    }

    public String kmerName(int index) {
        int[] kmer = this.kmerDefs.get(index);
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < kmer.length; ++i) {
            if (i != 0) {
                ret.append(".");
            }
            ret.append(kmer[i]);
        }
        return ret.toString();
    }

    public double getKmerProb(int kmerIndex, String kmer, int label) {
        return this.counts[kmerIndex].get(kmer)[label];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        void var5_9;
        int i;
        this.startIx = startingIndex;
        this.model = modelInfo;
        this.nStates = this.model.getNumStates();
        this.vals = new double[this.kmerDefs.size()][];
        this.counts = new HashMap[this.kmerDefs.size()];
        for (i = 0; i < this.counts.length; ++i) {
            this.counts[i] = new HashMap<String, double[]>();
        }
        if (this.cardinality == Cardinality.PER_KMER) {
            this.kmerIds = new HashMap[this.kmerDefs.size()];
            for (i = 0; i < this.kmerIds.length; ++i) {
                this.kmerIds[i] = new HashMap<String, Integer>();
            }
        }
        for (TrainingSequence<? extends Character> trainingSequence : data) {
            int len = trainingSequence.length();
            for (int pos = 0; pos < len; ++pos) {
                int nKmers = this.kmerDefs.size();
                for (int i2 = 0; i2 < nKmers; ++i2) {
                    int state;
                    String kmer = this.getKmer(trainingSequence, pos, this.kmerDefs.get(i2));
                    if (kmer == null) continue;
                    double[] val = this.counts[i2].get(kmer);
                    if (val == null) {
                        val = new double[this.nStates];
                        Arrays.fill(val, 1.0);
                        this.counts[i2].put(kmer, val);
                    }
                    int n = state = trainingSequence.getY(pos);
                    val[n] = val[n] + 1.0;
                }
            }
        }
        int kmerId = this.startIx;
        boolean bl = false;
        while (var5_9 < this.kmerDefs.size()) {
            int kmerCounts = 0;
            for (Map.Entry<String, double[]> val : this.counts[var5_9].entrySet()) {
                double[] cnts = val.getValue();
                double total = 0.0;
                for (int i3 = 0; i3 < cnts.length; ++i3) {
                    total += cnts[i3];
                }
                if (total >= (double)this.rareThreshold) {
                    ++kmerCounts;
                    if (this.cardinality == Cardinality.PER_KMER) {
                        this.kmerIds[var5_9].put(val.getKey(), kmerId);
                        ++kmerId;
                    }
                }
                for (int i2 = 0; i2 < cnts.length; ++i2) {
                    if (total >= (double)this.rareThreshold) {
                        cnts[i2] = Math.log(cnts[i2] / total);
                        Assert.a(!Double.isNaN(cnts[i2]));
                        Assert.a(!Double.isInfinite(cnts[i2]));
                        continue;
                    }
                    cnts[i2] = 0.0;
                }
            }
            log.info((Object)(kmerCounts + " kmers of " + this.kmerName((int)var5_9)));
            ++var5_9;
        }
    }

    public static enum Cardinality {
        SINGLE,
        PER_STATE,
        PER_KMER;

    }
}

