/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.FilenameMapper;
import calhoun.analysis.crf.io.InputComponentIO;
import calhoun.analysis.crf.io.InputHandlerBase;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.IteratorAdapterInputComponent;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.io.TrainingSequenceIO;
import calhoun.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InputHandlerFile
extends InputHandlerBase {
    private static final long serialVersionUID = -2969140424776995686L;
    InputComponentIO inputReader;
    FilenameMapper mapper;
    TrainingSequenceIO hiddenStateReader;

    @Override
    public Iterator<? extends InputSequence<?>> readInputData(String location) throws IOException {
        ArrayList inputs = new ArrayList();
        this.inputReader.readInputSequences(location, inputs);
        return this.createCompositeInput(inputs);
    }

    @Override
    public List<? extends TrainingSequence<?>> readTrainingData(String location) throws IOException {
        return this.readTrainingData(location, false);
    }

    @Override
    public List<? extends TrainingSequence<?>> readTrainingData(String location, boolean predict) throws IOException {
        String trainingLocation = this.mapper.mapFilename(new File(location)).getPath();
        return this.readTrainingData(location, trainingLocation, this.hiddenStateReader, predict);
    }

    @Override
    public void writeInputData(String location, Iterator<? extends InputSequence<?>> data) throws IOException {
        ArrayList compList = new ArrayList();
        Util.addAll(compList, new IteratorAdapterInputComponent(data));
        this.inputReader.writeInputSequences(location, compList);
    }

    @Override
    public void writeTrainingData(String location, List<? extends TrainingSequence<?>> data) throws IOException {
        this.writeInputData(location, data.iterator());
        String trainingLocation = this.mapper.mapFilename(new File(location)).getPath();
        ArrayList<int[]> trainingSeqs = new ArrayList<int[]>();
        for (TrainingSequence<?> t : data) {
            trainingSeqs.add(t.getY());
        }
        this.hiddenStateReader.writeTrainingSequences(trainingLocation, trainingSeqs.iterator());
    }

    public TrainingSequenceIO getHiddenStateReader() {
        return this.hiddenStateReader;
    }

    public void setHiddenStateReader(TrainingSequenceIO hiddenStateReader) {
        this.hiddenStateReader = hiddenStateReader;
    }

    public InputComponentIO getInputReader() {
        return this.inputReader;
    }

    public void setInputReader(InputComponentIO inputReader) {
        this.inputReader = inputReader;
    }

    public FilenameMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(FilenameMapper mapper) {
        this.mapper = mapper;
    }
}

