/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputHandler;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InputSequenceComposite;
import calhoun.analysis.crf.io.IntInput;
import calhoun.analysis.crf.io.InterleavedInputComponent;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InputHandlerInterleaved
implements InputHandler {
    private static final long serialVersionUID = -2969140424776995686L;
    List<InterleavedInputComponent> components;
    IntInput hiddenStateReader = new IntInput();
    boolean locationIsLiteral = false;
    boolean singleComponent = false;
    String componentName;

    public InputHandlerInterleaved() {
    }

    public InputHandlerInterleaved(InterleavedInputComponent base) {
        this.singleComponent = true;
        this.components = Collections.singletonList(base);
    }

    public InputHandlerInterleaved(InterleavedInputComponent base, boolean locationIsLiteral) {
        this(base);
        this.locationIsLiteral = locationIsLiteral;
    }

    @Override
    public Iterator<? extends InputSequence<?>> readInputData(String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends TrainingSequence<?>> readTrainingData(String location) throws IOException {
        return this.readTrainingData(location, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends TrainingSequence<?>> readTrainingData(String location, boolean predict) throws IOException {
        Reader reader = this.locationIsLiteral ? new StringReader(location) : new FileReader(new File(location));
        BufferedReader r = new BufferedReader(reader);
        ArrayList<TrainingSequence<Map<String, Object>>> ret = new ArrayList<TrainingSequence<Map<String, Object>>>();
        try {
            while (r.ready()) {
                int[] data = this.hiddenStateReader.readSequence(r);
                if (data == null) {
                    break;
                }
                InputSequence<Map<String, Object>> inputSeq = null;
                HashMap seq = new HashMap();
                for (InterleavedInputComponent comp : this.components) {
                    boolean success = comp.read(r, seq);
                    Assert.a(success, "Not all components of a composite input sequence were present.");
                }
                if (this.singleComponent) {
                    Assert.a(seq.size() == 1);
                    Map.Entry entry = seq.entrySet().iterator().next();
                    this.componentName = (String)entry.getKey();
                    inputSeq = (InputSequence)entry.getValue();
                } else {
                    inputSeq = new InputSequenceComposite(seq);
                }
                ret.add(new TrainingSequence<Map<String, Object>>(inputSeq, data));
            }
        }
        finally {
            r.close();
        }
        return ret;
    }

    @Override
    public void writeInputData(String location, Iterator<? extends InputSequence<?>> data) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTrainingData(String location, List<? extends TrainingSequence<?>> data) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(new File(location)));
        try {
            for (TrainingSequence<?> seq : data) {
                this.hiddenStateReader.writeSequence(w, seq.getY());
                if (this.singleComponent) {
                    HashMap componentSeqs = new HashMap();
                    componentSeqs.put(this.componentName, seq.getInputSequence());
                    for (InterleavedInputComponent comp : this.components) {
                        comp.write(w, componentSeqs);
                    }
                    continue;
                }
                InputSequenceComposite compSeq = (InputSequenceComposite)seq.getInputSequence();
                Map<String, InputSequence<?>> componentSeqs = compSeq.getComponents();
                for (InterleavedInputComponent comp : this.components) {
                    comp.write(w, componentSeqs);
                }
            }
        }
        finally {
            w.close();
        }
    }

    public List<InterleavedInputComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<InterleavedInputComponent> components) {
        this.components = components;
    }

    public boolean isLocationIsLiteral() {
        return this.locationIsLiteral;
    }

    public void setLocationIsLiteral(boolean literal) {
        this.locationIsLiteral = literal;
    }

    public IntInput getHiddenStateReader() {
        return this.hiddenStateReader;
    }

    public void setHiddenStateReader(IntInput hiddenStateReader) {
        this.hiddenStateReader = hiddenStateReader;
    }
}

