/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputHandlerInterleaved;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InputSequenceInt;
import calhoun.analysis.crf.io.InterleavedInputComponentBase;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.io.TrainingSequenceIO;
import calhoun.util.Assert;
import calhoun.util.ErrorException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IntInput
extends InterleavedInputComponentBase
implements TrainingSequenceIO {
    private static final long serialVersionUID = 4413724139445660883L;

    @Override
    public boolean read(BufferedReader r, Map<String, InputSequence<?>> output) throws IOException {
        int[] data = this.readSequence(r);
        if (data == null) {
            return false;
        }
        output.put(this.name, new InputSequenceInt(data));
        return true;
    }

    public int[] readSequence(BufferedReader r) throws IOException {
        String str = r.readLine();
        if (str == null) {
            return null;
        }
        int[] data = new int[str.length()];
        try {
            for (int i = 0; i < str.length(); ++i) {
                int temp = str.charAt(i) - 48;
                if (!(temp >= 0 && temp <= 9 || (temp = str.charAt(i) - 65 + 10) >= 10 && temp <= 35)) {
                    temp = str.charAt(i) - 97 + 36;
                    Assert.a(temp >= 36 && temp < 62, "Offending character was '" + str.charAt(i));
                }
                data[i] = temp;
            }
        }
        catch (NumberFormatException ex) {
            throw new ErrorException(ex);
        }
        return data;
    }

    @Override
    public void write(Writer w, Map<String, ? extends InputSequence<?>> data) throws IOException {
        this.writeSequence(w, ((InputSequenceInt)data.get(this.name)).getData());
    }

    public void writeSequence(Writer w, int[] data) throws IOException {
        for (int i : data) {
            if (i < 10) {
                w.write(48 + i);
                continue;
            }
            if (i < 36) {
                w.write(65 + (i - 10));
                continue;
            }
            if (i < 62) {
                w.write(97 + (i - 36));
                continue;
            }
            throw new IOException();
        }
        w.write(10);
    }

    @Override
    public void readTrainingSequences(Object location, List<TrainingSequence<Map<String, Object>>> seqs) throws IOException {
        int[] data;
        BufferedReader r = new BufferedReader(new FileReader(new File((String)location)));
        Iterator<TrainingSequence<Map<String, Object>>> it = seqs.iterator();
        while (r.ready() && (data = this.readSequence(r)) != null) {
            TrainingSequence<Map<String, Object>> seq = it.next();
            seq.setY(data);
        }
    }

    @Override
    public void writeTrainingSequences(Object location, Iterator<int[]> data) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(new File((String)location)));
        while (data.hasNext()) {
            int[] seq = data.next();
            this.writeSequence(w, seq);
        }
        w.close();
    }

    public static List<? extends TrainingSequence<?>> prepareData(String str) throws Exception {
        return new InputHandlerInterleaved(new IntInput(), true).readTrainingData(str);
    }
}

