/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputHandlerInterleaved;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InputSequenceCharacter;
import calhoun.analysis.crf.io.InterleavedInputComponentBase;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class StringInput
extends InterleavedInputComponentBase {
    private static final long serialVersionUID = -2944973705715162476L;

    @Override
    public boolean read(BufferedReader r, Map<String, InputSequence<?>> output) throws IOException {
        String data = r.readLine();
        if (data == null) {
            return false;
        }
        output.put(this.name, new InputSequenceCharacter(data));
        return true;
    }

    @Override
    public void write(Writer w, Map<String, ? extends InputSequence<?>> data) throws IOException {
        InputSequenceCharacter comp = (InputSequenceCharacter)data.get(this.name);
        Assert.a(comp != null, "No component found in input: " + this.name + ".  Entry is " + data.keySet().iterator().next());
        w.write(comp.getString());
        w.write(10);
    }

    public static List<? extends TrainingSequence<Character>> prepareData(String str) {
        try {
            return new InputHandlerInterleaved(new StringInput(), true).readTrainingData(str);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

