/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.CompositeFeatureManager;
import calhoun.analysis.crf.FeatureManager;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.FeatureManagerNodeBoundaries;
import calhoun.analysis.crf.FeatureManagerNodeExplicitLength;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.SemiMarkovSetup;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.analysis.crf.solver.CacheProcessorBasic;
import calhoun.analysis.crf.solver.check.ArrayFeatureList;
import calhoun.util.Assert;
import calhoun.util.CheckException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheProcessorDeluxe
extends CacheProcessorBasic {
    private static final Log log = LogFactory.getLog(CacheProcessorDeluxe.class);
    private boolean ignoreInvalidTrainingData;
    private boolean allPaths;
    private boolean validHiddenStates = false;
    public boolean[] invalidTransitions;
    private int[] numFixedEvalIndices;
    private boolean forceStrategy;
    private CacheStrategySpec.CacheStrategy onlyStrategy;
    int lookbackArraySize = -1;
    int lookbackArrayFeatureSize = -1;
    private ArrayList<FeatureManager> sparseFMList;
    private ArrayList<FeatureManager> lengthFMList;
    private int[] sparseStarts;
    private ArrayList<SparseEvaluation> sparseEvals;
    private int[] currentEvalIndices;
    private boolean writtenYet;
    private ArrayList<ConstantEvaluation> constEvals;
    private ArrayList<float[]> denseTables;
    private ArrayList<DenseEvalIndices> denseEvalsList;
    private ArrayList<float[]> denseBoundaryTables;
    ArrayList<DenseNodeBoundaryIndices>[] denseNodeBoundaryEvalsList;
    private short[] minStateLengths;
    private boolean ignoreSemiMarkovSelfTransitions;
    private LengthOnlyEvaluation[][] lengthTables;

    public CacheProcessorDeluxe() {
        log.debug((Object)"Calling Cache Processor Deluxe constructor");
        this.forceStrategy = false;
    }

    public CacheProcessorDeluxe(CacheStrategySpec.CacheStrategy strategy) {
        log.warn((Object)"Calling CacheProcessorDeluxe constructor, specifying a strategy");
        this.forceStrategy = true;
        this.onlyStrategy = strategy;
        log.info((Object)"Constructed a cache processor and requiring it to always use the following cache strategy:");
        switch (strategy) {
            case CONSTANT: {
                log.warn((Object)"CONSTANT");
                break;
            }
            case DENSE: {
                log.warn((Object)"DENSE");
                break;
            }
            case SPARSE: {
                log.warn((Object)"SPARSE");
                break;
            }
            default: {
                Assert.a(false, "ERROR - case not dealt with yet.");
            }
        }
    }

    @Override
    public void setTrainingData(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        super.setTrainingData(fm, data);
        this.basicInit(this.allPaths);
        if (this.maxStateLengths == null) {
            log.debug((Object)"maxStateLengths was not set, setting all to length 1");
            this.maxStateLengths = new short[fm.getNumStates()];
            Arrays.fill(this.maxStateLengths, (short)1);
        }
        if (this.minStateLengths == null) {
            log.info((Object)"minStateLengths was not set, setting all to length 1");
            this.minStateLengths = new short[fm.getNumStates()];
            Arrays.fill(this.maxStateLengths, (short)1);
        }
        this.modelInfo.setup(fm, data, this.allPaths, this.maxStateLengths, this.ignoreSemiMarkovSelfTransitions);
        this.modelInfo.maxLookback = 1;
        for (short stateLen : this.maxStateLengths) {
            this.modelInfo.maxLookback = (short)Math.max(stateLen, this.modelInfo.maxLookback);
        }
        if (this.lookbackArraySize == -1) {
            this.lookbackArraySize = this.modelInfo.maxLookback + 2;
        }
        if (this.lookbackArrayFeatureSize == -1) {
            this.lookbackArrayFeatureSize = Math.max(5, this.modelInfo.nFeatures);
        }
        this.lengthEvals = CacheProcessor.LengthFeatureEvaluation.create(this.modelInfo.statesWithLookback, this.lookbackArraySize, this.lookbackArrayFeatureSize);
        boolean bl = this.validHiddenStates = data.get(0).getY(0) >= 0;
        if (this.validHiddenStates) {
            ArrayList goodData = new ArrayList();
            for (int i = 0; i < data.size(); ++i) {
                TrainingSequence<?> seq = data.get(i);
                short length = 1;
                int lastState = -1;
                boolean validSequence = true;
                try {
                    for (int pos = 0; pos < seq.length(); ++pos) {
                        boolean segmentEnd;
                        int trainingState = seq.getY(pos);
                        boolean bl2 = segmentEnd = pos == seq.length() - 1 || trainingState != seq.getY(pos + 1);
                        if (segmentEnd) {
                            Assert.a(this.maxStateLengths[trainingState] == 1 || length <= this.maxStateLengths[trainingState] && length >= this.minStateLengths[trainingState], "Seq #", i, " Pos ", pos, " Training segment length ", length, " state: " + trainingState + " outside the allowed length ", this.minStateLengths[trainingState], "-", this.maxStateLengths[trainingState]);
                            Assert.a(lastState == -1 || this.modelInfo.transitionIndex.getQuick(lastState, trainingState) != -1);
                            lastState = trainingState;
                            length = 1;
                            continue;
                        }
                        length = (short)(length + 1);
                    }
                }
                catch (CheckException ex) {
                    if (this.ignoreInvalidTrainingData) {
                        log.warn((Object)("Discarding sequence " + i + " " + ex.getMessage()));
                        validSequence = false;
                    }
                    throw ex;
                }
                if (!validSequence) continue;
                goodData.add(seq);
            }
            Assert.a(goodData.size() != 0, "All training sequences were invalid.");
            int diff = data.size() - goodData.size();
            if (diff != 0) {
                log.warn((Object)("Using " + goodData.size() + " training sequences.  Discarded " + diff + " because of state length or transition problems."));
                this.setTrainingData(fm, goodData);
                return;
            }
        }
        this.initializeCacheProcessor();
        this.updateCacheProcessor(fm);
        this.cacheLengthFeatureManagers();
        this.cacheSparseFeatureManagers();
        this.evaluateConstantFeatures();
        if (this.validHiddenStates) {
            this.checkConstraintsInTrainingData();
            this.computeFeatureSums();
        }
    }

    private void initializeCacheProcessor() {
        this.invalidTransitions = new boolean[this.modelInfo.nPotentials * this.modelInfo.totalPositions];
        this.numFixedEvalIndices = new int[this.modelInfo.nPotentials];
        this.currentEvalIndices = new int[this.modelInfo.nPotentials];
        this.denseEvalsList = new ArrayList();
        this.denseTables = new ArrayList();
        this.denseBoundaryTables = new ArrayList();
        this.denseNodeBoundaryEvalsList = new ArrayList[this.modelInfo.nPotentials];
        for (int pot = 0; pot < this.modelInfo.nPotentials; ++pot) {
            this.denseNodeBoundaryEvalsList[pot] = new ArrayList();
        }
        this.constEvals = new ArrayList();
        this.writtenYet = false;
        this.sparseFMList = new ArrayList();
        this.sparseStarts = new int[this.modelInfo.totalPositions + 1];
        this.sparseEvals = new ArrayList();
        this.lengthFMList = new ArrayList();
        this.lengthTables = new LengthOnlyEvaluation[this.modelInfo.nStates][];
        for (int i = 0; i < this.modelInfo.nStates; ++i) {
            this.lengthTables[i] = new LengthOnlyEvaluation[this.modelInfo.maxStateLengths[i]];
            for (int j = 0; j < this.lengthTables[i].length; ++j) {
                this.lengthTables[i][j] = new LengthOnlyEvaluation();
            }
        }
    }

    private void updateCacheProcessor(FeatureManager fm1) {
        log.debug((Object)"Calling updateCacheProcessor");
        CacheStrategySpec.CacheStrategy strategy = this.forceStrategy ? this.onlyStrategy : fm1.getCacheStrategy().strategy;
        switch (strategy) {
            case COMPOSITE: {
                log.debug((Object)"  burrowing into a COMPOSITE feature manager");
                CompositeFeatureManager cfm = (CompositeFeatureManager)fm1;
                for (FeatureManager fmchild : cfm.getComponentFeatures()) {
                    this.updateCacheProcessor(fmchild);
                }
                break;
            }
            case DENSE: {
                log.debug((Object)"  processing a feature manager as DENSE");
                this.cacheFeatureManagerAsDenseNode(fm1);
                break;
            }
            case DENSE_NODE_BOUNDARY: {
                log.debug((Object)"Processing a node as DENSE_NODE_BOUNDARY");
                this.cacheFeatureManagerAsDenseNodeBoundary(fm1);
                break;
            }
            case CONSTANT: {
                log.debug((Object)"  processing a feature manager as CONSTANT");
                this.cacheFeatureManagerAsConstant(fm1);
                break;
            }
            case LENGTHFUNCTION: {
                log.debug((Object)"  processing a feature manager as LENGTH");
                this.lengthFMList.add(fm1);
                break;
            }
            default: {
                log.debug((Object)"  processing a feature manager as SPARSE");
                this.sparseFMList.add(fm1);
                if (!(fm1 instanceof FeatureManagerNodeExplicitLength)) break;
                this.lengthFMList.add(fm1);
            }
        }
    }

    InputSequence getSequence(InputSequence seq, FeatureManager argFm) {
        return argFm.getInputComponent() == null ? seq : seq.getComponent(argFm.getInputComponent());
    }

    private void cacheSparseFeatureManagers() {
        this.sparseStarts[0] = 0;
        log.debug((Object)("We are caching this many feature managers (some may be composite) as sparse: " + this.sparseFMList.size()));
        log.debug((Object)"Number of feature in each of the FMs is");
        for (FeatureManager fmb : this.sparseFMList) {
            log.debug((Object)("Number of features is " + fmb.getNumFeatures()));
            if (FeatureManagerEdge.class.isInstance(fmb)) {
                log.debug((Object)"  Is edge featuremanager");
            }
            if (!FeatureManagerNode.class.isInstance(fmb)) continue;
            log.debug((Object)"  Is node featuremanager");
        }
        ArrayFeatureList result = new ArrayFeatureList(this.fm);
        for (int i = 0; i < this.data.size(); ++i) {
            TrainingSequence seq = (TrainingSequence)this.data.get(i);
            for (int pos = 0; pos < seq.length(); ++pos) {
                int cumulativePosition = this.modelInfo.seqOffsets[i] + pos;
                for (int potential = 0; potential < this.modelInfo.nPotentials; ++potential) {
                    int state;
                    result.clear();
                    if (potential < this.modelInfo.nStates) {
                        state = potential;
                        for (FeatureManager fmb : this.sparseFMList) {
                            if (!FeatureManagerNode.class.isInstance(fmb)) continue;
                            FeatureManagerNode fmn = (FeatureManagerNode)fmb;
                            fmn.evaluateNode(this.getSequence(seq, fmb), pos, state, result);
                        }
                    } else if (pos > 0) {
                        short prevState = this.modelInfo.transitionFrom[potential - this.modelInfo.nStates];
                        state = this.modelInfo.transitionTo[potential - this.modelInfo.nStates];
                        for (FeatureManager fm1 : this.sparseFMList) {
                            if (!FeatureManagerEdge.class.isInstance(fm1)) continue;
                            FeatureManagerEdge fme = (FeatureManagerEdge)fm1;
                            fme.evaluateEdge(this.getSequence(seq, fme), pos, prevState, state, result);
                        }
                    }
                    if (result.isValid()) {
                        for (int j = 0; j < result.size(); ++j) {
                            float value = (float)result.getValue(j);
                            if ((double)value == 0.0) continue;
                            SparseEvaluation se = new SparseEvaluation();
                            se.featureIndex = (short)result.getIndex(j);
                            se.potential = potential;
                            se.value = value;
                            this.sparseEvals.add(se);
                        }
                        continue;
                    }
                    int ind = cumulativePosition * this.modelInfo.nPotentials + potential;
                    this.invalidTransitions[ind] = true;
                }
                this.sparseStarts[cumulativePosition + 1] = this.sparseEvals.size();
            }
        }
    }

    private void cacheFeatureManagerAsConstant(FeatureManager fm1) {
        CacheStrategySpec s = fm1.getCacheStrategy();
        if (s.strategy != CacheStrategySpec.CacheStrategy.CONSTANT) {
            log.warn((Object)"Caching a Feature Manager as CONSTANT even though it requested a different strategy");
        }
        InputSequence seq = (InputSequence)this.data.get(0);
        int pos = 0;
        ArrayFeatureList result = new ArrayFeatureList(this.fm);
        for (int pot = 0; pot < this.modelInfo.nPotentials; ++pot) {
            int state;
            result.clear();
            if (pot < this.modelInfo.nStates) {
                if (!FeatureManagerNode.class.isInstance(fm1)) continue;
                state = pot;
                FeatureManagerNode fmn = (FeatureManagerNode)fm1;
                fmn.evaluateNode(this.getSequence(seq, fmn), pos, state, result);
            } else {
                if (!FeatureManagerEdge.class.isInstance(fm1)) continue;
                FeatureManagerEdge fme = (FeatureManagerEdge)fm1;
                short prevState = this.modelInfo.transitionFrom[pot - this.modelInfo.nStates];
                state = this.modelInfo.transitionTo[pot - this.modelInfo.nStates];
                fme.evaluateEdge(this.getSequence(seq, fme), pos, prevState, state, result);
            }
            Assert.a(result.isValid(), "Constant features should not have to encounter invalid potentials");
            for (int j = 0; j < result.size(); ++j) {
                ConstantEvaluation ce = new ConstantEvaluation();
                ce.featureIndex = (short)result.getIndex(j);
                ce.potential = pot;
                ce.value = (float)result.getValue(j);
                ce.evalIndex = this.numFixedEvalIndices[pot];
                int n = pot;
                this.numFixedEvalIndices[n] = this.numFixedEvalIndices[n] + 1;
                this.constEvals.add(ce);
            }
        }
    }

    private void cacheFeatureManagerAsDenseNode(FeatureManager fm1) {
        int j;
        int state;
        CacheStrategySpec.DenseCachingDetails details;
        CacheStrategySpec s = fm1.getCacheStrategy();
        if (s.strategy != CacheStrategySpec.CacheStrategy.DENSE) {
            log.warn((Object)"The evaluations are being cached using the DENSE strategy even though that was not the strategy requested by the feature.");
        }
        if ((details = (CacheStrategySpec.DenseCachingDetails)s.details) == null) {
            if (fm1.getNumFeatures() > 0) {
                log.debug((Object)("No details specified for " + fm1 + ".  Using evaluations to find the correct nodes"));
            }
            HashSet<FeaturePotential> usedPotentials = new HashSet<FeaturePotential>();
            ArrayFeatureList result = new ArrayFeatureList(this.fm);
            FeaturePotential current = new FeaturePotential();
            for (TrainingSequence seq : this.data) {
                for (int pos = 0; pos < seq.length(); ++pos) {
                    for (int pot = 0; pot < this.modelInfo.nPotentials; ++pot) {
                        result.clear();
                        if (pot < this.modelInfo.nStates) {
                            if (!FeatureManagerNode.class.isInstance(fm1)) continue;
                            FeatureManagerNode fmn = (FeatureManagerNode)fm1;
                            fmn.evaluateNode(this.getSequence(seq, fmn), pos, pot, result);
                        } else {
                            if (!FeatureManagerEdge.class.isInstance(fm1)) continue;
                            FeatureManagerEdge fme = (FeatureManagerEdge)fm1;
                            short prevState = this.modelInfo.transitionFrom[pot - this.modelInfo.nStates];
                            state = this.modelInfo.transitionTo[pot - this.modelInfo.nStates];
                            fme.evaluateEdge(this.getSequence(seq, fme), pos, prevState, state, result);
                        }
                        for (int j2 = 0; j2 < result.size(); ++j2) {
                            current.featureIndex = result.getIndex(j2);
                            current.potential = pot;
                            if (usedPotentials.contains(current)) continue;
                            log.debug((Object)("Adding dense node - pot: " + current.potential + " Feat: " + current.featureIndex));
                            usedPotentials.add(current);
                            current = new FeaturePotential();
                        }
                    }
                }
            }
            details = new CacheStrategySpec.DenseCachingDetails();
            ArrayList<Integer> densePotList = new ArrayList<Integer>();
            ArrayList<Integer> denseTabList = new ArrayList<Integer>();
            ArrayList<Short> denseFiList = new ArrayList<Short>();
            details.nEvals = usedPotentials.size();
            details.nTables = 0;
            for (FeaturePotential fp : usedPotentials) {
                densePotList.add(fp.potential);
                denseTabList.add(details.nTables);
                denseFiList.add((short)fp.featureIndex);
                ++details.nTables;
            }
            details.featureIndex = new short[details.nEvals];
            details.tableNum = new int[details.nEvals];
            details.potential = new int[details.nEvals];
            for (int j3 = 0; j3 < details.nEvals; ++j3) {
                details.featureIndex[j3] = (Short)denseFiList.get(j3);
                details.potential[j3] = (Integer)densePotList.get(j3);
                details.tableNum[j3] = (Integer)denseTabList.get(j3);
            }
            details.check();
        }
        int firstTableIndex = this.denseTables.size();
        details.check();
        for (j = 0; j < details.nTables; ++j) {
            float[] temp = new float[this.modelInfo.totalPositions];
            for (int k = 0; k < this.modelInfo.totalPositions; ++k) {
                temp[k] = 0.0f;
            }
            this.denseTables.add(temp);
        }
        for (j = 0; j < details.nEvals; ++j) {
            DenseEvalIndices de = new DenseEvalIndices();
            int potential = details.potential[j];
            de.evalTable = this.evals[potential];
            de.potential = potential;
            de.evalIndex = this.numFixedEvalIndices[potential];
            int n = potential;
            this.numFixedEvalIndices[n] = this.numFixedEvalIndices[n] + 1;
            de.lookupTable = this.denseTables.get(firstTableIndex + details.tableNum[j]);
            de.featureIndex = details.featureIndex[j];
            this.denseEvalsList.add(de);
        }
        ArrayFeatureList result = new ArrayFeatureList(this.fm);
        for (int i = 0; i < this.data.size(); ++i) {
            TrainingSequence seq = (TrainingSequence)this.data.get(i);
            int actualPreviousState = -1;
            for (int pos = 0; pos < seq.length(); ++pos) {
                int actualState = seq.getY(pos);
                int cumulativePosition = this.modelInfo.seqOffsets[i] + pos;
                for (int potential = 0; potential < this.modelInfo.nPotentials; ++potential) {
                    int j4;
                    result.clear();
                    if (potential < this.modelInfo.nStates) {
                        if (!FeatureManagerNode.class.isInstance(fm1)) continue;
                        state = potential;
                        FeatureManagerNode fmn = (FeatureManagerNode)fm1;
                        fmn.evaluateNode(this.getSequence(seq, fmn), pos, state, result);
                        if (state == actualState) {
                            for (j4 = 0; j4 < result.size(); ++j4) {
                            }
                        }
                    } else if (pos > 0) {
                        if (!FeatureManagerEdge.class.isInstance(fm1)) continue;
                        FeatureManagerEdge fme = (FeatureManagerEdge)fm1;
                        short prevState = this.modelInfo.transitionFrom[potential - this.modelInfo.nStates];
                        state = this.modelInfo.transitionTo[potential - this.modelInfo.nStates];
                        fme.evaluateEdge(this.getSequence(seq, fme), pos, prevState, state, result);
                        if (state == actualState && prevState == actualPreviousState) {
                            for (j4 = 0; j4 < result.size(); ++j4) {
                            }
                        }
                    }
                    if (result.isValid()) {
                        block14: for (int j5 = 0; j5 < result.size(); ++j5) {
                            for (int ev = 0; ev < details.nEvals; ++ev) {
                                DenseEvalIndices de = this.denseEvalsList.get(this.denseEvalsList.size() - 1 - ev);
                                if (potential != de.potential || result.getIndex(j5) != de.featureIndex) continue;
                                de.lookupTable[this.modelInfo.seqOffsets[i] + pos] = (float)result.getValue(j5);
                                continue block14;
                            }
                        }
                        continue;
                    }
                    int ind = cumulativePosition * this.modelInfo.nPotentials + potential;
                    this.invalidTransitions[ind] = true;
                }
                actualPreviousState = actualState;
            }
        }
    }

    private void cacheFeatureManagerAsDenseNodeBoundary(FeatureManager fm1) {
        CacheStrategySpec s = fm1.getCacheStrategy();
        Assert.a(s.strategy == CacheStrategySpec.CacheStrategy.DENSE_NODE_BOUNDARY, "ERROR: Cannot cache using thie DENSE_NODE_BOUNDARY strategy unless specifically requested by the feature.");
        CacheStrategySpec.DenseBoundaryCachingDetails details = (CacheStrategySpec.DenseBoundaryCachingDetails)s.details;
        Assert.a(details != null, "ERROR -- the Cache Strategy DenseNodeBoundary is too intricate to omit specifying details");
        int firstTableIndex = this.denseBoundaryTables.size();
        details.check();
        for (int j = 0; j < details.nTables; ++j) {
            float[] temp = new float[this.modelInfo.totalPositions + this.modelInfo.nSeqs];
            for (int k = 0; k < this.modelInfo.totalPositions + this.modelInfo.nSeqs; ++k) {
                temp[k] = 0.0f;
            }
            this.denseBoundaryTables.add(temp);
        }
        ArrayList<DenseNodeBoundaryIndices> tempNodeBoundaries = new ArrayList<DenseNodeBoundaryIndices>();
        for (CacheStrategySpec.DenseBoundaryEntry be : details.entries) {
            DenseNodeBoundaryIndices db = new DenseNodeBoundaryIndices();
            int potential = be.potential;
            Assert.a(potential < this.modelInfo.nStates, "ERROR - Can't cache potential " + potential + " , which is a transition using the DENSE_NODE_BOUNDARY caching strategy.");
            db.lookupTable = this.denseBoundaryTables.get(firstTableIndex + be.tableNum);
            db.featureIndex = be.featureIndex;
            db.potential = potential;
            db.rightPad = be.rightPad;
            db.leftPad = be.leftPad;
            this.denseNodeBoundaryEvalsList[potential].add(db);
            log.debug((Object)("Node boundary feature: " + db.featureIndex + " pot: " + db.potential + " table: " + db.lookupTable));
            tempNodeBoundaries.add(db);
        }
        Assert.a(tempNodeBoundaries.size() == details.entries.size());
        for (int seqNum = 0; seqNum < this.data.size(); ++seqNum) {
            TrainingSequence seq = (TrainingSequence)this.data.get(seqNum);
            for (int pos = 0; pos < seq.length(); ++pos) {
                int cumulativePosition = this.modelInfo.seqOffsets[seqNum] + pos;
                for (int state = 0; state < this.modelInfo.nStates; ++state) {
                    ArrayFeatureList result = new ArrayFeatureList(this.fm);
                    Assert.a(FeatureManagerNodeBoundaries.class.isInstance(fm1), "ERROR - to cache using DENSE NODE BOUNDARY, must be an instance of FeatureManagerNodeBoundaries, but this isn't.");
                    FeatureManagerNode fmn = (FeatureManagerNode)fm1;
                    fmn.evaluateNode(this.getSequence(seq, fmn), pos, state, result);
                    if (result.isValid()) {
                        for (int j = 0; j < result.size(); ++j) {
                            boolean found = false;
                            for (DenseNodeBoundaryIndices db : tempNodeBoundaries) {
                                if (state != db.potential || result.getIndex(j) != db.featureIndex) continue;
                                int tx = this.modelInfo.seqOffsets[seqNum] + seqNum + pos;
                                db.lookupTable[tx + 1] = db.lookupTable[tx] + (float)result.getValue(j);
                                found = true;
                                break;
                            }
                            if (found) continue;
                            Assert.a(false, String.format("Feature Ix: %d State: %d not found. ", result.getIndex(j), state));
                        }
                    }
                    if (result.isValid()) continue;
                    int ind = cumulativePosition * this.modelInfo.nPotentials + state;
                    this.invalidTransitions[ind] = true;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cacheLengthFeatureManagers() {
        ArrayFeatureList featureList = new ArrayFeatureList(this.fm);
        for (CacheProcessor.StatePotentials stateInfo : this.modelInfo.statesWithLookback) {
            LengthOnlyEvaluation[] lengthForState = this.lengthTables[stateInfo.state];
            int maxLen = this.modelInfo.maxStateLengths[stateInfo.state];
            for (int i = 0; i < maxLen; ++i) {
                void var11_12;
                LengthOnlyEvaluation eval = lengthForState[i];
                featureList.clear();
                for (FeatureManagerNodeExplicitLength featureManagerNodeExplicitLength : this.lengthFMList) {
                    featureManagerNodeExplicitLength.evaluateNodeLength((InputSequence)this.data.get(0), maxLen, i + 1, stateInfo.state, featureList);
                }
                int size = featureList.currentSize;
                eval.featureIndex = new short[size];
                eval.value = new float[size];
                boolean bl = false;
                while (var11_12 < size) {
                    eval.featureIndex[var11_12] = (short)featureList.indices[var11_12];
                    eval.value[var11_12] = (float)featureList.values[var11_12];
                    ++var11_12;
                }
            }
        }
    }

    public void checkConstraintsInTrainingData() {
        ArrayList<TrainingSequence> goodData = new ArrayList<TrainingSequence>();
        for (int i = 0; i < this.data.size(); ++i) {
            TrainingSequence seq = (TrainingSequence)this.data.get(i);
            int seqOffset = this.modelInfo.seqOffsets[i];
            int lastState = -1;
            boolean validSequence = true;
            try {
                for (int pos = 0; pos < seq.length(); ++pos) {
                    int index = (seqOffset + pos) * this.modelInfo.nPotentials;
                    int trainingState = seq.getY(pos);
                    Assert.a(!this.invalidTransitions[index + trainingState], "Seq: ", i, " Pos: ", pos, " State: ", trainingState, " violates a constraint.");
                    if (lastState != -1) {
                        Assert.a(!this.invalidTransitions[index + this.modelInfo.nStates + this.modelInfo.transitionIndex.getQuick(lastState, trainingState)], "Seq: ", i, " Pos: ", pos, " Transition: ", lastState, "-", trainingState, " violates a constraint.");
                    }
                    lastState = trainingState;
                }
            }
            catch (CheckException ex) {
                if (this.ignoreInvalidTrainingData) {
                    log.warn((Object)("Discarding sequence " + i + " " + ex.getMessage()));
                    validSequence = false;
                }
                throw ex;
            }
            if (!validSequence) continue;
            goodData.add(seq);
        }
        Assert.a(goodData.size() != 0, "All training sequences were invalid.");
        int diff = this.data.size() - goodData.size();
        if (diff != 0) {
            log.warn((Object)("Using " + goodData.size() + " training sequences.  Discarded " + diff + " because of constraint problems."));
            log.warn((Object)"Rebuilding the feature cache using the remaining good sequences.");
            this.setTrainingData(this.fm, goodData);
            return;
        }
    }

    @Override
    public void evaluatePosition(int seq, int pos) {
        int cumulativePosition = this.modelInfo.seqOffsets[seq] + pos;
        this.evaluateDenseFeatures(cumulativePosition);
        this.evaluateSparseFeatures(cumulativePosition);
    }

    private void evaluateConstantFeatures() {
        Assert.a(!this.writtenYet, "Constant features can only be written once");
        for (ConstantEvaluation ce : this.constEvals) {
            short fi = ce.featureIndex;
            int pi = ce.potential;
            int ci = ce.evalIndex;
            float val = ce.value;
            this.evals[pi].index[ci] = fi;
            this.evals[pi].value[ci] = val;
        }
        this.writtenYet = true;
    }

    private void evaluateDenseFeatures(int cumulativePosition) {
        for (DenseEvalIndices de : this.denseEvalsList) {
            CacheProcessor.FeatureEvaluation fe = de.evalTable;
            int ei = de.evalIndex;
            float[] lut = de.lookupTable;
            fe.index[ei] = de.featureIndex;
            fe.value[ei] = lut[cumulativePosition];
        }
    }

    private void evaluateSparseFeatures(int cumulativePosition) {
        for (int pot = 0; pot < this.modelInfo.nPotentials; ++pot) {
            this.currentEvalIndices[pot] = this.numFixedEvalIndices[pot];
        }
        int start = this.sparseStarts[cumulativePosition];
        int stop = this.sparseStarts[cumulativePosition + 1];
        for (int j = start; j < stop; ++j) {
            SparseEvaluation se = this.sparseEvals.get(j);
            short fi = se.featureIndex;
            int pi = se.potential;
            int ci = this.currentEvalIndices[pi];
            int n = pi;
            this.currentEvalIndices[n] = this.currentEvalIndices[n] + 1;
            float val = se.value;
            this.evals[pi].index[ci] = fi;
            this.evals[pi].value[ci] = val;
        }
        for (int pot = 0; pot < this.modelInfo.nPotentials; ++pot) {
            this.evals[pot].index[this.currentEvalIndices[pot]] = -1;
        }
    }

    @Override
    public void evaluateSegmentsEndingAt(int seq, int pos) {
        int seqOffset = this.modelInfo.seqOffsets[seq];
        int overallPosition = seqOffset + pos;
        int tx1 = this.modelInfo.seqOffsets[seq] + pos + seq + 1;
        CacheProcessor.StatePotentials[] statesWithLookback = this.modelInfo.statesWithLookback;
        int nSemiMarkovStates = statesWithLookback.length;
        int seqLen = ((TrainingSequence)this.data.get(seq)).length();
        int invalidIndex = overallPosition * this.modelInfo.nPotentials;
        for (int stateIx = 0; stateIx < nSemiMarkovStates; ++stateIx) {
            CacheProcessor.StatePotentials statePotentials = statesWithLookback[stateIx];
            CacheProcessor.LengthFeatureEvaluation[] lookbackEvals = this.lengthEvals[stateIx];
            if (!this.checkExit(invalidIndex, pos, seqLen, statePotentials.state)) {
                lookbackEvals[0].lookback = (short)-1;
                continue;
            }
            int nLookbacks = 0;
            short minLength = this.minStateLengths[statesWithLookback[stateIx].state];
            int maxLength = this.maxStateLengths[statesWithLookback[stateIx].state];
            for (int lookback = 0; lookback < maxLength; ++lookback) {
                int firstPosIndex = (overallPosition - lookback) * this.modelInfo.nPotentials;
                if (lookback > pos || this.invalidTransitions[firstPosIndex + statePotentials.state]) break;
                if (lookback + 1 < minLength) continue;
                int prevPos = pos - lookback - 1;
                boolean validEntry = false;
                if (prevPos == -1) {
                    validEntry = true;
                } else {
                    for (byte pot : statePotentials.potentials) {
                        int entryIndex = (seqOffset + prevPos + 1) * this.modelInfo.nPotentials;
                        if (this.modelInfo.selfTransitions[statePotentials.state] + this.modelInfo.nStates == pot || this.invalidTransitions[entryIndex + pot]) continue;
                        validEntry = true;
                        break;
                    }
                }
                if (!validEntry) continue;
                int nEvals = 0;
                CacheProcessor.LengthFeatureEvaluation lengthEval = lookbackEvals[nLookbacks];
                lengthEval.lookback = (short)lookback;
                lengthEval.edgeEvals = null;
                CacheProcessor.FeatureEvaluation nodeEval = lengthEval.nodeEval;
                for (DenseNodeBoundaryIndices db : this.denseNodeBoundaryEvalsList[statePotentials.state]) {
                    int index = db.featureIndex;
                    float[] lut = db.lookupTable;
                    int rightPad = db.rightPad;
                    int leftPad = db.leftPad;
                    float val = lut[tx1 - rightPad] - lut[tx1 - lookback - 1 + leftPad];
                    nodeEval.index[nEvals] = (short)index;
                    nodeEval.value[nEvals] = val;
                    ++nEvals;
                }
                LengthOnlyEvaluation lengthOnlyEval = this.lengthTables[statePotentials.state][lookback];
                int size = lengthOnlyEval.featureIndex.length;
                System.arraycopy(lengthOnlyEval.featureIndex, 0, nodeEval.index, nEvals, size);
                System.arraycopy(lengthOnlyEval.value, 0, nodeEval.value, nEvals, size);
                nodeEval.index[nEvals += size] = -1;
                ++nLookbacks;
            }
            lookbackEvals[nLookbacks].lookback = (short)-1;
        }
    }

    boolean checkExit(int positionIndex, int pos, int seqLen, int state) {
        if (this.invalidTransitions[positionIndex + state]) {
            return false;
        }
        if (pos == seqLen - 1) {
            return true;
        }
        boolean wayOut = false;
        int nextPosIndex = positionIndex + this.modelInfo.nPotentials;
        for (byte pot : this.modelInfo.exitTransitions[state]) {
            if (this.modelInfo.selfTransitions[state] + this.modelInfo.nStates == pot || this.invalidTransitions[nextPosIndex + pot]) continue;
            wayOut = true;
            break;
        }
        return wayOut;
    }

    @Override
    public boolean[] getInvalidTransitions() {
        return this.invalidTransitions;
    }

    public void setSemiMarkovSetup(SemiMarkovSetup setup) {
        this.maxStateLengths = setup.getMaxLengths();
        this.minStateLengths = setup.getMinLengths();
        this.ignoreSemiMarkovSelfTransitions = setup.isIgnoreSemiMarkovSelfTransitions();
    }

    public boolean isAllPaths() {
        return this.allPaths;
    }

    public void setAllPaths(boolean allPaths) {
        this.allPaths = allPaths;
    }

    public int getLookbackArrayFeatureSize() {
        return this.lookbackArrayFeatureSize;
    }

    public void setLookbackArrayFeatureSize(int lookbackArrayFeatureSize) {
        this.lookbackArrayFeatureSize = lookbackArrayFeatureSize;
    }

    public int getLookbackArraySize() {
        return this.lookbackArraySize;
    }

    public void setLookbackArraySize(int lookbackArraySize) {
        this.lookbackArraySize = lookbackArraySize;
    }

    public boolean isIgnoreInvalidTrainingData() {
        return this.ignoreInvalidTrainingData;
    }

    public void setIgnoreInvalidTrainingData(boolean ignoreInvalidTrainingData) {
        this.ignoreInvalidTrainingData = ignoreInvalidTrainingData;
    }

    class FeaturePotential {
        int featureIndex;
        int potential;

        FeaturePotential() {
        }

        public int hashCode() {
            return this.potential * CacheProcessorDeluxe.this.modelInfo.nPotentials + this.featureIndex;
        }

        public boolean equals(Object rhs) {
            FeaturePotential f2 = (FeaturePotential)rhs;
            return this.featureIndex == f2.featureIndex && this.potential == f2.potential;
        }
    }

    private class LengthOnlyEvaluation {
        public short[] featureIndex;
        public float[] value;

        private LengthOnlyEvaluation() {
        }
    }

    private class DenseNodeBoundaryIndices {
        public int featureIndex;
        public float[] lookupTable;
        public int rightPad;
        public int leftPad;
        public int potential;

        private DenseNodeBoundaryIndices() {
        }
    }

    private class DenseEvalIndices {
        public float[] lookupTable;
        public int evalIndex;
        public CacheProcessor.FeatureEvaluation evalTable;
        public int potential;
        public short featureIndex;

        private DenseEvalIndices() {
        }
    }

    private class ConstantEvaluation {
        short featureIndex;
        int potential;
        float value;
        int evalIndex;

        private ConstantEvaluation() {
        }
    }

    private class SparseEvaluation {
        short featureIndex;
        int potential;
        float value;

        private SparseEvaluation() {
        }
    }
}

