/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import calhoun.analysis.crf.CRFObjectiveFunctionGradient;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.analysis.crf.solver.RecyclingBuffer;
import calhoun.util.Assert;
import calhoun.util.ColtUtil;
import calhoun.util.FileUtil;
import java.io.BufferedWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MaximumLikelihoodSemiMarkovGradient
implements CRFObjectiveFunctionGradient {
    private static final Log log = LogFactory.getLog(MaximumLikelihoodSemiMarkovGradient.class);
    private static final boolean debug = log.isDebugEnabled();
    private static final double ASSERTION_TOLERANCE = 1.0E-4;
    private static final int NORM_FACTOR = 50;
    private static final double NORM_MIN = Math.exp(-50.0);
    private static final double NORM_MAX = Math.exp(50.0);
    String alphaFile = null;
    String alphaLengthFile = null;
    String betaLengthFile = null;
    String expectFile = null;
    String expectLengthFile = null;
    String nodeMarginalFile = null;
    BufferedWriter alphaWriter = null;
    BufferedWriter alphaLengthWriter = null;
    BufferedWriter betaLengthWriter = null;
    BufferedWriter expectWriter = null;
    BufferedWriter expectLengthWriter = null;
    BufferedWriter nodeMarginalWriter = null;
    CacheProcessor.SolverSetup modelInfo;
    CacheProcessor cacheProcessor;
    CacheProcessor.FeatureEvaluation[] evals;
    CacheProcessor.LengthFeatureEvaluation[][] lengthEvals;
    boolean[] invalidTransitions;
    short maxLookback;
    CacheProcessor.StatePotentials[] statesWithLookback;
    CacheProcessor.StatePotentials[] statesWithoutLookback;
    List<TrainingSequence> data;
    int iter = 0;
    double[][] alphas;
    int[] alphaNorms;
    double[] starterAlpha;
    RecyclingBuffer<LookbackBuffer> lookbackBuffer;
    LookbackBuffer nextBuffer;
    double[] lambda;
    double logZ;
    int zNorm;
    double zInv;
    double[] expects;
    AlphaLengthFeatureProcessor alphaProcessor;
    BetaLengthFeatureProcessor betaProcessor;
    private double[] featureSums;

    @Override
    public void setTrainingData(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        this.cacheProcessor.setTrainingData(fm, data);
        this.modelInfo = this.cacheProcessor.getSolverSetup();
        Assert.a(this.modelInfo.maxStateLengths != null, "Maximum state lengths not set.");
        Assert.a(this.modelInfo.maxStateLengths.length == this.modelInfo.nStates, "Maximum state lengths array was length (" + this.modelInfo.maxStateLengths.length + ").  Must have one entry for each state " + this.modelInfo.nStates + ")");
        this.evals = this.cacheProcessor.getFeatureEvaluations();
        this.lengthEvals = this.cacheProcessor.getLengthFeatureEvaluations();
        this.invalidTransitions = this.cacheProcessor.getInvalidTransitions();
        this.maxLookback = this.modelInfo.maxLookback;
        this.statesWithLookback = this.modelInfo.statesWithLookback;
        this.statesWithoutLookback = this.modelInfo.statesWithoutLookback;
        this.alphas = new double[this.modelInfo.longestSeq][this.modelInfo.nStates];
        this.alphaNorms = new int[this.modelInfo.longestSeq];
        this.expects = new double[this.modelInfo.nFeatures];
        LookbackBuffer[] bufferContents = new LookbackBuffer[this.maxLookback + 3];
        for (int i = 0; i < this.maxLookback + 3; ++i) {
            bufferContents[i] = new LookbackBuffer();
        }
        this.lookbackBuffer = new RecyclingBuffer<LookbackBuffer>(bufferContents);
        this.nextBuffer = new LookbackBuffer();
        this.alphaProcessor = new AlphaLengthFeatureProcessor();
        this.betaProcessor = new BetaLengthFeatureProcessor();
        this.starterAlpha = new double[this.modelInfo.nStates];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double apply(double[] param, double[] grad) {
        log.debug((Object)String.format("Beginning It: %d Weights: %s", this.iter, ColtUtil.format(param)));
        this.alphaWriter = FileUtil.safeOpen(this.alphaFile);
        this.alphaLengthWriter = FileUtil.safeOpen(this.alphaLengthFile);
        this.betaLengthWriter = FileUtil.safeOpen(this.betaLengthFile);
        this.expectWriter = FileUtil.safeOpen(this.expectFile);
        this.expectLengthWriter = FileUtil.safeOpen(this.expectLengthFile);
        this.nodeMarginalWriter = FileUtil.safeOpen(this.nodeMarginalFile);
        this.lambda = param;
        Arrays.fill(grad, 0.0);
        double totalZ = 0.0;
        double result = 0.0;
        try {
            Arrays.fill(this.expects, 0.0);
            for (int i = 0; i < this.modelInfo.nSeqs; ++i) {
                double[][] seqFeatureSums;
                int len = this.modelInfo.seqOffsets[i + 1] - this.modelInfo.seqOffsets[i];
                this.alphaProcessor.computeAlpha(i, len);
                double sum = 0.0;
                for (double val : this.alphas[len - 1]) {
                    sum += val;
                }
                this.logZ = MaximumLikelihoodSemiMarkovGradient.log(sum) + (double)(50 * this.alphaNorms[len - 1]);
                this.zNorm = (int)this.logZ / 50;
                this.zInv = MaximumLikelihoodSemiMarkovGradient.exp((double)(this.zNorm * 50) - this.logZ);
                this.betaProcessor.computeBetasAndExpectations(i, len);
                if (log.isDebugEnabled() && (seqFeatureSums = this.cacheProcessor.getSequenceFeatureSums()) != null) {
                    double seqResult = 0.0;
                    for (int j = 0; j < this.modelInfo.nFeatures; ++j) {
                        seqResult += seqFeatureSums[i][j] * param[j];
                    }
                    log.debug((Object)String.format("Seq: %d L: %g LL: %f Training path: %f Z: %f", i, MaximumLikelihoodSemiMarkovGradient.exp(seqResult - this.logZ), seqResult - this.logZ, seqResult, this.logZ));
                    if (MaximumLikelihoodSemiMarkovGradient.exp(seqResult - this.logZ) == 1.0) {
                        log.debug((Object)"!!!!exp(seqResult-logZ) == 1.0");
                    }
                }
                totalZ += this.logZ;
            }
            double[] featureSums = this.cacheProcessor.getFeatureSums();
            this.featureSums = featureSums;
            for (int j = 0; j < this.modelInfo.nFeatures; ++j) {
                result += featureSums[j] * param[j];
                grad[j] = featureSums[j] - this.expects[j];
            }
            log.debug((Object)("Path Value: " + result + " Norm: " + totalZ));
            result -= totalZ;
            if (log.isInfoEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("It: %d L=%e, LL=%f, norm(grad): %f Sums: %s Expects: %s Weights: %s Grad: %s", this.iter, MaximumLikelihoodSemiMarkovGradient.exp(result), result, ColtUtil.norm(grad), ColtUtil.format(featureSums), ColtUtil.format(this.expects), ColtUtil.format(param), ColtUtil.format(grad)));
                } else {
                    log.info((Object)String.format("It: %d LL=%f, norm(grad): %f", this.iter, MaximumLikelihoodSemiMarkovGradient.exp(result), result, ColtUtil.norm(grad)));
                }
            }
            Assert.a(MaximumLikelihoodSemiMarkovGradient.exp(result) <= 1.0, "Likelihood is greater than 1.");
            result /= (double)this.modelInfo.totalPositions;
            for (int i = 0; i < grad.length; ++i) {
                grad[i] = grad[i] / (double)this.modelInfo.totalPositions;
            }
            ++this.iter;
        }
        finally {
            FileUtil.safeClose(this.alphaWriter);
            FileUtil.safeClose(this.alphaLengthWriter);
            FileUtil.safeClose(this.betaLengthWriter);
            FileUtil.safeClose(this.expectWriter);
            FileUtil.safeClose(this.expectLengthWriter);
            FileUtil.safeClose(this.nodeMarginalWriter);
        }
        return result;
    }

    @Override
    public void clean() {
        this.modelInfo = null;
        this.cacheProcessor = null;
        this.evals = null;
        this.lengthEvals = null;
        this.invalidTransitions = null;
        this.statesWithLookback = null;
        this.statesWithoutLookback = null;
        this.data = null;
        this.alphas = null;
        this.alphaNorms = null;
        this.starterAlpha = null;
        this.lookbackBuffer = null;
        this.nextBuffer = null;
        this.expects = null;
        this.alphaProcessor = null;
        this.betaProcessor = null;
    }

    void logBuf() {
        int l = this.lookbackBuffer.length;
        String s = "";
        for (int i = 0; i < l; ++i) {
            s = s + this.lookbackBuffer.get((int)i).pos + " ";
        }
        log.info((Object)s);
    }

    void logBufBeta() {
        int l = this.lookbackBuffer.length;
        String s = "";
        for (int i = 0; i < l; ++i) {
            s = s + ColtUtil.format(this.lookbackBuffer.get((int)i).beta) + " ";
        }
        log.info((Object)s);
    }

    void cacheMi(int seqNum, double[] mi, double[] prevStable, double[] newStable, int miPos) {
        if (miPos < 0) {
            return;
        }
        this.calcMi(mi, seqNum, miPos, false);
        for (int i = 0; i < this.modelInfo.nStates; ++i) {
            if (this.modelInfo.maxStateLengths[i] <= 1) continue;
            newStable[i] = prevStable[i];
            double trans = mi[this.modelInfo.selfTransitions[i]];
            if (Double.isInfinite(trans)) continue;
            int n = i;
            newStable[n] = newStable[n] + trans;
        }
    }

    void calcMi(double[] mi, int seq, int pos, boolean doExp) {
        this.cacheProcessor.evaluatePosition(seq, pos);
        double nodeVal = Double.NaN;
        int overallPosition = this.modelInfo.seqOffsets[seq] + pos;
        int invalidIndex = overallPosition * this.modelInfo.nPotentials;
        for (short potential : this.modelInfo.orderedPotentials) {
            boolean invalid = this.invalidTransitions[invalidIndex + potential];
            double features = invalid ? Double.NEGATIVE_INFINITY : 0.0;
            CacheProcessor.FeatureEvaluation potEvals = this.evals[potential];
            short[] indices = potEvals.index;
            float[] vals = potEvals.value;
            int i = 0;
            short index = indices[i];
            while (index >= 0) {
                features += (double)vals[i] * this.lambda[index];
                index = indices[++i];
            }
            if (index == Short.MIN_VALUE) {
                features = Double.NEGATIVE_INFINITY;
            }
            if (potential < this.modelInfo.nStates) {
                nodeVal = features;
                continue;
            }
            int transition = potential - this.modelInfo.nStates;
            double val = features + nodeVal;
            if (doExp) {
                val = MaximumLikelihoodSemiMarkovGradient.exp(val);
            }
            mi[transition] = val;
        }
    }

    private static final void renormalize(double[] vec, int currentNorm, int newNorm) {
        double factor = MaximumLikelihoodSemiMarkovGradient.exp(50 * (currentNorm - newNorm));
        int len = vec.length;
        for (int i = 0; i < len; ++i) {
            if (vec[i] == 0.0) continue;
            int n = i;
            vec[n] = vec[n] * factor;
        }
    }

    private static final int normalize(double[] vec) {
        double sum = 0.0;
        for (double val : vec) {
            sum += val;
        }
        if (sum == 0.0 || sum > NORM_MIN && sum < NORM_MAX) {
            return 0;
        }
        if (debug) {
            Assert.a(!Double.isNaN(sum));
        }
        double val = MaximumLikelihoodSemiMarkovGradient.log(sum);
        int norm = (int)val / 50;
        val = MaximumLikelihoodSemiMarkovGradient.exp(50 * norm);
        int len = vec.length;
        int i = 0;
        while (i < len) {
            int n = i++;
            vec[n] = vec[n] / val;
        }
        return norm;
    }

    private static final double exp(double val) {
        return Math.exp(val);
    }

    private static final double log(double val) {
        return Math.log(val);
    }

    public static final String printNorm(double value, int norm) {
        if (value == 0.0) {
            return "0 (" + norm + ")";
        }
        if (Double.isNaN(value)) {
            return "NaN (" + norm + ")";
        }
        int exponent = (int)MaximumLikelihoodSemiMarkovGradient.log(value);
        double eValue = value / MaximumLikelihoodSemiMarkovGradient.exp(exponent);
        if (Double.isNaN(eValue)) {
            return String.format("NaN(%e n:%d)", value, norm);
        }
        return String.format("%fe%d", eValue, exponent + norm * 50);
    }

    public CacheProcessor getCacheProcessor() {
        return this.cacheProcessor;
    }

    public void setCacheProcessor(CacheProcessor cacheProcessor) {
        this.cacheProcessor = cacheProcessor;
    }

    public String getAlphaLengthFile() {
        return this.alphaLengthFile;
    }

    public void setAlphaLengthFile(String alphaLengthFile) {
        this.alphaLengthFile = alphaLengthFile;
    }

    public String getAlphaFile() {
        return this.alphaFile;
    }

    public void setAlphaFile(String alphaFile) {
        this.alphaFile = alphaFile;
    }

    public String getExpectFile() {
        return this.expectFile;
    }

    public void setExpectFile(String expectFile) {
        this.expectFile = expectFile;
    }

    public String getExpectLengthFile() {
        return this.expectLengthFile;
    }

    public void setExpectLengthFile(String expectLengthFile) {
        this.expectLengthFile = expectLengthFile;
    }

    public String getNodeMarginalFile() {
        return this.nodeMarginalFile;
    }

    public void setNodeMarginalFile(String nodeMarginalFile) {
        this.nodeMarginalFile = nodeMarginalFile;
    }

    public String getBetaLengthFile() {
        return this.betaLengthFile;
    }

    public void setBetaLengthFile(String betaLengthFile) {
        this.betaLengthFile = betaLengthFile;
    }

    public double[] getFeatureSums() {
        return (double[])this.featureSums.clone();
    }

    final class LookbackBuffer {
        int pos;
        double[] mi;
        double[] stableState;
        double[] beta;
        int betaNorm;
        double[] transitionProb;

        LookbackBuffer() {
            this.mi = new double[MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nPotentials];
            this.stableState = new double[MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates];
            this.beta = new double[MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates];
            this.transitionProb = new double[MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nTransitions];
        }

        void clear() {
            this.pos = -1;
            Arrays.fill(this.beta, 0.0);
            this.betaNorm = Integer.MIN_VALUE;
            Arrays.fill(this.transitionProb, 0.0);
        }
    }

    class BetaLengthFeatureProcessor {
        int seqOffset;
        int lengthPos;
        double[] lengthStable;
        int miPos;
        double[] stableState;
        double[] beta;
        int betaNorm;
        double prob;
        LookbackBuffer posLookback;
        LookbackBuffer prevLookback;
        double[] nodeProb;
        double[] newNodeProb;
        double[] edgeProb;

        BetaLengthFeatureProcessor() {
            this.nodeProb = new double[MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates];
            this.newNodeProb = new double[MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates];
            this.edgeProb = new double[MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nTransitions];
        }

        void computeBetasAndExpectations(int seqNum, int len) {
            this.seqOffset = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.seqOffsets[seqNum];
            int lastInitPos = len - 2 - MaximumLikelihoodSemiMarkovGradient.this.maxLookback;
            this.posLookback = MaximumLikelihoodSemiMarkovGradient.this.nextBuffer;
            this.prevLookback = null;
            Arrays.fill(this.nodeProb, 0.0);
            Arrays.fill(this.newNodeProb, 0.0);
            this.miPos = len - 1;
            MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.clear();
            for (int pos = len - 1; pos >= 0; --pos) {
                while (this.miPos >= 0 && this.miPos >= lastInitPos) {
                    if (this.miPos == len - 1) {
                        Arrays.fill(MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.stableState, 0.0);
                    } else {
                        MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.clear();
                        MaximumLikelihoodSemiMarkovGradient.this.cacheMi(seqNum, MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.mi, this.stableState, MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.stableState, this.miPos + 1);
                    }
                    MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.pos = this.miPos--;
                    this.stableState = MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.stableState;
                    MaximumLikelihoodSemiMarkovGradient.this.nextBuffer = MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.addFirst(MaximumLikelihoodSemiMarkovGradient.this.nextBuffer);
                    MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.clear();
                }
                this.posLookback = MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.get(pos - this.miPos - 1);
                if (debug) {
                    Assert.a(this.posLookback.pos == pos, "Wrong lookback buffer: was ", this.posLookback.pos, " should be ", pos);
                }
                if (this.prevLookback == null) {
                    if (debug) {
                        Assert.a(pos == len - 1);
                    }
                    Arrays.fill(this.posLookback.beta, 1.0);
                    this.posLookback.betaNorm = 0;
                    double nodeNorm = MaximumLikelihoodSemiMarkovGradient.exp((MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[pos] - MaximumLikelihoodSemiMarkovGradient.this.zNorm) * 50) * MaximumLikelihoodSemiMarkovGradient.this.zInv;
                    for (int i = 0; i < MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates; ++i) {
                        this.nodeProb[i] = nodeNorm * MaximumLikelihoodSemiMarkovGradient.this.alphas[pos][i];
                    }
                    log.debug((Object)("Node marginals at seq " + seqNum + " last position (" + pos + "): " + ColtUtil.format(this.nodeProb)));
                } else {
                    if (debug) {
                        Assert.a(this.prevLookback.pos == pos + 1);
                    }
                    this.posLookback.betaNorm = this.regularBetaUpdate(pos + 1, this.posLookback.beta, this.posLookback.betaNorm, this.prevLookback.beta, this.prevLookback.betaNorm, this.prevLookback.transitionProb, this.posLookback.mi);
                    this.beta = this.prevLookback.beta;
                    this.betaNorm = this.prevLookback.betaNorm;
                    this.lengthStable = this.prevLookback.stableState;
                    this.lengthPos = pos + 1;
                    this.lengthBeta(seqNum, this.lengthPos);
                    System.arraycopy(this.nodeProb, 0, this.newNodeProb, 0, MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates);
                    for (CacheProcessor.StatePotentials lb : MaximumLikelihoodSemiMarkovGradient.this.statesWithLookback) {
                        byte state = lb.state;
                        int index = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.selfTransitions[state];
                        double transProb = this.nodeProb[state];
                        for (byte pot : lb.potentials) {
                            double lbTrans = this.posLookback.transitionProb[pot - MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates];
                            transProb -= lbTrans;
                            byte by = state;
                            this.newNodeProb[by] = this.newNodeProb[by] - lbTrans;
                        }
                        Assert.a(this.posLookback.transitionProb[index] == 0.0);
                        this.posLookback.transitionProb[index] = transProb;
                    }
                }
                double sum = 0.0;
                for (double x : this.nodeProb) {
                    if (x > 1.0001 || x < -1.0E-4) {
                        Assert.a(false, "Iter ", MaximumLikelihoodSemiMarkovGradient.this.iter, " Pos: " + pos + " Node marginals not valid " + x);
                    }
                    sum += x;
                }
                if (Math.abs(1.0 - sum) > 1.0E-4) {
                    Assert.a(false, "Iter ", MaximumLikelihoodSemiMarkovGradient.this.iter, " Pos: " + pos + " Node marginals sum to " + sum + " not 1: ", ColtUtil.format(this.nodeProb), " at ", seqNum, " ", pos);
                }
                if (this.prevLookback != null) {
                    if (debug) {
                        sum = 0.0;
                        for (double x : this.edgeProb) {
                            if (x > 1.0001 || x < -1.0E-4) {
                                Assert.a(false, "Iter ", MaximumLikelihoodSemiMarkovGradient.this.iter, " Pos: " + pos + " Edge marginal not valid " + x);
                            }
                            sum += x;
                        }
                        for (double x : this.posLookback.transitionProb) {
                            if (x > 1.0001 || x < -1.0E-4) {
                                Assert.a(false, "Iter ", MaximumLikelihoodSemiMarkovGradient.this.iter, " Pos: " + pos + " Self-trans marginal not valid " + x);
                            }
                            sum += x;
                        }
                        if (Math.abs(1.0 - sum) > 0.001) {
                            Assert.a(false, "Edge marginals don't sum to 1.  Sum to: ", sum, " - ", ColtUtil.format(this.edgeProb), ColtUtil.format(this.posLookback.transitionProb));
                        }
                    }
                    this.updateExpectations(seqNum, pos + 1, this.posLookback.transitionProb);
                }
                double[] temp = this.nodeProb;
                this.nodeProb = this.newNodeProb;
                this.newNodeProb = temp;
                this.prevLookback = this.posLookback;
                --lastInitPos;
            }
            this.posLookback.betaNorm = this.regularBetaUpdate(0, null, this.posLookback.betaNorm, this.posLookback.beta, this.posLookback.betaNorm, null, null);
            this.beta = this.posLookback.beta;
            this.betaNorm = this.posLookback.betaNorm;
            this.lengthStable = this.posLookback.stableState;
            this.lengthPos = 0;
            this.lengthBeta(seqNum, this.lengthPos);
            this.updateExpectations(seqNum, 0, this.posLookback.transitionProb);
        }

        private int regularBetaUpdate(int pos, double[] newBeta, int newNorm, double[] oldBeta, int oldNorm, double[] transitionProb, double[] mi) {
            int norm = newNorm;
            double normAdjust = 0.0;
            if (oldNorm > newNorm) {
                MaximumLikelihoodSemiMarkovGradient.renormalize(newBeta, newNorm, oldNorm);
                norm = oldNorm;
                newNorm = oldNorm;
            } else {
                normAdjust = (oldNorm - newNorm) * 50;
            }
            double[] nodeAlpha = MaximumLikelihoodSemiMarkovGradient.this.alphas[pos];
            double nodeNorm = MaximumLikelihoodSemiMarkovGradient.exp((MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[pos] + oldNorm - MaximumLikelihoodSemiMarkovGradient.this.zNorm) * 50) * MaximumLikelihoodSemiMarkovGradient.this.zInv;
            double[] edgeAlpha = null;
            double edgeNorm = Double.NaN;
            if (pos > 0) {
                edgeAlpha = MaximumLikelihoodSemiMarkovGradient.this.alphas[pos - 1];
                edgeNorm = MaximumLikelihoodSemiMarkovGradient.exp((MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[pos - 1] + newNorm - MaximumLikelihoodSemiMarkovGradient.this.zNorm) * 50) * MaximumLikelihoodSemiMarkovGradient.this.zInv;
            }
            for (CacheProcessor.StatePotentials potentials : MaximumLikelihoodSemiMarkovGradient.this.statesWithoutLookback) {
                byte node = potentials.state;
                double nodePotential = 0.0;
                double betaVal = oldBeta[node];
                if (MaximumLikelihoodSemiMarkovGradient.this.nodeMarginalWriter != null) {
                    FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.nodeMarginalWriter, String.format("NodeMarg[%d][%d] = %f = %f * %f * %f (aN: %d bN: %d zN: %d 1/z: %f)\n", pos, node, nodeAlpha[node] * betaVal * nodeNorm, nodeAlpha[node], betaVal, nodeNorm, MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[pos], oldNorm, MaximumLikelihoodSemiMarkovGradient.this.zNorm, MaximumLikelihoodSemiMarkovGradient.this.zInv));
                }
                this.nodeProb[node] = nodeAlpha[node] * betaVal * nodeNorm;
                if (pos <= 0) continue;
                byte[] arr$ = potentials.potentials;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    short potential = arr$[i$];
                    int trans = potential - MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates;
                    double transVal = mi[trans];
                    if (!Double.isInfinite(transVal)) {
                        short from;
                        double potentialValue = MaximumLikelihoodSemiMarkovGradient.exp(mi[trans] + normAdjust);
                        nodePotential += potentialValue;
                        short s = from = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.transitionFrom[trans];
                        newBeta[s] = newBeta[s] + potentialValue * betaVal;
                        this.edgeProb[trans] = edgeAlpha[from] * potentialValue * betaVal * edgeNorm;
                        continue;
                    }
                    this.edgeProb[trans] = 0.0;
                }
            }
            int ret = norm;
            if (newBeta != null) {
                try {
                    ret += MaximumLikelihoodSemiMarkovGradient.normalize(newBeta);
                }
                catch (RuntimeException ex) {
                    log.warn((Object)("Normalization problem at " + pos + " " + ColtUtil.format(newBeta)));
                    throw ex;
                }
            }
            return ret;
        }

        private void lengthBeta(int seqNum, int pos) {
            MaximumLikelihoodSemiMarkovGradient.this.cacheProcessor.evaluateSegmentsEndingAt(seqNum, pos);
            int nSemiMarkovStates = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.statesWithLookback.length;
            for (int i = 0; i < nSemiMarkovStates; ++i) {
                CacheProcessor.LengthFeatureEvaluation[] lookbacksForState = MaximumLikelihoodSemiMarkovGradient.this.lengthEvals[i];
                CacheProcessor.StatePotentials statePotentials = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.statesWithLookback[i];
                byte toNode = statePotentials.state;
                int lbArrayIndex = 0;
                CacheProcessor.LengthFeatureEvaluation lengthEval = lookbacksForState[lbArrayIndex];
                short lookback = lengthEval.lookback;
                while (lookback != -1) {
                    double stableValue;
                    int prevPos = this.lengthPos - lookback - 1;
                    int lbIndex = prevPos - this.miPos - 1;
                    LookbackBuffer segBegin = null;
                    if (prevPos >= 0) {
                        segBegin = ((LookbackBuffer[])MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.array)[(MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.currentStart + lbIndex) % MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.length];
                    }
                    LookbackBuffer stableBuffer = ((LookbackBuffer[])MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.array)[(MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.currentStart + lbIndex + 1) % MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.length];
                    double nodePotential = stableValue = stableBuffer.stableState[toNode] - this.lengthStable[toNode];
                    CacheProcessor.FeatureEvaluation nodeEvals = lengthEval.nodeEval;
                    short[] indices = nodeEvals.index;
                    float[] vals = nodeEvals.value;
                    int ix = 0;
                    short index = indices[ix];
                    while (index >= 0) {
                        nodePotential += (double)vals[ix] * MaximumLikelihoodSemiMarkovGradient.this.lambda[index];
                        index = indices[++ix];
                    }
                    if (debug) {
                        Assert.a(index != Short.MIN_VALUE, "Node lengths should only be returned in the cache if they are valid.  They can be invalid because a node is invalid or a self-transition edge is invalid.");
                    }
                    if (prevPos < 0) {
                        double expVal = nodePotential + MaximumLikelihoodSemiMarkovGradient.this.starterAlpha[toNode];
                        this.lengthBetaHandling(seqNum, prevPos, pos, expVal, -1, toNode, 1.0, 0, nodeEvals);
                    } else {
                        CacheProcessor.FeatureEvaluation[] edgeEvals = lengthEval.edgeEvals;
                        int nEdges = statePotentials.potentials.length;
                        for (int edgeIx = 0; edgeIx < nEdges; ++edgeIx) {
                            byte potential = statePotentials.potentials[edgeIx];
                            int trans = potential - MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates;
                            short fromNode = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.transitionFrom[trans];
                            if (fromNode == toNode) continue;
                            double edgeVal = 0.0;
                            if (edgeEvals == null) {
                                int invalidIndex = (this.seqOffset + prevPos + 1) * MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nPotentials;
                                if (MaximumLikelihoodSemiMarkovGradient.this.invalidTransitions[invalidIndex + potential]) {
                                    continue;
                                }
                            } else {
                                CacheProcessor.FeatureEvaluation potEvals = edgeEvals[edgeIx];
                                indices = potEvals.index;
                                vals = potEvals.value;
                                ix = 0;
                                index = indices[i];
                                while (index >= 0) {
                                    edgeVal += (double)vals[ix] * MaximumLikelihoodSemiMarkovGradient.this.lambda[index];
                                    index = indices[++ix];
                                }
                                if (index == Short.MIN_VALUE) continue;
                            }
                            if (debug) {
                                Assert.a(this.prevLookback.pos == this.lengthPos, "Expected ", this.lengthPos, " was ", this.prevLookback.pos);
                                Assert.a(segBegin.pos == this.lengthPos - lookback - 1, "Expected ", this.lengthPos - lookback - 1, " was ", segBegin.pos);
                            }
                            double expVal = edgeVal + segBegin.mi[trans] + nodePotential;
                            double prevAlpha = MaximumLikelihoodSemiMarkovGradient.this.alphas[prevPos][fromNode];
                            int prevAlphaNorm = MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[prevPos];
                            int expNorm = this.lengthBetaHandling(seqNum, prevPos, pos, expVal, fromNode, toNode, prevAlpha, prevAlphaNorm, nodeEvals);
                            expVal -= (double)(expNorm * 50);
                            int updateNorm = expNorm + this.betaNorm;
                            if (updateNorm > segBegin.betaNorm) {
                                MaximumLikelihoodSemiMarkovGradient.renormalize(segBegin.beta, segBegin.betaNorm, updateNorm);
                                segBegin.betaNorm = updateNorm;
                            } else if (segBegin.betaNorm > updateNorm) {
                                int expShift = updateNorm - segBegin.betaNorm;
                                expNorm += expShift;
                                expVal += (double)(expShift * 50);
                            }
                            double transPotential = MaximumLikelihoodSemiMarkovGradient.exp(expVal);
                            double update = transPotential * this.beta[toNode];
                            short s = fromNode;
                            segBegin.beta[s] = segBegin.beta[s] + update;
                            if (edgeEvals != null) {
                                CacheProcessor.FeatureEvaluation potEvals = edgeEvals[edgeIx];
                                indices = potEvals.index;
                                vals = potEvals.value;
                                ix = 0;
                                index = indices[i];
                                while (index != -1) {
                                    if (MaximumLikelihoodSemiMarkovGradient.this.expectLengthWriter != null) {
                                        FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.expectLengthWriter, String.format("Seq %d Pos %d-%d Expect #%d: %e = %e + Prob: %e * EdgeVal: %e\n", seqNum, prevPos, pos, index, MaximumLikelihoodSemiMarkovGradient.this.expects[index] + this.prob * (double)vals[i], MaximumLikelihoodSemiMarkovGradient.this.expects[index], this.prob, Float.valueOf(vals[i])));
                                    }
                                    short s2 = index;
                                    MaximumLikelihoodSemiMarkovGradient.this.expects[s2] = MaximumLikelihoodSemiMarkovGradient.this.expects[s2] + this.prob * (double)vals[ix];
                                    index = indices[++ix];
                                }
                            }
                            int n = trans;
                            segBegin.transitionProb[n] = segBegin.transitionProb[n] + this.prob;
                            if (MaximumLikelihoodSemiMarkovGradient.this.betaLengthWriter == null) continue;
                            FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.betaLengthWriter, String.format(String.format("Beta[%d][%d] = %s = %s + %s beta[%d][%d] * %s exp(Edge: %f Node: %f Stable: %f Trans: %f)\n", prevPos, (int)fromNode, MaximumLikelihoodSemiMarkovGradient.printNorm(segBegin.beta[fromNode], segBegin.betaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(segBegin.beta[fromNode] - update, segBegin.betaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(this.beta[toNode], this.betaNorm), this.lengthPos, toNode, MaximumLikelihoodSemiMarkovGradient.printNorm(transPotential, expNorm), edgeVal, nodePotential - stableValue, stableValue, segBegin.mi[trans]), new Object[0]));
                        }
                    }
                    lengthEval = lookbacksForState[++lbArrayIndex];
                    lookback = lengthEval.lookback;
                }
            }
        }

        int lengthBetaHandling(int seqNum, int prevPos, int pos, double expVal, int fromNode, int toNode, double prevAlpha, int prevAlphaNorm, CacheProcessor.FeatureEvaluation nodeEvals) {
            int norm = (int)expVal / 50;
            double afterExp = MaximumLikelihoodSemiMarkovGradient.exp((expVal -= (double)(norm * 50)) + (double)(50 * (prevAlphaNorm + norm + this.betaNorm - MaximumLikelihoodSemiMarkovGradient.this.zNorm)));
            this.prob = prevAlpha == 0.0 || this.beta[toNode] == 0.0 ? 0.0 : prevAlpha * this.beta[toNode] * afterExp * MaximumLikelihoodSemiMarkovGradient.this.zInv;
            if (Double.isNaN(this.prob)) {
                log.info((Object)String.format("NaN = Alpha: %s * Beta: %s * Seg: %s / Z: %s", MaximumLikelihoodSemiMarkovGradient.printNorm(prevAlpha, prevAlphaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(this.beta[toNode], this.betaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(MaximumLikelihoodSemiMarkovGradient.exp(expVal), norm), MaximumLikelihoodSemiMarkovGradient.printNorm(1.0 / MaximumLikelihoodSemiMarkovGradient.this.zInv, MaximumLikelihoodSemiMarkovGradient.this.zNorm)));
                Assert.a(false, String.format("Seq: %d Pos: %d-%d: Bad prob (NaN) = Alpha: %e * Beta[%d] %e * %e exp(%f Norm  a:%d n:%d b:%d z:%d) * %e", seqNum, prevPos, pos, prevAlpha, toNode, this.beta[toNode], afterExp, expVal, prevAlphaNorm, norm, this.betaNorm, MaximumLikelihoodSemiMarkovGradient.this.zNorm, MaximumLikelihoodSemiMarkovGradient.this.zInv));
            }
            short[] indices = nodeEvals.index;
            float[] vals = nodeEvals.value;
            int i = 0;
            short index = indices[i];
            while (index != -1) {
                if (MaximumLikelihoodSemiMarkovGradient.this.expectLengthWriter != null) {
                    FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.expectLengthWriter, String.format("Seq %d Pos %d-%d Expect #%d: %e = %e + Prob: %e * NodeVal: %e\n", seqNum, prevPos, pos, index, MaximumLikelihoodSemiMarkovGradient.this.expects[index] + this.prob * (double)vals[i], MaximumLikelihoodSemiMarkovGradient.this.expects[index], this.prob, Float.valueOf(vals[i])));
                }
                if (this.prob != 0.0) {
                    short s = index;
                    MaximumLikelihoodSemiMarkovGradient.this.expects[s] = MaximumLikelihoodSemiMarkovGradient.this.expects[s] + this.prob * (double)vals[i];
                }
                index = indices[++i];
            }
            if (MaximumLikelihoodSemiMarkovGradient.this.nodeMarginalWriter != null) {
                FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.nodeMarginalWriter, String.format("NodeMarg[%d][%d] = %f = %f + Alpha[%d][%d]: %s * Beta[%d][%d]: %s * seg: %s / Z: %s\n", this.lengthPos, toNode, this.nodeProb[toNode] + this.prob, this.nodeProb[toNode], prevPos, fromNode, MaximumLikelihoodSemiMarkovGradient.printNorm(prevAlpha, prevAlphaNorm), pos, toNode, MaximumLikelihoodSemiMarkovGradient.printNorm(this.beta[toNode], this.betaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(expVal, norm), MaximumLikelihoodSemiMarkovGradient.printNorm(1.0 / MaximumLikelihoodSemiMarkovGradient.this.zInv, MaximumLikelihoodSemiMarkovGradient.this.zNorm)));
            }
            int n = toNode;
            this.nodeProb[n] = this.nodeProb[n] + this.prob;
            return norm;
        }

        void updateExpectations(int seqNum, int pos, double[] transitionProb) {
            MaximumLikelihoodSemiMarkovGradient.this.cacheProcessor.evaluatePosition(seqNum, pos);
            int invalidIndex = (this.seqOffset + pos) * MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nPotentials;
            boolean lengthNode = false;
            for (short potential : MaximumLikelihoodSemiMarkovGradient.this.modelInfo.orderedPotentials) {
                boolean invalid = MaximumLikelihoodSemiMarkovGradient.this.invalidTransitions[invalidIndex + potential];
                double prob = Double.NaN;
                if (potential < MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates) {
                    lengthNode = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.maxStateLengths[potential] > 1;
                    prob = this.nodeProb[potential];
                } else {
                    if (pos == 0) continue;
                    prob = (lengthNode ? transitionProb : this.edgeProb)[potential - MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates];
                }
                if (invalid) continue;
                CacheProcessor.FeatureEvaluation potEvals = MaximumLikelihoodSemiMarkovGradient.this.evals[potential];
                short[] indices = potEvals.index;
                float[] vals = potEvals.value;
                int i = 0;
                short index = indices[i];
                while (index != -1) {
                    if (MaximumLikelihoodSemiMarkovGradient.this.expectWriter != null) {
                        FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.expectWriter, String.format("Seq %d Pos %d Expect #%d: %e = %e + Prob: %e * Val: %e\n", seqNum, pos, index, MaximumLikelihoodSemiMarkovGradient.this.expects[index] + prob * (double)vals[i], MaximumLikelihoodSemiMarkovGradient.this.expects[index], prob, Float.valueOf(vals[i])));
                    }
                    short s = index;
                    MaximumLikelihoodSemiMarkovGradient.this.expects[s] = MaximumLikelihoodSemiMarkovGradient.this.expects[s] + prob * (double)vals[i];
                    index = indices[++i];
                }
            }
        }
    }

    private final class AlphaLengthFeatureProcessor {
        int seqOffset;
        int pos;
        double[] alpha;
        int alphaNorm;
        double[] stableState;

        private AlphaLengthFeatureProcessor() {
        }

        final void computeAlpha(int seqNum, int len) {
            Arrays.fill(MaximumLikelihoodSemiMarkovGradient.this.alphaNorms, Integer.MIN_VALUE);
            Arrays.fill(MaximumLikelihoodSemiMarkovGradient.this.starterAlpha, 0.0);
            double[] prevAlpha = null;
            this.seqOffset = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.seqOffsets[seqNum];
            this.pos = 0;
            while (this.pos < len) {
                prevAlpha = this.alpha;
                this.alpha = MaximumLikelihoodSemiMarkovGradient.this.alphas[this.pos];
                Arrays.fill(this.alpha, 0.0);
                if (this.pos == 0) {
                    this.alphaNorm = 0;
                    this.calcStartAlpha(this.alpha, seqNum);
                    Arrays.fill(MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.stableState, 0.0);
                } else {
                    MaximumLikelihoodSemiMarkovGradient.this.cacheMi(seqNum, MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.mi, this.stableState, MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.stableState, this.pos);
                    this.regularAlphaUpdate(this.pos, MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.mi, prevAlpha, this.alpha);
                }
                this.stableState = MaximumLikelihoodSemiMarkovGradient.this.nextBuffer.stableState;
                MaximumLikelihoodSemiMarkovGradient.this.nextBuffer = MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.addFirst(MaximumLikelihoodSemiMarkovGradient.this.nextBuffer);
                this.lengthAlpha(seqNum, this.pos);
                int norm = MaximumLikelihoodSemiMarkovGradient.normalize(this.alpha);
                this.alphaNorm += norm;
                MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[this.pos] = this.alphaNorm;
                ++this.pos;
            }
        }

        private final void regularAlphaUpdate(int pos, double[] mi, double[] lastAlpha, double[] newAlpha) {
            double nodeVal = 0.0;
            int lastState = -1;
            boolean lengthNode = false;
            for (int n : MaximumLikelihoodSemiMarkovGradient.this.modelInfo.orderedPotentials) {
                int trans;
                double transVal;
                if (n < MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates) {
                    if (lastState != -1) {
                        newAlpha[lastState] = nodeVal;
                    }
                    lastState = n;
                    nodeVal = 0.0;
                    lengthNode = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.maxStateLengths[n] > 1;
                    continue;
                }
                if (lengthNode || Double.isInfinite(transVal = mi[trans = n - MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates])) continue;
                short from = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.transitionFrom[trans];
                if (MaximumLikelihoodSemiMarkovGradient.this.alphaWriter != null) {
                    FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.alphaWriter, String.format("alpha[%d][%d] = %s = %s + alpha[%d][%d] %s * %s exp(%f)\n", pos, lastState, MaximumLikelihoodSemiMarkovGradient.printNorm(nodeVal + lastAlpha[from] * MaximumLikelihoodSemiMarkovGradient.exp(mi[trans]), this.alphaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(nodeVal, this.alphaNorm), pos - 1, (int)from, MaximumLikelihoodSemiMarkovGradient.printNorm(lastAlpha[from], this.alphaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(MaximumLikelihoodSemiMarkovGradient.exp(mi[trans]), 0), mi[trans]));
                }
                nodeVal += lastAlpha[from] * MaximumLikelihoodSemiMarkovGradient.exp(transVal);
            }
            newAlpha[lastState] = nodeVal;
        }

        private final void lengthAlpha(int seqNum, int pos) {
            MaximumLikelihoodSemiMarkovGradient.this.cacheProcessor.evaluateSegmentsEndingAt(seqNum, pos);
            int nSemiMarkovStates = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.statesWithLookback.length;
            for (int i = 0; i < nSemiMarkovStates; ++i) {
                CacheProcessor.LengthFeatureEvaluation[] lookbacksForState = MaximumLikelihoodSemiMarkovGradient.this.lengthEvals[i];
                CacheProcessor.StatePotentials statePotentials = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.statesWithLookback[i];
                byte toNode = statePotentials.state;
                int lbIndex = 0;
                CacheProcessor.LengthFeatureEvaluation lengthEval = lookbacksForState[lbIndex];
                short lookback = lengthEval.lookback;
                while (lookback != -1) {
                    double stableValue;
                    int prevPos = pos - lookback - 1;
                    LookbackBuffer buffer = ((LookbackBuffer[])MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.array)[(MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.currentStart + lookback) % MaximumLikelihoodSemiMarkovGradient.this.lookbackBuffer.length];
                    CacheProcessor.FeatureEvaluation nodeEvals = lengthEval.nodeEval;
                    short[] indices = nodeEvals.index;
                    float[] vals = nodeEvals.value;
                    int ix = 0;
                    short index = indices[ix];
                    double nodePotential = stableValue = this.stableState[toNode] - buffer.stableState[toNode];
                    while (index >= 0) {
                        nodePotential += (double)vals[ix] * MaximumLikelihoodSemiMarkovGradient.this.lambda[index];
                        index = indices[++ix];
                    }
                    if (debug) {
                        Assert.a(index != Short.MIN_VALUE, "Node lengths should only be returned in the cache if they are valid");
                    }
                    if (prevPos < 0) {
                        double nodeVal = nodePotential + MaximumLikelihoodSemiMarkovGradient.this.starterAlpha[toNode];
                        int norm = (int)nodeVal / 50;
                        nodeVal -= (double)(norm * 50);
                        if (norm > this.alphaNorm) {
                            MaximumLikelihoodSemiMarkovGradient.renormalize(this.alpha, this.alphaNorm, norm);
                            this.alphaNorm = norm;
                        } else if (norm < this.alphaNorm) {
                            nodeVal += (double)(50 * (norm - this.alphaNorm));
                        }
                        if (MaximumLikelihoodSemiMarkovGradient.this.alphaLengthWriter != null) {
                            FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.alphaLengthWriter, String.format("seq: %d alpha[%d][%d] = %s = %s + %s (Pot: %f Starter: %f)\n", seqNum, pos, toNode, MaximumLikelihoodSemiMarkovGradient.printNorm(this.alpha[toNode] + MaximumLikelihoodSemiMarkovGradient.exp(nodeVal), this.alphaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(this.alpha[toNode], this.alphaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(MaximumLikelihoodSemiMarkovGradient.exp(nodeVal), this.alphaNorm), nodePotential, MaximumLikelihoodSemiMarkovGradient.this.starterAlpha[toNode]));
                        }
                        byte by = toNode;
                        this.alpha[by] = this.alpha[by] + MaximumLikelihoodSemiMarkovGradient.exp(nodeVal);
                    } else {
                        CacheProcessor.FeatureEvaluation[] edgeEvals = lengthEval.edgeEvals;
                        int nEdges = statePotentials.potentials.length;
                        for (int edgeIx = 0; edgeIx < nEdges; ++edgeIx) {
                            byte potential = statePotentials.potentials[edgeIx];
                            int trans = potential - MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates;
                            short fromNode = MaximumLikelihoodSemiMarkovGradient.this.modelInfo.transitionFrom[trans];
                            if (fromNode == toNode) continue;
                            double edgeVal = 0.0;
                            if (edgeEvals == null) {
                                int invalidIndex = (this.seqOffset + prevPos + 1) * MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nPotentials;
                                if (MaximumLikelihoodSemiMarkovGradient.this.invalidTransitions[invalidIndex + potential]) {
                                    continue;
                                }
                            } else {
                                CacheProcessor.FeatureEvaluation potEvals = edgeEvals[edgeIx];
                                indices = potEvals.index;
                                vals = potEvals.value;
                                ix = 0;
                                index = indices[i];
                                while (index >= 0) {
                                    edgeVal += (double)vals[ix] * MaximumLikelihoodSemiMarkovGradient.this.lambda[index];
                                    index = indices[++ix];
                                }
                                if (index == Short.MIN_VALUE) continue;
                            }
                            double expVal = edgeVal + buffer.mi[trans] + nodePotential;
                            int expNorm = (int)expVal / 50;
                            expVal -= (double)(expNorm * 50);
                            int prevNorm = MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[prevPos];
                            int updateNorm = expNorm + prevNorm;
                            if (updateNorm > this.alphaNorm) {
                                MaximumLikelihoodSemiMarkovGradient.renormalize(this.alpha, this.alphaNorm, updateNorm);
                                this.alphaNorm = updateNorm;
                            } else if (this.alphaNorm > updateNorm) {
                                int expShift = this.alphaNorm - updateNorm;
                                expNorm += expShift;
                                expVal -= (double)(expShift * 50);
                            }
                            double prevAlpha = MaximumLikelihoodSemiMarkovGradient.this.alphas[prevPos][fromNode];
                            double update = MaximumLikelihoodSemiMarkovGradient.exp(expVal) * prevAlpha;
                            if (MaximumLikelihoodSemiMarkovGradient.this.alphaLengthWriter != null) {
                                FileUtil.safeWrite(MaximumLikelihoodSemiMarkovGradient.this.alphaLengthWriter, String.format("seq: %d alpha[%d][%d] = %s = %s + %s (alpha[%d][%d]) * %s exp(EdgeLength: %f NodeLength: %f Edge: %f Node: %f )\n", seqNum, pos, toNode, MaximumLikelihoodSemiMarkovGradient.printNorm(this.alpha[toNode] + update, this.alphaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(this.alpha[toNode], this.alphaNorm), MaximumLikelihoodSemiMarkovGradient.printNorm(prevAlpha, MaximumLikelihoodSemiMarkovGradient.this.alphaNorms[prevPos]), prevPos, MaximumLikelihoodSemiMarkovGradient.this.modelInfo.transitionFrom[trans], MaximumLikelihoodSemiMarkovGradient.printNorm(MaximumLikelihoodSemiMarkovGradient.exp(expVal), expNorm), edgeVal, nodePotential - stableValue, buffer.mi[trans], stableValue));
                            }
                            byte by = toNode;
                            this.alpha[by] = this.alpha[by] + update;
                            if (!debug) continue;
                            Assert.a(expNorm + prevNorm == this.alphaNorm, "Norm problem.  Exp: ", expNorm, " Prev alpha: ", prevNorm, " Alpha: ", this.alphaNorm);
                        }
                    }
                    lengthEval = lookbacksForState[++lbIndex];
                    lookback = lengthEval.lookback;
                }
            }
        }

        void calcStartAlpha(double[] currentAlpha, int seq) {
            MaximumLikelihoodSemiMarkovGradient.this.cacheProcessor.evaluatePosition(seq, 0);
            int invalidIndex = this.seqOffset * MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nPotentials;
            for (short potential : MaximumLikelihoodSemiMarkovGradient.this.modelInfo.orderedPotentials) {
                if (potential >= MaximumLikelihoodSemiMarkovGradient.this.modelInfo.nStates) continue;
                boolean invalid = MaximumLikelihoodSemiMarkovGradient.this.invalidTransitions[invalidIndex + potential];
                double features = invalid ? Double.NEGATIVE_INFINITY : 0.0;
                CacheProcessor.FeatureEvaluation potEvals = MaximumLikelihoodSemiMarkovGradient.this.evals[potential];
                short[] indices = potEvals.index;
                float[] vals = potEvals.value;
                int i = 0;
                short index = indices[i];
                while (index != -1) {
                    if (index == Short.MIN_VALUE) {
                        features = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    features += (double)vals[i] * MaximumLikelihoodSemiMarkovGradient.this.lambda[index];
                    index = indices[++i];
                }
                if (MaximumLikelihoodSemiMarkovGradient.this.modelInfo.maxStateLengths[potential] > 1) {
                    MaximumLikelihoodSemiMarkovGradient.this.starterAlpha[potential] = features;
                    continue;
                }
                currentAlpha[potential] = MaximumLikelihoodSemiMarkovGradient.exp(features);
            }
        }
    }
}

